<?php
    include_once ("../utilerias/algoritmos.php"); 
    include_once ("../utilerias/valida_Receive.php");
    $accion = get_POST("accion"); 

    // Para Insertar
    if ($accion=="Insertar") {
        $cliente_id = get_POST("cliente_id"); 
        $fecha      = get_POST("fecha"); 
        $foliofiscal= get_POST("foliofiscal"); 
        $empresa_id = get_POST("empresa_id"); 
        $formapago  = get_POST("formapago"); 
        $metodopago = get_POST("metodopago"); 
        $moneda     = get_POST("moneda"); 
        $tipo       = get_POST("tipo"); 

        $subtotal   = clean_Number(get_POST("subtotal")); 
        $cfdi_iva_traslado = clean_Number(get_POST("cfdi_iva_traslado")); 
        $cfdi_ieps_traslado= clean_Number(get_POST("cfdi_ieps_traslado")); 
        $cfdi_iva_retenido = clean_Number(get_POST("cfdi_iva_retenido")); 
        $cfdi_isr_retenido = clean_Number(get_POST("cfdi_isr_retenido")); 
        $total      = clean_Number(get_POST("total")); 
        $descuento  = clean_Number(get_POST("cfdi_descuento")); 

        $cfdiuso    = get_POST("cfdiuso"); 
        $serie      = get_POST("serie"); 
        $folio      = get_POST("folio"); 
        $observaciones=get_POST("observaciones");
        $montol     = get_POST("montol"); 
        $nopedido    = get_POST("nopedido"); 
        $nocotizacion= get_POST("nocotizacion"); 
 
        //$cfdi_version  = get_POST("cfdi_version"); 
        insertar_factura( $cliente_id , $fecha , $foliofiscal , $empresa_id , $formapago, $metodopago, $moneda , $tipo, $subtotal, $cfdi_iva_traslado, $cfdi_ieps_traslado, $cfdi_iva_retenido, $cfdi_isr_retenido, $total, $descuento, $cfdiuso, $serie , $folio, $observaciones, $montol, $nopedido, $nocotizacion );
    }

    // Para Editar
    if ($accion=="Editar") {
        $id  = get_POST_Required("id");     
        $cliente_id  = get_POST("cliente_id"); 
        $fecha  = get_POST("fecha"); 
        $foliofiscal  = get_POST("foliofiscal"); 
        $empresa_id  = get_POST("empresa_id"); 
        $moneda  = get_POST("moneda"); 
        $folio  = get_POST("folio"); 
        editar_factura( $cliente_id, $fecha, $foliofiscal, $empresa_id, $moneda, $folio, $id );
    }

    if ($accion == "Eliminar") {
        $id  = get_POST_Required("id"); 
        eliminar_factura ($id);
    }

    if ($accion == "Duplicado") {
        $campo = get_POST("campo");
        $valor = get_POST("valor");
        get_factura_Duplicado( $campo, $valor );
    }
    // Integración de reporte
    if ($accion == "Reporte"){
        $busquda_array  = array(   
            'cliente_id' => array( 'cliente_id'=> 'buscar_cliente_id',  'tipo'=> 'igual') , 
            'folio' => array( 'folio'=> 'buscar_folio',  'tipo'=> 'igual') ,
            'serie' => array( 'serie'=> 'buscar_serie',  'tipo'=> 'like') ,
            'fecha' => array( 'fecha'=> 'buscar_fecha',  'tipo'=> 'like') );
        $queryCondition = busca_array_param_joins ( $busquda_array ); 
        get_factura_reporte_JSON( $queryCondition );
    }
    if ($accion == "Imprime"){  
        $folio = get_POST_Required("folio");  
        $serie = get_POST_Required("serie");  
        get_facturapago_imprime_JSON($folio, $serie);
    }

    if ($accion=="Eliminar_prefactura") {
        $tipo  = get_POST_Required('tipo');
        $folio = get_POST_Required('folio');
        $serie = get_POST_Required('serie');
        //$rfc   = get_POST_Required('rfc');
        eliminar_factura_funcion($folio, $serie); 
    }
    if ($accion == "GetFolio"){ 
        $serie = get_POST("serie");
        get_folio_factura($serie);
    }

    if (isset($_GET['accion'])){
        if ($_GET["accion"]=="get_All"){  
            get_factura_JSON2("");
        }
    }



function insertar_factura($cliente_id , $fecha , $foliofiscal , $empresa_id , $formapago, $metodopago,  $moneda , $tipo, $subtotal, $cfdi_iva_traslado, $cfdi_ieps_traslado, $cfdi_iva_retenido, $cfdi_isr_retenido, $total, $descuento, $cfdiuso, $serie , $folio, $observaciones, $montol , $nopedido, $nocotizacion ){
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

	$registro = SQL_save($pdo, 'factura', ['cliente_id', 'fecha', 'foliofiscal', 'empresa_id', 'formapago', 'metodopago', 'moneda', 'tipo', 'subtotal', 'cfdi_iva_traslado', 'cfdi_ieps_traslado', 'cfdi_iva_retenido', 'cfdi_isr_retenido', 'total', 'cfdidescuento', 'cfdiuso','serie', 'folio',  'observaciones', 'montol'], [ $cliente_id, $fecha, $foliofiscal, $empresa_id, $formapago, $metodopago, $moneda, $tipo, $subtotal, $cfdi_iva_traslado, $cfdi_ieps_traslado, $cfdi_iva_retenido, $cfdi_isr_retenido, $total, $descuento, $cfdiuso,  $serie, $folio, $observaciones, $montol ]);
    if ($registro > 0){
        $msg = "Ingresado exitosamente";

        // Ejecuto consulta de los conceptos temporales
        $sql_conceptos    = "SELECT * FROM  factura_detalles_temporal WHERE 1 ";
        $temporales  = SQL_MultiFetch ($pdo, $sql_conceptos, null);

        if (strlen($nopedido)>1 || strlen($nocotizacion)>1){  
            $registropedi = SQL_save($pdo, 'pedido', ['empresa_id','cliente_id', 'serie', 'folio','fecha',   'observaciones', 'nopedido', 'nocotizacion' ], [ $empresa_id,$cliente_id, $serie, $folio, $fecha, $observaciones, $nopedido, $nocotizacion ]);
        }
        
        if (!empty($temporales)){
            foreach($temporales as $k=>$v) { 
                    $reg_concepto = SQL_save($pdo, 'facturadetalle', ['empresa_id', 'cliente_id', 'serie', 'facturaid', 'cantidad', 'punitario', 'total', 'descuento', 'descripcion', 'unidadm',   'claveprodserv', 'claveunidad', 'numeroidentificacion', 'iva_traslado_tasa', 'iva_traslado_factor', 'iva_traslado_importe', 'iva_traslado_impuesto', 'ieps_traslado_tasa', 'ieps_traslado_factor', 'ieps_traslado_importe', 'ieps_traslado_impuesto', 'iva_retenido_tasa', 'iva_retenido_factor', 'iva_retenido_importe', 'iva_retenido_impuesto', 'isr_retenido_tasa', 'isr_retenido_factor', 'isr_retenido_importe', 'isr_retenido_impuesto', /*'tipo',*/ /*'cporte',*/ 'objetoimp'], 
                        [ $empresa_id, $cliente_id, $serie, $folio, $temporales[$k]["cantidad"], $temporales[$k]["punitario"], $temporales[$k]["total"], $temporales[$k]["descuento"], $temporales[$k]["descripcion"], $temporales[$k]["unidadm"],   $temporales[$k]["claveprodserv"], $temporales[$k]["claveunidad"], $temporales[$k]["numeroidentificacion"], $temporales[$k]["iva_traslado_tasa"], $temporales[$k]["iva_traslado_factor"], $temporales[$k]["iva_traslado_importe"], $temporales[$k]["iva_traslado_impuesto"], $temporales[$k]["ieps_traslado_tasa"], $temporales[$k]["ieps_traslado_factor"], $temporales[$k]["ieps_traslado_importe"], $temporales[$k]["ieps_traslado_impuesto"], $temporales[$k]["iva_retenido_tasa"], $temporales[$k]["iva_retenido_factor"], $temporales[$k]["iva_retenido_importe"], $temporales[$k]["iva_retenido_impuesto"], $temporales[$k]["isr_retenido_tasa"], $temporales[$k]["isr_retenido_factor"], $temporales[$k]["isr_retenido_importe"], $temporales[$k]["isr_retenido_impuesto"], /*$temporales[$k]["tipo"],*/ /*$temporales[$k]["cporte"],*/ $temporales[$k]["objetoimp"] ]);

                    //echo "Concepto: ".$reg_concepto;
                }
                // Después de haber insertado los detalles
                $condicion_temporal = " WHERE 1 ";
                $registro_temporal = SQL_delete($pdo, 'factura_detalles_temporal',  $condicion_temporal);


            }
            
        // Se revisa si existen Relaciones
        $sql_relaciones    = "SELECT * FROM  facturarelaciona_temporal WHERE 1 ";
        $relaciones  = SQL_MultiFetch ($pdo, $sql_relaciones, null);

        if (!empty($relaciones)){
            foreach($relaciones as $k=>$v) { 
                    $reg_relacion = SQL_save($pdo, 'facturarelaciona', ['folio', 'serie', 'folio_sustituido', 'serie_sustituido', 'foliofiscal' ], 
                        [ $folio, $serie,  $relaciones[$k]["folio_sustituido"], $relaciones[$k]["serie_sustituido"], $relaciones[$k]["foliofiscal"]  ]);
                }
                // Después de haber insertado los detalles
                $condicion_temporal = " WHERE 1 ";
                $registro_temporal = SQL_delete($pdo, 'facturarelaciona_temporal',  $condicion_temporal);

            }
            
        }
    else
        $msg = "Error al insertar"; 

    $return_arr = array(
        'resultado'   => $registro, //,
        'msg'         => $msg  
    );
    echo json_encode($return_arr);
    }


    // Función Eliminar
    function eliminar_factura( $llaveprimaria ){
        include_once ("../utilerias/pdo.php");
        define ("PDO_DEBUG", "3");
        $pdo = SQL_Connect (); 
    
        $condicion = "  where id =  ".$llaveprimaria;
        $registro = SQL_delete($pdo, 'factura',  $condicion);
    
        $msg = "";
        if ($registro == 0) {
            $msg = "Eliminado exitosamente";
        }

        $return_arr = array(
            'resultado'   => $registro, //,
            'msg'         => $msg  
        );
        echo json_encode($return_arr);
   }

    function eliminar_factura_funcion( $folio, $serie ){ 
        include_once ("../utilerias/pdo.php");
        define ("PDO_DEBUG", "3");
        $pdo = SQL_Connect (); 

        // Elimina la Maestra
        $condicion = "  where folio =  ".$folio. " AND serie LIKE '$serie' ";
        $registro = SQL_delete($pdo, 'factura',  $condicion); 

        // Elimina el hijo de la Maestra
        $condicion2 = "  where facturaid =  ".$folio. " AND serie LIKE '$serie' ";
        $registro2 = SQL_delete($pdo, 'facturadetalle',  $condicion2); 
        
        // Elimina el Pedido
        $condicion3 = "  where folio =  ".$folio. " AND serie LIKE '$serie' ";
        $registro3 = SQL_delete($pdo, 'pedido',  $condicion3); 

        // Elimina las Facturas relacionadas
        //$condicion3 = "  where cfdi_id =  ".$folio. " AND serie LIKE '$serie' ";
        //$registro3 = SQL_delete($pdo, 'pago_factura_complemento',  $condicion3); 

        // Elimina las Facturas relacionadas
        $condicion3 = "  where folio =  ".$folio. " AND serie LIKE '$serie' ";
        $registro3 = SQL_delete($pdo, 'facturarelaciona',  $condicion3); 
        
        $msg = "";
        if ($registro == 0) {
            $msg = "Eliminado exitosamente";
        }

        $return_arr = array(
            'resultado'   => $registro, //,
            'msg'         => $msg  
        );
        echo json_encode($return_arr);
   } 


   // Cancelar factura. Paso 2
    function cancelar_factura_funcion( $folio, $serie ){ 
        include_once ("../utilerias/pdo.php");
        define ("PDO_DEBUG", "3");
        $pdo = SQL_Connect (); 

        $registro = SQL_update($pdo, 'factura', [ 'status' ], [ "Cancelado" ], "   WHERE folio = $folio AND serie LIKE '$serie' "  ); 

        $msg = "";
        if ($registro == 0) {
            $msg = "Cancelado exitosamente";
        }

        $return_arr = array(
            'resultado'   => $registro, //,
            'msg'         => $msg  
        );
        echo json_encode($return_arr);
   } 
 
function editar_factura($cliente_id, $fecha, $foliofiscal, $empresa_id, $moneda, $folio, $id) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $registro = SQL_update($pdo, 'factura', [ 'cliente_id', 'fecha', 'foliofiscal', 'empresa_id', 'moneda', 'folio' ], [ $cliente_id, $fecha, $foliofiscal, $empresa_id, $moneda, $folio ], "   WHERE id = $id "  ); 

    if ($registro == 0)
        $msg = "Editado exitosamente";
    else
        $msg = "Error al editar";

    $return_arr = array(
        'resultado'   => $registro, //,
        'msg'         => $msg  
    );
    echo json_encode($return_arr);
}


// Actualiza el timbrado 
//actualiza_timbrado($serie, $folio, $tipocomprobante, $foliofiscal, $csd, $csdpac, $emision, $sellodigital, $sellosat, $cadenaoriginal);
function actualiza_timbrado( $serie, $folio, $tipocomprobante, $foliofiscal, $csd, $csdpac, $emision, $sellodigital, $sellosat, $cadenaoriginal) { 
    //$cliente_id, $fecha, $foliofiscal, $empresa_id, $moneda, $folio, $id) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    // Actualiza el Timbrado
    $registro = SQL_update($pdo, 'factura', [ 'foliofiscal', 'csd', 'csdpac', 'emision', 'sellodigital', 'sellosat', 'cadenaoriginal', 'status'  ], [ $foliofiscal, $csd, $csdpac, $emision, $sellodigital, $sellosat, $cadenaoriginal, 'Timbrado'  ], "   WHERE folio = $folio AND serie LIKE '$serie' "  ); 

    // Integrado el 22 de Mayo 2023 ***********************************************
    // Actualiza el Periodo
    //include_once("../periodo/sql_periodo.php"); 
    //$da_periodo = get_periodo_abierto();
    //print_r($da_periodo); 

    // 2.- Actualiza periodo_producto
    //echo "===> : ".$total;
    //$fecha_actual = date("Y-m"); 
    //$registro = SQL_update_free($pdo, "UPDATE periodo SET facturado = facturado + $total  WHERE periodo LIKE '%$fecha_actual%' " );


    if ($registro == 0)
        $msg = "Timbrado exitosamente";
    else
        $msg = "Error al timbrar";
    /*
    $return_arr = array(
        'resultado'   => $registro, //,
        'msg'         => $msg  
    );*/
    //echo json_encode($return_arr);
    return $msg; 
}


function get_factura($folio, $serie) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT * FROM  factura WHERE folio = $folio AND serie LIKE '$serie' LIMIT 1 ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    return $datos;
}

 function get_factura_Duplicado( $campo, $valor ){
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT * FROM  factura WHERE $campo LIKE '$valor' LIMIT 1 ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    // Acá incrusto
    $existe = false;
    if (!empty($datos)) $existe = true;
        $return_arr = array(
        'resultado'   => $existe //, //,
        //'msg'         => $msg  
    );
    echo json_encode($return_arr);
 }

function get_factura_All( $condicion ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT * FROM  factura WHERE '$condicion' ";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    return $datos;
}


 function get_folio_factura( $serie ){
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT * FROM  factura WHERE serie LIKE '$serie' ORDER BY folio DESC  LIMIT 1";
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    // Acá incrusto
    $existe = false;
    $folio = 0; 

    if (!empty($datos)) $folio = $datos[0]["folio"];

    $folio++;
    $return_arr = array(
        'resultado'   => $folio //, //,
        //'msg'         => $msg  
    );
    echo json_encode($return_arr);
 }



function get_facturapago_byfolio($folio, $serie /*, $cliente_id, $empresa_id*/) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT 
            A.id as idFactura, 
            A.cliente_id, A.empresa_id, 
            B.razon_social AS cliente_nombre, B.rfc AS cliente_rfc,   
            B.id as idCliente, B.rfc AS cliente_rfc, B.cp AS cliente_cp,
            B.regimen AS cliente_regimenfiscal_clave,
            A.cfdi_version, A.folio, A.serie, 
            A.fecha, A.observaciones, 
            A.total, A.montol, A.total AS subtotal, A.total AS descuento, 
            A.formapago, A.metodopago, A.moneda,  A.condicionespago, 
            A.fechapago, A.monedapago, A.montopago,   A.foliofiscal, A.banconum, 
            A.emision, A.sellodigital, A.sellosat,  A.cadenaoriginal, A.csd, A.csdpac, 
                   
            C.razon_social as empresa_nombre, C.rfc as empresa_rfc, C.curp AS empresa_curp, 
            C.id as idEmpresa,  C.razon_social As empresa_razonsocial, 
            C.registropatronal AS empresa_registropatronal, C.riesgotrabajo AS empresa_riesgotrabajo, 
              
            C.regimenfiscal AS empresa_regimenfiscal_clave, RF.nombre AS empresa_regimenfiscal_nombre,  
            C.lugarexpedicion AS empresa_cp, 
                    
            A.cfdiuso , 
            A.cfditipocambio,    A.cfdiclaveconfirmacion, A.cfdidescuento, 
            A.cfdi_iva_traslado, A.cfdi_ieps_traslado,  A.cfdi_iva_retenido, A.cfdi_isr_retenido, 
                    
            A.rfcemisorctaord, A.nombancoordext,A. ctaordenante, 
            A.pagado, A.tipo, A.tipo2,   A.iniciales, A.usuario,   A.status, 
                
            D.id as idCFDI,  
            D.nombre as nombreCFDI, D.clave as claveCFDI, 
            E.id as idFormaPago,  E.nombre as nombreFP, E.clave as claveFP, 
            F.id as idMetodoPago,  F.nombre as nombreMP, F.clave as claveMP, 
            G.id as idMoneda,  G.nombre as nombreMoneda, G.clave as claveMoneda 

            FROM facturapago A  
            JOIN cliente B ON A.cliente_id = B.id  
            JOIN empresa C ON A.empresa_id = C.id 
            JOIN cfdiuso D ON A.cfdiuso = D.clave 
            JOIN metodopago F ON A.metodopago = F.clave 
            JOIN formapago E ON  A.formapago = E.clave 
            JOIN moneda G ON  A.monedapago = G.clave   
            LEFT JOIN regimenfiscal RF ON  RF.clave = C.regimenfiscal 
            WHERE A.folio =". $folio." AND A.serie LIKE '".$serie."' LIMIT 1 ";


            //AND A.cliente_id = ".$cliente_id." AND A.empresa_id = ".$empresa_id."  LIMIT 1  "; 
    $datos  = SQL_MultiFetch ($pdo, $sql, null);
    return $datos;
} //  // folio, serie, cliente_id, empresa_id



// Obtengo los datos que se enviarán al reporte PDF
// Add subtotal, iva_traslado, ieps_traslado, iva_retenido, isr_retenido, total
function get_factura_reporte_JSON( $condicion ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT  
    A.cliente_id, A.folio, A.serie, A.fecha, A.observaciones, A.formapago, A.metodopago, 
    A.subtotal, A.cfdi_iva_traslado, A.cfdi_ieps_traslado, A.cfdi_iva_retenido, A.cfdi_isr_retenido, A.total, 
    A.monedapago, A.foliofiscal, A.tipo, A.tipo2, A.status, B.razon_social AS cliente_nombre 
    FROM factura  A 
    JOIN cliente B ON (A.cliente_id = B.id ) 
    $condicion   ORDER BY A.id DESC "; 
    $datos  = SQL_MultiFetch ($pdo, $sql, null);

    $return_arr = array();
    if (!empty($datos)) {
        foreach($datos as $k=>$v) {  
            $return_arr[]   = array(
            'cliente_id'    => $datos[$k]["cliente_nombre"], 
            'folio'         => $datos[$k]["folio"], 
            'serie'         => $datos[$k]["serie"], 
            'fecha'         => $datos[$k]["fecha"], 
            'observaciones' => $datos[$k]["observaciones"], 
            'formapago'     => $datos[$k]["formapago"], 
            'metodopago'    => $datos[$k]["metodopago"], 
            'moneda'        => $datos[$k]["monedapago"], 
            'foliofiscal'   => $datos[$k]["foliofiscal"], 
            'tipo'          => $datos[$k]["tipo"], 
            'tipo2'         => $datos[$k]["tipo2"], 
            'subtotal'      => $datos[$k]["subtotal"], 
            'cfdi_iva_traslado' => $datos[$k]["cfdi_iva_traslado"], 
            'cfdi_ieps_traslado'=> $datos[$k]["cfdi_ieps_traslado"], 
            'cfdi_iva_retenido' => $datos[$k]["cfdi_iva_retenido"], 
            'cfdi_isr_retenido' => $datos[$k]["cfdi_isr_retenido"], 
            'total'         => $datos[$k]["total"], 
            'status'        => $datos[$k]["status"]
            );
        }
    }
    echo json_encode($return_arr);
}
//  Corrección de Reporte
 

// Obtengo los datos que se enviarán al Pago PDF
// Este proceso está superdepurado  <-------------------------- Es la referencia
function get_facturapago_imprime_JSON( $folio, $serie ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "
        SELECT A.id as idFactura, 
        A.cliente_id, A.empresa_id, 
        B.razon_social AS cliente_razonsocial, B.rfc AS cliente_rfc,  
        B.id as idCliente, B.rfc AS cliente_rfc, B.cp AS cliente_cp, 
         
        A.cfdi_version, A.folio, A.serie,  A.fecha, A.observaciones, 
        A.subtotal, A.total, A.cfdidescuento,  A.montol,  A.formapago, A.metodopago, A.moneda, 

        A.condicionespago,  A.foliofiscal, A.banconum, 
        A.emision, A.sellodigital, A.sellosat,  A.cadenaoriginal, A.csd, A.csdpac, 

        C.razon_social as empresa_nombre, C.rfc as empresa_rfc, C.curp AS empresa_curp, 
        C.id as idEmpresa,  C.razon_social As empresa_razonsocial, C.cp AS empresa_cp, 
        C.registropatronal AS empresa_registropatronal, C.riesgotrabajo AS empresa_riesgotrabajo, 
        
        C.regimenfiscal AS empresa_regimenfiscal_clave, 
        RF.nombre AS empresa_regimenfiscal_nombre, 
        B.regimen AS cliente_regimenfiscal_clave,
        RB.nombre AS cliente_regimenfiscal_nombre,  


        A.cfdiuso ,  A.cfditipocambio,  A.cfdiclaveconfirmacion,  
        A.cfdi_iva_traslado,  A.cfdi_ieps_traslado,   A.cfdi_iva_retenido,   A.cfdi_isr_retenido, 

        A.rfcemisorctaord, A.nombancoordext, A.ctaordenante, 
        A.pagado, A.tipo, A.tipo2,  A.iniciales, A.usuario,   A.status, 

        D.id as idCFDI,       D.nombre as nombreCFDI, D.clave as claveCFDI, 
        E.id as idFormaPago,  E.nombre as nombreFP, E.clave as claveFP, 
        F.id as idMetodoPago, F.nombre as nombreMP, F.clave as claveMP, 
        G.id as idMoneda,  G.nombre as nombreMoneda, G.clave as claveMoneda, 

        /* Añadidos, 19 de Marzo 2023 */
        ED.calle AS e_calle,
        ED.cp  AS e_cp,
        ED.localidad  AS e_localidad,
        /*ED.ciudad AS e_ciudad, */
        ED.estado  AS e_estado, 
        /*ED.email AS e_email, */
        ED.pais  AS e_pais, 
        ED.colonia  AS e_colonia, 
        ED.nointerior  AS e_nointerior, 
        ED.noexterior  AS e_noexterior, 
        ED.status  AS e_status, 

        CD.calle AS c_calle,
        CD.cp  AS c_cp,
        CD.localidad  AS c_localidad,
        CD.ciudad AS c_ciudad, 
        CD.estado  AS c_estado, 
        /*CD.email AS c_email, */
        CD.pais  AS c_pais, 
        CD.colonia  AS c_colonia, 
        CD.nointerior  AS c_nointerior, 
        CD.noexterior  AS c_noexterior, 
        CD.status  AS c_status,

        PED.id AS pedi_id, PED.fecha AS pedi_fecha, PED.observaciones AS pedi_observaciones, 
        PED.nocotizacion AS pedi_cotizacion, PED.nopedido AS pedi_pedido, 

        EL.nombre AS logo_nombre,
        EF.color1 AS formato_color1, EF.color2 AS formato_color2, EF.color3 AS formato_color3 


        FROM factura A  
        LEFT JOIN cliente B ON A.cliente_id = B.id 
        LEFT JOIN empresa C ON A.empresa_id = C.id 
        LEFT JOIN cfdiuso D ON A.cfdiuso = D.clave 
        LEFT JOIN metodopago F ON A.metodopago = F.clave 
        LEFT JOIN formapago E ON  A.formapago = E.clave 
        LEFT JOIN moneda G ON  A.monedapago = G.clave  
        LEFT JOIN cat_regimenfiscal RF ON  RF.clave = C.regimenfiscal 
        LEFT JOIN cat_regimenfiscal RB ON  RB.clave = B.regimen 

        LEFT JOIN empresa_direccion ED ON ( C.id = ED.empresa_id ) 
        LEFT JOIN cliente_direccion CD ON ( B.id = CD.cliente_id ) 

        LEFT JOIN empresa_logos   EL  ON ( C.id = EL.empresa_id) 
        LEFT JOIN empresa_formato EF  ON ( C.id = EF.empresa_id) 
        LEFT JOIN pedido          PED ON (A.folio = PED.folio  AND A.serie = PED.serie ) 

        WHERE A.folio = ". $folio." AND A.serie LIKE '".$serie."' LIMIT 1 ";

        // kpiscontrola.com
        // Advice. Added LEFT JOIN to JOIN querys
    $cfdi  = SQL_MultiFetch ($pdo, $sql, null); 
    
    

    
    // JOIN facturarelaciona FRE ON (FRE.folio = A.folio AND FRE.serie LIKE A.serie )
    $sqlrela = "SELECT 
        FRE.folio_sustituido AS folio_sustituido, FRE.serie_sustituido AS serie_sustituido, FRE.foliofiscal AS foliofiscal_sustituido   
        FROM facturarelaciona FRE 
        
        WHERE FRE.folio = ".$folio." AND FRE.serie LIKE '".$serie."' ";
        $cfdi_relaciona = SQL_MultiFetch ($pdo, $sqlrela, null); 
        
    // echo $sql."\n";
     //print_r($cfdi);


    $sqldeta = "SELECT 
        A.folio, A.id, A.empresa_id, A.cliente_id, A.serie, A.facturaid, A.productoid, A.cantidad, 
        A.punitario, A.total, A.descuento, A.descripcion, A.unidadm, A.claveprodserv, A.numeroidentificacion, 
        A.claveunidad, A.iva_traslado_tasa, A.iva_traslado_factor, A.iva_traslado_importe, 
        A.iva_traslado_impuesto, A.ieps_traslado_tasa, A.ieps_traslado_factor, A.ieps_traslado_importe, 
        A.ieps_traslado_impuesto, A.iva_retenido_tasa, A.iva_retenido_factor, A.iva_retenido_importe, 
        A.iva_retenido_impuesto, A.isr_retenido_tasa, A.isr_retenido_factor, A.isr_retenido_importe, 
        A.isr_retenido_impuesto, A.objetoimp  
        FROM facturadetalle A 
        WHERE A.facturaid = ".$folio." AND A.serie LIKE '".$serie."'  ";
        //C.clienteid = " . $clienteid . " AND C.empresaid = ". $empresaid. " AND C.serie LIKE '".$serie."' ";
    $cfdi_detalle = SQL_MultiFetch ($pdo, $sqldeta, null); 
    //echo "SQL: ".$sqldeta; 
    //echo "________________________________________";
    //print_r($cfdi_detalle);


        $objeto = new stdClass();
        // Elemento 1. Cabecera
        $objeto->serie      = $cfdi[0]["serie"]; 
        $objeto->folio      = $cfdi[0]["folio"]; 
        $objeto->fecha      = $cfdi[0]["fecha"];   
        $objeto->moneda     = $cfdi[0]["moneda"];   
        $objeto->tipo       = $cfdi[0]["tipo"]; 
        $objeto->subtotal   = $cfdi[0]["subtotal"]; 
        $objeto->descuento  = $cfdi[0]["cfdidescuento"]; 
        //$objeto->descuento  = $cfdi[0]["descuento"]; 
        $objeto->total      = $cfdi[0]["total"]; 
        $objeto->montol     = $cfdi[0]["montol"]; 
        $objeto->foliofiscal= $cfdi[0]["foliofiscal"]; 
        $objeto->csd        = $cfdi[0]["csd"]; 
        $objeto->csdpac     = $cfdi[0]["csdpac"];  //  add
        $objeto->emision    = $cfdi[0]["emision"]; 
        $objeto->sellodigital= $cfdi[0]["sellodigital"]; 
        $objeto->sellosat   = $cfdi[0]["sellosat"]; 
        $objeto->cadenaoriginal= $cfdi[0]["cadenaoriginal"]; 
        $objeto->status     = $cfdi[0]["status"]; 
        $objeto->empresa_razonsocial= $cfdi[0]["empresa_razonsocial"]; 
        $objeto->empresa_rfc        = $cfdi[0]["empresa_rfc"]; 
        $objeto->cliente_razonsocial= $cfdi[0]["cliente_razonsocial"]; 
        $objeto->cliente_rfc        = $cfdi[0]["cliente_rfc"]; 
        $objeto->cliente_cp         = $cfdi[0]["cliente_cp"]; 
        $objeto->uso_clave  = $cfdi[0]["claveCFDI"]; 
        $objeto->uso_nombre = $cfdi[0]["nombreCFDI"]; 

        $objeto->cfdi_iva_traslado  = $cfdi[0]["cfdi_iva_traslado"]; 
        $objeto->cfdi_ieps_traslado = $cfdi[0]["cfdi_ieps_traslado"]; 
        $objeto->cfdi_iva_retenido  = $cfdi[0]["cfdi_iva_retenido"]; 
        $objeto->cfdi_isr_retenido  = $cfdi[0]["cfdi_isr_retenido"]; 

        // Adicionales al 19 de MArzo 2023 -> Se agrega esta parte de Acá
        $objeto->empresa_regimenfiscal_clave  = $cfdi[0]["empresa_regimenfiscal_clave"];  
        $objeto->empresa_regimenfiscal_nombre = $cfdi[0]["empresa_regimenfiscal_nombre"]; 
        $objeto->cliente_regimenfiscal_clave  = $cfdi[0]["cliente_regimenfiscal_clave"];  
        $objeto->cliente_regimenfiscal_nombre = $cfdi[0]["cliente_regimenfiscal_nombre"];  
        $objeto->observaciones      = $cfdi[0]["observaciones"];
        $objeto->empresa_cp         = $cfdi[0]["empresa_cp"];
        $objeto->formapago_nombre   = $cfdi[0]["nombreFP"];
        $objeto->formapago_clave    = $cfdi[0]["claveFP"];
        $objeto->metodopago_nombre   = $cfdi[0]["nombreMP"];
        $objeto->metodopago_clave    = $cfdi[0]["claveMP"];

        $objeto->e_calle     = $cfdi[0]["e_calle"];
        $objeto->e_cp        = $cfdi[0]["e_cp"];
        $objeto->e_localidad = $cfdi[0]["e_localidad"];
        //$objeto->e_ciudad    = $cfdi[0]["e_ciudad"];
        $objeto->e_estado    = $cfdi[0]["e_estado"];
        $objeto->e_pais      = $cfdi[0]["e_pais"];
        $objeto->e_colonia   = $cfdi[0]["e_colonia"];
        $objeto->e_nointerior= $cfdi[0]["e_nointerior"];
        $objeto->e_noexterior= $cfdi[0]["e_noexterior"];
        //$objeto->e_pais     = $cfdi[0]["e_pais"];

        $objeto->c_calle     = $cfdi[0]["c_calle"];
        $objeto->c_cp        = $cfdi[0]["c_cp"];
        $objeto->c_localidad = $cfdi[0]["c_localidad"];
        $objeto->c_ciudad    = $cfdi[0]["c_ciudad"];
        $objeto->c_estado    = $cfdi[0]["c_estado"];
        $objeto->c_pais      = $cfdi[0]["c_pais"];
        $objeto->c_colonia   = $cfdi[0]["c_colonia"];
        $objeto->c_nointerior= $cfdi[0]["c_nointerior"];
        $objeto->c_noexterior= $cfdi[0]["c_noexterior"];

        $objeto->pedi_id     = $cfdi[0]["pedi_id"]; 
        $objeto->pedi_fecha  = $cfdi[0]["pedi_fecha"]; 
        $objeto->pedi_observaciones=$cfdi[0]["pedi_observaciones"]; 
        $objeto->pedi_cotizacion = $cfdi[0]["pedi_cotizacion"]; 
        $objeto->pedi_pedido = $cfdi[0]["pedi_pedido"]; 
        
        // Configuraciones
        $objeto->logo_nombre    = $cfdi[0]["logo_nombre"];
        $objeto->formato_color1 = $cfdi[0]["formato_color1"];
        $objeto->formato_color2 = $cfdi[0]["formato_color2"];
        $objeto->formato_color3 = $cfdi[0]["formato_color3"];
         

        // RElacionados 
        if (!empty($cfdi_relaciona)){
            foreach ($cfdi_relaciona as $k => $v) { 
                $objeto->relacionados[]= array ( 
                    "folio_sustituido"      => $cfdi_relaciona[$k]["folio_sustituido"],
                    "serie_sustituido"      => $cfdi_relaciona[$k]["serie_sustituido"], 
                    "foliofiscal_sustituido"=> $cfdi_relaciona[$k]["foliofiscal_sustituido"] 
                 );               

            }
        }
        
        
        if (!empty($cfdi_detalle)){
            foreach ($cfdi_detalle as $k => $v) {  
                $objeto->conceptos[]= array ( 
                    "cantidad"      => $cfdi_detalle[$k]["cantidad"],
                    "valorunitario" => $cfdi_detalle[$k]["punitario"], 
                    "importe"       => $cfdi_detalle[$k]["total"], 
                    "descuento"     => $cfdi_detalle[$k]["descuento"], //"50750", //
                    "descripcion"   => $cfdi_detalle[$k]["descripcion"],
                    "unidad"        => $cfdi_detalle[$k]["unidadm"],
                    "claveprodserv" => $cfdi_detalle[$k]["claveprodserv"],
                    "numeroidentificacion"=> $cfdi_detalle[$k]["numeroidentificacion"],
                    "claveunidad"   => $cfdi_detalle[$k]["claveunidad"],

                    "iva_traslado_tasa"     => $cfdi_detalle[$k]["iva_traslado_tasa"], 
                    "iva_traslado_factor"   => $cfdi_detalle[$k]["iva_traslado_factor"], 
                    "iva_traslado_importe"  => $cfdi_detalle[$k]["iva_traslado_importe"], 
                    "iva_traslado_impuesto" => $cfdi_detalle[$k]["iva_traslado_impuesto"], 

                    "ieps_traslado_tasa"     => $cfdi_detalle[$k]["ieps_traslado_tasa"], 
                    "ieps_traslado_factor"   => $cfdi_detalle[$k]["ieps_traslado_factor"], 
                    "ieps_traslado_importe"  => $cfdi_detalle[$k]["ieps_traslado_importe"], 
                    "ieps_traslado_impuesto" => $cfdi_detalle[$k]["ieps_traslado_impuesto"], 

                    "iva_retenido_tasa"     => $cfdi_detalle[$k]["iva_retenido_tasa"], 
                    "iva_retenido_factor"   => $cfdi_detalle[$k]["iva_retenido_factor"], 
                    "iva_retenido_importe"  => $cfdi_detalle[$k]["iva_retenido_importe"], 
                    "iva_retenido_impuesto" => $cfdi_detalle[$k]["iva_retenido_impuesto"], 

                    "isr_retenido_tasa"     => $cfdi_detalle[$k]["isr_retenido_tasa"], 
                    "isr_retenido_factor"   => $cfdi_detalle[$k]["isr_retenido_factor"], 
                    "isr_retenido_importe"  => $cfdi_detalle[$k]["isr_retenido_importe"], 
                    "isr_retenido_impuesto" => $cfdi_detalle[$k]["isr_retenido_impuesto"], 

                    "objetoimp"     => $cfdi_detalle[$k]["objetoimp"]
                );               

            }
        }

    echo json_encode($objeto);
} //616

//Método mejorado
function get_factura_JSON2( $condicion ) {
    include_once ("../utilerias/pdo.php");
    define ("PDO_DEBUG", "3");
    $pdo = SQL_Connect (); 

    $sql    = "SELECT  
    A.id, A.folio, A.serie, A.fecha, A.cliente_id, A.formapago, A.foliofiscal, A.total, A.status, B.razon_social AS cliente, C.rfc AS empresa_rfc, C.id AS empresa_id  
    FROM factura A  
    LEFT JOIN cliente B ON (A.cliente_id = B.id) 
    LEFT JOIN empresa C ON (A.empresa_id = C.id) 
    
    ORDER BY A.id DESC  
    ";
    //$condicion ORDER by A.razon_social "; 

    $datos  = SQL_MultiFetch ($pdo, $sql, null);

    $return_arr = new stdClass();
    $return_arr->recordsTotal = 0;

    $contador = 0;
    if (!empty($datos)) {
        foreach($datos as $k=>$v) {
            $contador ++;
            //if ($datos[$k]["status"]== "A") $datos[$k]["status"] = "Activo";
            //else $datos[$k]["status"] = "Inactivo";  
            
            $return_arr->data[] = array(
            'id'            => $datos[$k]["id"], 
            'folio'         => $datos[$k]["folio"], 
            'serie'         => $datos[$k]["serie"], 
            'fecha'         => $datos[$k]["fecha"],
            'cliente'       => $datos[$k]["cliente"], 
            'formapago'     => $datos[$k]["formapago"], 
            'foliofiscal'   => $datos[$k]["foliofiscal"], 
            'total'         => number_format($datos[$k]["total"], 2),
            'campo'         => $datos[$k]["folio"]."|".$datos[$k]["serie"]."|".$datos[$k]["empresa_rfc"]."|".$datos[$k]["empresa_id"]."|".$datos[$k]["status"],
            //'campo' => '<a href="#" class="circle black" onclick="showEnviar_factura()" > <span class="icon1-email"></span></a> ',
            //'fecha_creacion'=> $datos[$k]["fecha_creacion"],
            'status'        => $datos[$k]["status"]
            );
        }
    }
    $return_arr->recordsTotal = $contador;

    echo json_encode($return_arr);
}
 
?>