<?php

namespace App\Http\Controllers;

use App\Models\AgenteAduanal;
use Illuminate\Http\Request;

class AgenteAduanalController extends Controller
{
    public function index()
    {
        $agentes = AgenteAduanal::orderBy('nombre')->paginate(10);
        return view('agentes.index', compact('agentes'));
    }

    public function create()
    {
        return view('agentes.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            //'status' => 'required|in:activo,inactivo',
        ]);

        AgenteAduanal::create($validated);

        return redirect()->route('agentes.index')
            ->with('success', 'Agente aduanal creado exitosamente.');
    }

    public function show(AgenteAduanal $agente)
    {
        return view('agentes.show', compact('agente'));
    }

    public function edit(AgenteAduanal $agente)
    {
        return view('agentes.edit', compact('agente'));
    }

    public function update(Request $request, AgenteAduanal $agente)
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            //'status' => 'required|in:activo,inactivo',
        ]);

        $agente->update($validated);

        return redirect()->route('agentes.index')
            ->with('success', 'Agente aduanal actualizado exitosamente.');
    }

    public function destroy(AgenteAduanal $agente)
    {
        // Verificar si tiene órdenes asociadas
        if ($agente->ordenes()->count() > 0) {
            return redirect()->route('agentes.index')
                ->with('error', 'No se puede eliminar el agente aduanal porque tiene órdenes asociadas.');
        }

        $agente->delete();

        return redirect()->route('agentes.index')
            ->with('success', 'Agente aduanal eliminado exitosamente.');
    }
}