<?php

namespace App\Http\Controllers;

use App\Models\Approval;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\RejectionNotification;
use App\Mail\ApprovalNotification;

class ApprovalController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $approvals = Approval::whereHas('user')->where('status', 'pending')->with('user')->get();
        return view('approvals.index', compact('approvals'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $approval = Approval::with('user')->findOrFail($id);
        $action = $request->input('action'); // approve | reject

        if ($action === 'approve') {

            // Aprobar usuario
            $approval->user->role = $request->input('role', $approval->requested_role);
            $approval->user->approved = true;
            $approval->user->save();

            // Actualizar solicitud
            $approval->status = 'approved';
            $approval->approved_by = auth()->id();
            $approval->save();

            // Eliminar solicitud de aprobaciones
            $approval->delete();

        } elseif ($action === 'reject') {

            $user = $approval->user; // guardar referencia antes de borrar

            // Eliminar usuario (evita borrar admins por error)
            if ($user && $user->role !== 'administrador') {
                $user->delete();
            }

            // Eliminar solicitud
            $approval->delete();

            // Enviar correo de rechazo
            try {
                Mail::to($user->email)->send(new RejectionNotification());
            } catch (\Exception $e) {
                // opcional: log de error
            }
        }

        return redirect()
            ->route('aprobaciones.index')
            ->with('success', 'Solicitud procesada correctamente.');
    }
}
