<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rules\Password;

class ChangePasswordController extends Controller
{
    /**
     * Muestra el formulario para cambiar la contraseña
     */
    public function showChangeForm()
    {
        return view('auth.change-password');
    }

    /**
     * Actualiza la contraseña del usuario
     */
    public function update(Request $request)
    {
        $request->validate([
            'current_password' => ['required', 'current_password'],
            'new_password' => ['required', 'confirmed', Password::defaults()],
        ]);

        $user = Auth::user();
        
        $user->update([
            'password' => Hash::make($request->new_password)
        ]);

        return back()->with('status', 'Contraseña actualizada exitosamente!');
    }
}