<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Approval;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\VerificationCode;

class EmailVerificationController extends Controller
{
    public function show(Request $request)
    {
        $registrationData = session('registration_data');

        if (!$registrationData || !isset($registrationData['code'])) {
            return redirect()->route('register')->withErrors(['error' => 'Proceso de registro incompleto. Inicia el registro desde el principio.']);
        }

        return view('auth.verify-email', ['email' => $request->email]);
    }

    public function verify(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'code' => 'required|string',
        ]);

        $registrationData = session('registration_data');

        if ($registrationData && isset($registrationData['code']) && $registrationData['code'] == trim($request->code)) {
            return redirect()->route('bienvenido');
        }

        return back()->withErrors(['code' => 'Invalid verification code.']);
    }

    public function resend(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ]);

        $registrationData = session('registration_data');

        if ($registrationData && $registrationData['email'] === $request->email && isset($registrationData['code'])) {
            Mail::to($request->email)->send(new VerificationCode($registrationData['code']));
            return back()->with('status', 'Verification code sent.');
        }

        return back()->withErrors(['email' => 'User not found or already verified.']);
    }
}
