<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Approval;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BienvenidoController extends Controller
{
    public function show()
    {
        $registrationData = session('registration_data');

        if (!$registrationData) {
            return redirect()->route('register')->withErrors(['error' => 'Proceso de registro incompleto.']);
        }

        // Create user
        $user = User::create([
            'name' => $registrationData['name'],
            'email' => $registrationData['email'],
            'password' => $registrationData['password'],
            'role' => null,
            'approved' => false,
        ]);

        // Create approval
        Approval::create([
            'user_id' => $user->id,
            'requested_role' => 'compras', // Default, admin will change
            'status' => 'pending',
        ]);

        // Clear session
        session()->forget('registration_data');

        return view('bienvenido');
    }
}
