<?php
// app/Http/Controllers/ChartController.php

namespace App\Http\Controllers;

use App\Models\OrdenServiceContenedor;
use App\Models\DetalleContenedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ChartController extends Controller
{
    /**
     * Obtener datos de órdenes de servicio por mes
     */
    public function getServiceOrdersData(Request $request)
    {
        $year = $request->input('year', date('Y'));
        
        // Consulta para contar órdenes por mes
        $orders = OrdenServiceContenedor::select(
                DB::raw('MONTH(created_at) as month'),
                DB::raw('COUNT(*) as total')
            )
            ->whereYear('created_at', $year)
            ->groupBy(DB::raw('MONTH(created_at)'))
            ->orderBy('month')
            ->get();
        
        // Preparar datos para el gráfico
        $months = [];
        $data = array_fill(0, 11, 0); // Índices 0-11 para meses 1-12
        
        foreach ($orders as $order) {
            $monthIndex = $order->month - 1; // Convertir mes (1-12) a índice (0-11)
            $data[$monthIndex] = $order->total;
        }
        
        // Meses en español
        $spanishMonths = [
            'Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
            'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'
        ];
        
        return response()->json([
            'labels' => $spanishMonths,
            'data' => $data,
            'year' => $year,
            'total' => array_sum($data)
        ]);
    }
    



    /**
     * NUEVO: Obtener datos de contenedores atendidos por mes
     */
    public function getContainersData(Request $request)
    {
        $year = $request->input('year', date('Y'));
        
        // Ajusta el nombre del campo según tu modelo DetalleContenedor
        // Si el campo de fecha se llama diferente, cambia 'created_at'
        $containers = DetalleContenedor::select(
                DB::raw('MONTH(created_at) as month'),
                DB::raw('COUNT(*) as total')
            )
            ->whereYear('created_at', $year)
            ->groupBy(DB::raw('MONTH(created_at)'))
            ->orderBy('month')
            ->get();
        
        $data = array_fill(0, 12, 0);
        
        foreach ($containers as $container) {
            $monthIndex = $container->month - 1;
            $data[$monthIndex] = $container->total;
        }
        
        $spanishMonths = [
            'Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
            'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'
        ];
        
        return response()->json([
            'labels' => $spanishMonths,
            'data' => $data,
            'year' => $year,
            'total' => array_sum($data)
        ]);
    }




    /**
     * Obtener años disponibles con datos
     */
    /* Este funcionaba para una gráfica
    public function getAvailableYears()
    {
        $years = OrdenServiceContenedor::select(
                DB::raw('YEAR(created_at) as year')
            )
            ->groupBy(DB::raw('YEAR(created_at)'))
            ->orderBy('year', 'desc')
            ->pluck('year')
            ->toArray();
        
        // Si no hay años, usar el año actual
        if (empty($years)) {
            $years = [date('Y')];
        }
        
        return response()->json(['years' => $years]);
    } */



    /**
     * Obtener años disponibles con datos (combinados)
     */
    public function getAvailableYears(Request $request)
    {
        $type = $request->input('type', 'orders'); // 'orders' o 'containers'
        
        if ($type === 'containers') {
            // Años de DetalleContenedor
            $years = DetalleContenedor::select(
                    DB::raw('YEAR(created_at) as year')
                )
                ->groupBy(DB::raw('YEAR(created_at)'))
                ->orderBy('year', 'desc')
                ->pluck('year')
                ->toArray();
        } else {
            // Años de OrdenServiceContener (default)
            $years = OrdenServiceContenedor::select(
                    DB::raw('YEAR(created_at) as year')
                )
                ->groupBy(DB::raw('YEAR(created_at)'))
                ->orderBy('year', 'desc')
                ->pluck('year')
                ->toArray();
        }
        
        // Si no hay años, usar el año actual
        if (empty($years)) {
            $years = [date('Y')];
        }
        
        return response()->json(['years' => $years]);
    }

}