<?php

namespace App\Http\Controllers;

use App\Models\CuadrillaServicioContenedor;
use Illuminate\Http\Request;

class CuadrillaServicioContenedorController extends Controller
{
    public function index()
    {
        $cuadrillas = CuadrillaServicioContenedor::orderBy('nombre')->paginate(10);
        return view('cuadrillas.index', compact('cuadrillas'));
    }

    public function create()
    {
        return view('cuadrillas.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            'descripcion' => 'nullable|string',
            'status' => 'required|in:activo,inactivo',
        ]);

        CuadrillaServicioContenedor::create($validated);

        return redirect()->route('cuadrillas.index')
            ->with('success', 'Cuadrilla creada exitosamente.');
    }

    public function show(CuadrillaServicioContenedor $cuadrilla)
    {
        return view('cuadrillas.show', compact('cuadrilla'));
    }

    public function edit(CuadrillaServicioContenedor $cuadrilla)
    {
        return view('cuadrillas.edit', compact('cuadrilla'));
    }

    public function update(Request $request, CuadrillaServicioContenedor $cuadrilla)
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            'descripcion' => 'nullable|string',
            'status' => 'required|in:activo,inactivo',
        ]);

        $cuadrilla->update($validated);

        return redirect()->route('cuadrillas.index')
            ->with('success', 'Cuadrilla actualizada exitosamente.');
    }

    public function destroy(CuadrillaServicioContenedor $cuadrilla)
    {
        $cuadrilla->delete();

        return redirect()->route('cuadrillas.index')
            ->with('success', 'Cuadrilla eliminada exitosamente.');
    }
}