<?php

namespace App\Http\Controllers;

use App\Models\DetalleContenedor;
use Illuminate\Http\Request;

class DetalleContenedorController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // Este index es para gráficas
    public function index(Request $request)
    {
        $selectedYear = $request->get('year', date('Y'));
        
        // Obtener estadísticas adicionales si las necesitas
        $totalContenedores = DetalleContenedor::whereYear('worked_at', $selectedYear)->count();
        $promedioMensual = DetalleContenedor::whereYear('worked_at', $selectedYear)
            ->selectRaw('MONTH(worked_at) as month, COUNT(*) as total')
            ->groupBy('month')
            ->get()
            ->avg('total');
        
        return view('ordenes.graficas_contenedores_mes', [
            'selectedYear' => $selectedYear,
            'totalContenedores' => $totalContenedores,
            'promedioMensual' => round($promedioMensual, 2),
            // Puedes agregar más estadísticas aquí
        ]);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(DetalleContenedor $detalleContenedor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(DetalleContenedor $detalleContenedor)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DetalleContenedor $detalleContenedor)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DetalleContenedor $detalleContenedor)
    {
        //
    }



    // Este es el último funcion para gráficas
    /**
     * Mostrar la gráfica de contenedores por mes
     */
    public function graficaPorMes(Request $request)
    {
        // Obtener el año seleccionado o el año actual
        $year = $request->input('year', date('Y'));
        
        // Obtener todos los meses con datos para el año seleccionado
        $datos = DetalleContenedor::whereYear('worked_at', $year)
            ->selectRaw('MONTH(worked_at) as mes, COUNT(*) as total')
            ->groupBy('mes')
            ->orderBy('mes')
            ->get()
            ->pluck('total', 'mes')
            ->toArray();
        
        // Crear array con todos los meses (1-12) con valores iniciales en 0
        $mesesCompletos = [];
        for ($mes = 1; $mes <= 12; $mes++) {
            $mesesCompletos[$mes] = $datos[$mes] ?? 0;
        }
        
        // Nombres de los meses en español
        $nombresMeses = [
            'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
            'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
        ];
        
        // Preparar datos para la gráfica
        $mesesNombres = [];
        $valores = [];
        
        foreach ($mesesCompletos as $mes => $total) {
            $mesesNombres[] = $nombresMeses[$mes-1];
            $valores[] = $total;
        }
        
        // Obtener años disponibles para el select
        $yearsDisponibles = DetalleContenedor::selectRaw('YEAR(worked_at) as year')
            ->whereNotNull('worked_at')
            ->groupBy('year')
            ->orderBy('year', 'desc')
            ->pluck('year')
            ->toArray();
        
        // Si no hay años en la base de datos, agregar el año actual
        if (empty($yearsDisponibles)) {
            $yearsDisponibles = [date('Y')];
        }
        
        return view('ordenes.grafica_contenedor_mes', [
            'year' => $year,
            'yearsDisponibles' => $yearsDisponibles,
            'meses' => $mesesNombres,
            'valores' => $valores,
            'totalContenedores' => array_sum($valores)
        ]);
    }
}
