<?php

namespace App\Http\Controllers;

use App\Models\OrdenServiceContenedor;
use App\Models\AgenteAduanal;
use App\Models\ProveedorContenedor;
use App\Models\CuadrillaServicioContenedor;
use App\Models\OrdenContenedorDetalle;
use App\Models\DetalleContenedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use function Illuminate\Log\log;
use function Symfony\Component\Clock\now;
use App\Http\Controllers\UserController;

class OrdenServiceContenedorController extends Controller
{
    
    public function index()
    {

        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria', 'agente_aduanal', 'compras' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        $ordenes = OrdenServiceContenedor::with('agenteAduanal')
            ->orderBy('fecha', 'desc')
            ->paginate(10);
        //print_r($ordenes);
        return view('ordenes.index', compact('ordenes'));
    } 

    public function index2()
    {

        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'cuadrilla' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        $ordenes = OrdenServiceContenedor::with('agenteAduanal')
            ->where('status', 'LIKE', 'asignado')
            ->orderBy('fecha', 'desc')
            ->paginate(10);
        //print_r($ordenes);
        return view('contenedores.index2', compact('ordenes'));
    } 


    // 9 de Febrero 2026, Se actualiza con el infex para filtros y roles y permisos
public function indexNO_SE_SUA()
{
    // Obtener la consulta base con relaciones
    $query = OrdenServiceContenedor::with('agenteAduanal');
    
    // Aplicar restricción por rol
    $user = auth()->user();
    $allowedRoles = ['compras', 'receptoria', 'agente_aduanal' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

    if (auth()->user()->hasRole('agente_aduanal')) {
        // Agente solo ve sus propias órdenes
        $query->where('agente_aduanal_id', auth()->id());
    }
    // Los roles 'receptoria' y 'compras' ven todas las órdenes (sin restricción)
    
    // Aplicar filtros de búsqueda
    if (request()->has('search') && !empty(request('search'))) {
        $search = request('search');
        $query->where(function($q) use ($search) {
            $q->where('id', 'like', "%{$search}%")
              ->orWhereHas('detalles.detallesContenedor', function($q2) use ($search) {
                  $q2->where('numero', 'like', "%{$search}%");
              });
        });
    }
    
    // Filtro por fecha
    if (request()->has('fecha_desde') && !empty(request('fecha_desde'))) {
        $query->whereDate('fecha', '>=', request('fecha_desde'));
    }
    
    if (request()->has('fecha_hasta') && !empty(request('fecha_hasta'))) {
        $query->whereDate('fecha', '<=', request('fecha_hasta'));
    }
    
    // Filtro por estado
    if (request()->has('estado') && !empty(request('estado'))) {
        $query->where('estado', request('estado'));
    }
    
    // Filtro por agente aduanal (solo para recepción/compras)
    if (request()->has('agente_aduanal_id') && !empty(request('agente_aduanal_id'))) {
        $query->where('agente_aduanal_id', request('agente_aduanal_id'));
    }
    
    // Ordenar por fecha descendente
    $query->orderBy('fecha', 'desc')->orderBy('id', 'desc');
    
    // Paginar resultados
    $ordenes = $query->paginate(10);
    
    // Obtener lista de agentes para el filtro (solo para recepción/compras)
    $agentes = [];
    if (auth()->user()->hasRole(['receptoria', 'compras'])) {
        // Asumiendo que tienes un modelo AgenteAduanal
        $agentes = \App\Models\User::whereHas('roles', function($q) {
            $q->where('name', 'agente_aduanal');
        })->get(['id', 'nombre']); // Ajusta según tu modelo
        
        // O si tienes un modelo separado:
        // $agentes = \App\Models\AgenteAduanal::all(['id', 'nombre']);
    }
    
    return view('ordenes.index', compact('ordenes', 'agentes'));
}



    public function create()
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria', 'agente_aduanal' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        $agentes = AgenteAduanal::where('status', 'activo')->get();
        $proveedores = ProveedorContenedor::where('status', 'activo')->get();
        $cuadrillas = CuadrillaServicioContenedor::where('status', 'activo')->get();
        
        return view('ordenes.create', compact('agentes', 'proveedores', 'cuadrillas'));
    }

    public function store(Request $request)
    {
        log("███████████████████");
        log($request);
        
        $validated = $request->validate([
            'agente_aduanal_id' => 'required|exists:agenteaduanals,id',
            'fecha' => 'required|date',
            'observaciones' => 'nullable|string',
            //'status' => 'required|in:pendiente,proceso,completado,cancelado',
            'orden_detalles' => 'nullable|array',
            'orden_detalles.*.proveedorcontenedor_id' => 'required|exists:proveedores_contenedores,id',
            //'orden_detalles.*.cuadrillaserviciocontenedor_id' => 'required|exists:cuadrilla_servicio_contenedores,id',
            'orden_detalles.*.observaciones' => 'nullable|string',
            //'orden_detalles.*.status' => 'required|in:pendiente,en proceso,completado,cancelado',
            'orden_detalles.*.detalles' => 'nullable|array',
            'orden_detalles.*.detalles.*.numero' => 'required|string|max:50',
            'orden_detalles.*.detalles.*.observaciones' => 'nullable|string',
            //'orden_detalles.*.detalles.*.status' => 'required|in:pendiente,proceso,completado,cancelado',
        ]);
        
         //Log("/n/nValidado");
        try {
            //Log("/nInicia Transacción:");
            DB::beginTransaction();
            //Log('/Despues de iniciar');
            Log($orden = OrdenServiceContenedor::create([
                'agente_aduanal_id' => $validated['agente_aduanal_id'],
                'fecha' => $validated['fecha'],
                'observaciones' => $validated['observaciones'] ?? null,
                //'status' => $validated['status'],
            ]));
            //Log('\nOrden creada'.$orden->id);
            if (isset($validated['orden_detalles'])) {
                Log('Procesando orden_detalles', ['count' => count($validated['orden_detalles'])]);
                foreach ($validated['orden_detalles'] as $detalleData) {
                    Log($ordenDetalle = $orden-> ordenDetalles()->create([
                        'proveedor_contenedor_id' => $detalleData['proveedorcontenedor_id'],
                        //'cuadrilla_servicio_contenedor_id' => $detalleData['cuadrillaserviciocontenedor_id'],
                        'observaciones' => $detalleData['observaciones'] ?? null,
                        //'status' => $detalleData['status'],
                    ]));
                    //Log("Inserta Detalles");

                    if (isset($detalleData['detalles'])) {
                        foreach ($detalleData['detalles'] as $detalleContenedorData) {
                            $ordenDetalle->detalleContenedores()->create([
                                'numero' => $detalleContenedorData['numero'],
                                'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                //'status' => $detalleContenedorData['status'],
                            ]);
                        }
                    } //Log("Inserta Nietos");
                }
            }
            //Log("Antes del Commit");
            DB::commit();

            return redirect()->route('ordenes.index')
                ->with('success', 'Orden creada exitosamente.');
                
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', 'Error al crear la orden: ' . $e->getMessage());
            Log("\nExcepcion creada");
        }
    }

    public function show(OrdenServiceContenedor $orden)
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria', 'compras' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        $orden->load([
            'agenteAduanal',
            'ordenDetalles.proveedor',
            'ordenDetalles.cuadrilla',
            'ordenDetalles.detalleContenedores'
        ]);
        
        return view('ordenes.show', compact('orden'));
    }

    public function edit(OrdenServiceContenedor $orden)
    {

        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria', 'agente_aduanal'  ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        $orden->load([
            'ordenDetalles.proveedor',
            'ordenDetalles.cuadrilla',
            'ordenDetalles.detalleContenedores'
        ]);
        
        $agentes = AgenteAduanal::where('status', 'activo')->get();
        $proveedores = ProveedorContenedor::where('status', 'activo')->get();
        $cuadrillas = CuadrillaServicioContenedor::where('status', 'activo')->get();
        
        return view('ordenes.edit', compact('orden', 'agentes', 'proveedores', 'cuadrillas'));
    }

    public function update(Request $request, OrdenServiceContenedor $orden)
    {
        Log('Esto es EDITAR ************************************************************* ');
        //Log("\n\nDentro de Update");
        $validated = $request->validate([
            'agente_aduanal_id' => 'required|exists:agenteaduanals,id',
            'fecha' => 'required|date',
            'observaciones' => 'nullable|string',
            //'status' => 'required|in:pendiente,proceso,completado,cancelado',
            'orden_detalles' => 'nullable|array',
            'orden_detalles.*.id' => 'nullable|exists:orden_contenedor_detalles,id',
            'orden_detalles.*.proveedorcontenedor_id' => 'required|exists:proveedores_contenedores,id',
            //'orden_detalles.*.cuadrillaserviciocontenedor_id' => 'required|exists:cuadrilla_servicio_contenedores,id',
            'orden_detalles.*.observaciones' => 'nullable|string',
            //'orden_detalles.*.status' => 'required|in:pendiente,proceso,completado,cancelado',
            'orden_detalles.*.detalles' => 'nullable|array',
            'orden_detalles.*.detalles.*.id' => 'nullable|exists:detalle_contenedors,id',
            'orden_detalles.*.detalles.*.numero' => 'required|string|max:50',
            'orden_detalles.*.detalles.*.observaciones' => 'nullable|string',
            //'orden_detalles.*.detalles.*.status' => 'required|in:pendiente,proceso,completado,cancelado',
        ]);
        Log("\n\nDespués de Validar");
        try {
            DB::beginTransaction();

            $orden->update([
                'agente_aduanal_id' => $validated['agente_aduanal_id'],
                'fecha' => $validated['fecha'],
                'observaciones' => $validated['observaciones'] ?? null,
                //'status' => $validated['status'],
            ]);
            Log("Actualiza Master");
            // Obtener IDs existentes
            $existingDetalleIds = $orden->ordenDetalles->pluck('id')->toArray();
            $submittedDetalleIds = [];
            Log("Antes de Ingresra Detalles");
            if (isset($validated['orden_detalles'])) {
                foreach ($validated['orden_detalles'] as $detalleData) { 
                    if (isset($detalleData['id'])) { Log("Dentro del if 169");
                        // Actualizar detalle existente
                        $ordenDetalle = OrdenContenedorDetalle::find($detalleData['id']);
                        $ordenDetalle->update([
                            'proveedor_contenedor_id' => $detalleData['proveedorcontenedor_id'],
                            //'cuadrillaserviciocontenedor_id' => $detalleData['cuadrillaserviciocontenedor_id'],
                            'observaciones' => $detalleData['observaciones'] ?? null,
                            //'status' => $detalleData['status'],
                        ]); Log("\n177");
                        $submittedDetalleIds[] = $detalleData['id'];
                    } else {
                        // Crear nuevo detalle
                        $ordenDetalle = $orden->ordenDetalles()->create([
                            'proveedor_contenedor_id' => $detalleData['proveedorcontenedor_id'],
                            //'cuadrillaserviciocontenedor_id' => $detalleData['cuadrillaserviciocontenedor_id'],
                            'observaciones' => $detalleData['observaciones'] ?? null,
                            //'status' => $detalleData['status'],
                        ]); Log("\n186");
                        $submittedDetalleIds[] = $ordenDetalle->id;
                    }

                    // Manejar detalles de contenedor
                    if (isset($detalleData['detalles'])) {
                        $existingDetalleContenedorIds = $ordenDetalle->detalleContenedores->pluck('id')->toArray();
                        $submittedDetalleContenedorIds = [];

                        foreach ($detalleData['detalles'] as $detalleContenedorData) {
                            if (isset($detalleContenedorData['id'])) {
                                $detalleContenedor = DetalleContenedor::find($detalleContenedorData['id']);
                                $detalleContenedor->update([
                                    'numero' => $detalleContenedorData['numero'],
                                    'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                    //'status' => $detalleContenedorData['status'],
                                ]);
                                $submittedDetalleContenedorIds[] = $detalleContenedorData['id'];
                            } else {
                                $detalleContenedor = $ordenDetalle->detalleContenedores()->create([
                                    'numero' => $detalleContenedorData['numero'],
                                    'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                    //'status' => $detalleContenedorData['status'],
                                ]);
                                $submittedDetalleContenedorIds[] = $detalleContenedor->id;
                            }
                        }

                        // Eliminar detalles no enviados
                        $detallesToDelete = array_diff($existingDetalleContenedorIds, $submittedDetalleContenedorIds);
                        if (!empty($detallesToDelete)) {
                            DetalleContenedor::whereIn('id', $detallesToDelete)->delete();
                        }
                    } else {
                        // Si no hay detalles, eliminar todos
                        $ordenDetalle->detalleContenedores()->delete();
                    }
                }
            }

            // Eliminar detalles no enviados
            $detallesToDelete = array_diff($existingDetalleIds, $submittedDetalleIds);
            if (!empty($detallesToDelete)) {
                OrdenContenedorDetalle::whereIn('id', $detallesToDelete)->delete();
            }

            DB::commit();

            return redirect()->route('ordenes.index')
                ->with('success', 'Orden actualizada exitosamente.');
                
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', 'Error al actualizar la orden: ' . $e->getMessage());
        }
    }

    // vercontenedor
    public function vercontenedor(OrdenServiceContenedor $orden)
    {
    //echo "Orden:".$orden;
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'cuadrilla'  ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        $orden->load([
            'ordenDetalles.proveedor',
            'ordenDetalles.cuadrilla',
            'ordenDetalles.detalleContenedores'
        ]);
        
        $agentes = AgenteAduanal::where('status', 'activo')->get();
        $proveedores = ProveedorContenedor::where('status', 'activo')->get();
        $cuadrillas = CuadrillaServicioContenedor::where('status', 'activo')->get();
        
        return view('contenedores.vercontenedor', compact('orden', 'agentes', 'proveedores', 'cuadrillas'));
    }

    // Modificado .
    public function worked(Request $request, OrdenServiceContenedor $orden)
    { Log('Dentro de W O R KE D  ************************************************************************');
        //Log("\n\nDentro de Update");
        Log($request);
        $validated = $request->validate([ 
            'orden_detalles' => 'nullable|array',
            'orden_detalles.*.id' => 'nullable|exists:orden_contenedor_detalles,id', 
            'orden_detalles.*.detalles' => 'nullable|array',
            'orden_detalles.*.detalles.*.id' => 'nullable|exists:detalle_contenedores,id',
            'orden_detalles.*.detalles.*.numero' => 'nullable',
            'orden_detalles.*.detalles.*.trabajado' => 'nullable'
        ]);
        
        //Log('\n\n');
        Log($validated);
        //Log("\n\nDespués de Validar");
        try {
            DB::beginTransaction();
            
            $orden->update([ 
                'status' => 'en_proceso',
                'worked_at' => now()
            ]);
            
            Log("Solo actualizó el status ");
            // Obtener IDs existentes
            $existingDetalleIds = $orden->ordenDetalles->pluck('id')->toArray();
            $submittedDetalleIds = [];
            
            Log('▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄');

            if (isset($validated['orden_detalles'])) {
                foreach ($validated['orden_detalles'] as $detalleData) { 
                    
                    Log('\n');
                    if (isset($detalleData['id'])) { 
                        
                        // Actualizar detalle existente
                        $ordenDetalle = OrdenContenedorDetalle::find($detalleData['id']);
                        $ordenDetalle->update([ 
                            'status' => 'en_proceso',
                        ]); 
                        $submittedDetalleIds[] = $detalleData['id'];
                    } else {
                        
                        // Crear nuevo detalle- ESTE NO SE OCUPA
                        $ordenDetalle = $orden->ordenDetalles()->create([
                            'status' => $detalleData['status'],
                        ]); 
                        $submittedDetalleIds[] = $ordenDetalle->id;
                    }

                    //Log('Pasé 563');
                    // Manejar detalles de contenedor
                    if (isset($detalleData['detalles'])) {
                        $existingDetalleContenedorIds = $ordenDetalle->detalleContenedores->pluck('id')->toArray();
                        $submittedDetalleContenedorIds = [];
                    //Log(' 568 ');
                    //Log($detalleData['detalles']);
                        foreach ($detalleData['detalles'] as $detalleContenedorData) {

                            // Paso 1, convertir a cero
                            /////$trabajado = $request->has("orden_detalles.{$index}.detalles.{$cIndex}.trabajado") ? 1 : 0;

                            if (isset($detalleContenedorData['id'])) {
                                $detalleContenedor = DetalleContenedor::find($detalleContenedorData['id']);
                                Log('465');
                                //Log(array_key_exists('trabajado', $detalleContenedorData) ? now() : '' );
                                
                                $fecha =NULL;
                                if (isset($detalleContenedorData['trabajado'])) { Log(' EXISTE ');
                                    if ( $detalleContenedorData['trabajado'] == 1) {
                                        $detalleContenedor->update([
                                        'trabajado' => array_key_exists('trabajado', $detalleContenedorData) ? 1 : 0,
                                        'worked_at' => now(),
                                        'status' => 'en_proceso'
                                        ]);
                                    }
                                } else Log(' NO ');
                                
                                /*
                                $detalleContenedor->update([
                                    'trabajado' => array_key_exists('trabajado', $detalleContenedorData) ? 1 : 0,
                                    'worked_at' => array_key_exists('trabajado', $detalleContenedorData) ? now() : null,
                                    'status' => 'en_proceso'
                                ]);*/  

                                Log('Actualiza');
                                $submittedDetalleContenedorIds[] = $detalleContenedorData['id'];
                            } else {

                                if (isset($detalleContenedorData['trabajado'])) { Log(' EXISTE ');
                                    if ( $detalleContenedorData['trabajado'] == 1) {
                                    $detalleContenedor = $ordenDetalle->detalleContenedores()->create([
                                        'numero' => $detalleContenedorData['numero'],
                                        //'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                        'trabajado' => array_key_exists('trabajado', $detalleContenedorData) ? 1 : 0,
                                        'worked_at' => array_key_exists('trabajado', $detalleContenedorData) ? now() : null,
                                        'status' => 'en_proceso'

                                        ]); Log('Inserta');
                                        }
                                    } else Log(' NO ');
                                $submittedDetalleContenedorIds[] = $detalleContenedor->id;
                            }
                        }

                        // Eliminar detalles no enviados
                        $detallesToDelete = array_diff($existingDetalleContenedorIds, $submittedDetalleContenedorIds);
                        if (!empty($detallesToDelete)) {
                            ///////DetalleContenedor::whereIn('id', $detallesToDelete)->delete();
                        }
                    } else {
                        // Si no hay detalles, eliminar todos
                        ///////$ordenDetalle->detalleContenedores()->delete();
                    }
                }
            }

            // Eliminar detalles no enviados
            $detallesToDelete = array_diff($existingDetalleIds, $submittedDetalleIds);
            if (!empty($detallesToDelete)) {
                ///////OrdenContenedorDetalle::whereIn('id', $detallesToDelete)->delete();
            }

            DB::commit();

            return redirect()->route('contenedores.index2')
                ->with('success', 'Orden actualizada exitosamente.');
                
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', 'Error al actualizar la orden: ' . $e->getMessage());
        }
    }




    public function destroy(OrdenServiceContenedor $orden)
    {
        try {
            DB::beginTransaction();
            
            $orden->delete();
            
            DB::commit();
            
            return redirect()->route('ordenes.index')
                ->with('success', 'Orden eliminada exitosamente.');
                
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', 'Error al eliminar la orden: ' . $e->getMessage());
        }
    }


    // Se agrega para agregar CUadrillas
    public function add_cuadrillas(OrdenServiceContenedor $orden)
    {
        $orden->load([
            'ordenDetalles.proveedor',
            'ordenDetalles.cuadrilla',
            'ordenDetalles.detalleContenedores'
        ]);
        
        $agentes = AgenteAduanal::where('status', 'activo')->get();
        $proveedores = ProveedorContenedor::where('status', 'activo')->get();
        $cuadrillas = CuadrillaServicioContenedor::where('status', 'activo')->get();
        
        return view('ordenes.add_cuadrillas', compact('orden', 'agentes', 'proveedores', 'cuadrillas'));
    }

    public function update_cuadrillas(Request $request, OrdenServiceContenedor $orden)
    {
        
        Log($request);
        $validated = $request->validate([ 
            'orden_detalles' => 'nullable|array',
            'orden_detalles.*.id' => 'nullable|exists:orden_contenedor_detalles,id',
            'orden_detalles.*.cuadrillaserviciocontenedor_id' => 'required|exists:cuadrilla_servicio_contenedores,id', 
            'orden_detalles.*.detalles' => 'nullable|array',
            'orden_detalles.*.detalles.*.id' => 'nullable|exists:detalle_contenedores,id',
        ]);
        Log("\n\nDespués de Validar");
        try {
            DB::beginTransaction();

            // Solo Actualizar Status
            $orden->update([
                'status' => 'asignado',//$validated['status'], // Pero NO tengo Status
                'asignated_at' => now()
            ]);
            Log("Actualiza Master");
            // Obtener IDs existentes
            $existingDetalleIds = $orden->ordenDetalles->pluck('id')->toArray();
            $submittedDetalleIds = [];
            Log("Antes de Ingresra Detalles");
            if (isset($validated['orden_detalles'])) {
                foreach ($validated['orden_detalles'] as $detalleData) { 
                    if (isset($detalleData['id'])) { Log("Dentro del if 169");
                        // Actualizar detalle existente
                        $ordenDetalle = OrdenContenedorDetalle::find($detalleData['id']);
                        Log($ordenDetalle->update([
                            //'proveedor_contenedor_id' => $detalleData['proveedorcontenedor_id'],
                            'cuadrilla_servicio_contenedor_id' => $detalleData['cuadrillaserviciocontenedor_id'],
                            //'observaciones' => $detalleData['observaciones'] ?? null,
                            'status' => 'asignado', //$detalleData['status'],
                            'asignated_at' => now()
                        ])); Log("\n177");
                        $submittedDetalleIds[] = $detalleData['id'];
                    } else {
                        // Crear nuevo detalle
                        $ordenDetalle = $orden->ordenDetalles()->create([
                            //'proveedor_contenedor_id' => $detalleData['proveedorcontenedor_id'],
                            'cuadrilla_servicio_contenedor_id' => $detalleData['cuadrillaserviciocontenedor_id'],
                            //'observaciones' => $detalleData['observaciones'] ?? null,
                            'status' => 'asignado', //$detalleData['status'],
                            'asignated_at' => now()
                        ]); Log("\n186");
                        $submittedDetalleIds[] = $ordenDetalle->id;
                    }


                    if (isset($detalleData['detalles'])) {
                        $existingDetalleContenedorIds = $ordenDetalle->detalleContenedores->pluck('id')->toArray();
                        $submittedDetalleContenedorIds = [];

                        foreach ($detalleData['detalles'] as $detalleContenedorData) {
                            if (isset($detalleContenedorData['id'])) {
                                $detalleContenedor = DetalleContenedor::find($detalleContenedorData['id']);
                                $detalleContenedor->update([
                                    //'numero' => $detalleContenedorData['numero'],
                                    //'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                    'status' => 'asignado',
                                    'asignated_at' =>now()
                                ]);
                                $submittedDetalleContenedorIds[] = $detalleContenedorData['id'];
                            } else {
                                $detalleContenedor = $ordenDetalle->detalleContenedores()->create([
                                    //'numero' => $detalleContenedorData['numero'],
                                    //'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                    'status' => 'asignado',
                                    'asignated_at' =>now()
                                ]);
                                $submittedDetalleContenedorIds[] = $detalleContenedor->id;
                            }
                        }

                        // Eliminar detalles no enviados
                        /*
                        $detallesToDelete = array_diff($existingDetalleContenedorIds, $submittedDetalleContenedorIds);
                        if (!empty($detallesToDelete)) {
                            DetalleContenedor::whereIn('id', $detallesToDelete)->delete();
                        }
                        */
                    } else {
                        // Si no hay detalles, eliminar todos
                        //$ordenDetalle->detalleContenedores()->delete();
                    }

                    
                }
            }
            Log('\n374'); 
            // Eliminar detalles no enviados
            $detallesToDelete = array_diff($existingDetalleIds, $submittedDetalleIds);
            if (!empty($detallesToDelete)) {
                OrdenContenedorDetalle::whereIn('id', $detallesToDelete)->delete();
            }
            Log('\n380');

            DB::commit();

            return redirect()->route('ordenes.index')
                ->with('success', 'Orden actualizada exitosamente.');
                
        } catch (\Exception $e) {
            Log('\n388');
            DB::rollBack();
            return back()->with('error', 'Error al actualizar la orden: ' . $e->getMessage());
        }
    }




    // Aplica para add_trabajado
    public function add_trabajado(OrdenServiceContenedor $orden)
    {
        $orden->load([
            'ordenDetalles.proveedor',
            'ordenDetalles.cuadrilla',
            'ordenDetalles.detalleContenedores'
        ]);
        
        $agentes = AgenteAduanal::where('status', 'activo')->get();
        $proveedores = ProveedorContenedor::where('status', 'activo')->get();
        $cuadrillas = CuadrillaServicioContenedor::where('status', 'activo')->get();
        
        return view('ordenes.add_trabajado', compact('orden', 'agentes', 'proveedores', 'cuadrillas'));
    }

    public function update_trabajado(Request $request, OrdenServiceContenedor $orden)
    {
        
        Log($request);
        $validated = $request->validate([ 
            'orden_detalles' => 'nullable|array',
            'orden_detalles.*.id' => 'nullable|exists:orden_contenedor_detalles,id',
            //'orden_detalles.*.cuadrillaserviciocontenedor_id' => 'required|exists:cuadrilla_servicio_contenedores,id', 
            'orden_detalles.*.detalles' => 'nullable|array',
            'orden_detalles.*.detalles.*.id' => 'nullable|exists:detalle_contenedores,id',
        ]);
        Log("\n\nDespués de Validar");
        
        try {
            DB::beginTransaction();

            // Solo Actualizar Status
            $orden->update([
                'status' => 'completado',//$validated['status'], // Pero NO tengo Status
                //'asignated_at' => now()
            ]);
            Log("Actualiza Master");
            // Obtener IDs existentes
            $existingDetalleIds = $orden->ordenDetalles->pluck('id')->toArray();
            $submittedDetalleIds = [];
            Log("Dengtro de completado");
            if (isset($validated['orden_detalles'])) {
                foreach ($validated['orden_detalles'] as $detalleData) { 
                    if (isset($detalleData['id'])) { Log("Dentro del if 169");
                        // Actualizar detalle existente
                        $ordenDetalle = OrdenContenedorDetalle::find($detalleData['id']);
                        Log($ordenDetalle->update([
                            //'proveedor_contenedor_id' => $detalleData['proveedorcontenedor_id'],
                            //'cuadrilla_servicio_contenedor_id' => $detalleData['cuadrillaserviciocontenedor_id'],
                            //'observaciones' => $detalleData['observaciones'] ?? null,
                            'status' => 'completado', //$detalleData['status'],
                            //'asignated_at' => now()
                        ])); Log("\n177 completado");
                        $submittedDetalleIds[] = $detalleData['id'];
                    } else {
                        // Crear nuevo detalle
                        $ordenDetalle = $orden->ordenDetalles()->create([
                            //'proveedor_contenedor_id' => $detalleData['proveedorcontenedor_id'],
                            //'cuadrilla_servicio_contenedor_id' => $detalleData['cuadrillaserviciocontenedor_id'],
                            //'observaciones' => $detalleData['observaciones'] ?? null,
                            'status' => 'completado', //$detalleData['status'],
                            //'asignated_at' => now()
                        ]); Log("\n186");
                        $submittedDetalleIds[] = $ordenDetalle->id;
                    }


                    if (isset($detalleData['detalles'])) {
                        $existingDetalleContenedorIds = $ordenDetalle->detalleContenedores->pluck('id')->toArray();
                        $submittedDetalleContenedorIds = [];

                        foreach ($detalleData['detalles'] as $detalleContenedorData) {
                            if (isset($detalleContenedorData['id'])) {
                                $detalleContenedor = DetalleContenedor::find($detalleContenedorData['id']);
                                $detalleContenedor->update([
                                    //'numero' => $detalleContenedorData['numero'],
                                    //'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                    'status' => 'completado',
                                    //'asignated_at' =>now()
                                ]);
                                $submittedDetalleContenedorIds[] = $detalleContenedorData['id'];
                            } else {
                                $detalleContenedor = $ordenDetalle->detalleContenedores()->create([
                                    //'numero' => $detalleContenedorData['numero'],
                                    //'observaciones' => $detalleContenedorData['observaciones'] ?? null,
                                    'status' => 'completado',
                                    //'asignated_at' =>now()
                                ]);
                                $submittedDetalleContenedorIds[] = $detalleContenedor->id;
                            }
                        }

                        // Eliminar detalles no enviados
                        /*
                        $detallesToDelete = array_diff($existingDetalleContenedorIds, $submittedDetalleContenedorIds);
                        if (!empty($detallesToDelete)) {
                            DetalleContenedor::whereIn('id', $detallesToDelete)->delete();
                        }
                        */
                    } else {
                        // Si no hay detalles, eliminar todos
                        //$ordenDetalle->detalleContenedores()->delete();
                    }

                    
                }
            }
            Log('\n374'); 
            // Eliminar detalles no enviados
            $detallesToDelete = array_diff($existingDetalleIds, $submittedDetalleIds);
            if (!empty($detallesToDelete)) {
                OrdenContenedorDetalle::whereIn('id', $detallesToDelete)->delete();
            }
            Log('\n380');

            DB::commit();

            return redirect()->route('ordenes.index')
                ->with('success', 'Orden actualizada exitosamente.');
                
        } catch (\Exception $e) {
            Log('\n388');
            DB::rollBack();
            return back()->with('error', 'Error al actualizar la orden: ' . $e->getMessage());
        }
    }


    
    // Se agrega método para Imprimir
    // app/Http/Controllers/OrdenServiceContenedorController.php - Agregar antes del método destroy
    public function imprimir(OrdenServiceContenedor $orden)
    { 
        // Lo recibe correctamente
        $orden->load([
            'agenteAduanal',
            'ordenDetalles.proveedor',
            'ordenDetalles.cuadrilla',
            'ordenDetalles.detalleContenedores'
        ]);
        
        // Calcular totales
        $totalContenedores = 0;
        foreach ($orden->ordenDetalles as $detalle) {
            $totalContenedores += $detalle->detalleContenedores->count();
        }
        
        return view('ordenes.imprimir', compact('orden', 'totalContenedores'));
    }




    // Se Agregan métodos para las gráficas
    public function estadisticas()
    {
        // Obtener estadísticas de órdenes por mes del año actual
        $estadisticas = DB::table('orden_service_contenedores')
            ->select(DB::raw('MONTH(fecha) as mes'), DB::raw('COUNT(*) as total'))
            ->whereYear('fecha', date('Y'))
            ->groupBy(DB::raw('MONTH(fecha)'))
            ->orderBy('mes')
            ->get();
        
        // Preparar datos para la gráfica
        $meses = [];
        $totales = [];
        
        // Meses en español
        $mesesEspanol = [
            1 => 'Ene', 2 => 'Feb', 3 => 'Mar', 4 => 'Abr', 
            5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Ago',
            9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dic'
        ];
        
        // Inicializar todos los meses con 0
        for ($i = 1; $i <= 12; $i++) {
            $meses[] = $mesesEspanol[$i];
            $totales[$i] = 0;
        }
        
        // Asignar los valores reales
        foreach ($estadisticas as $estadistica) {
            $totales[$estadistica->mes] = $estadistica->total;
        }
        
        // Convertir el array de totales a valores simples
        $valores = array_values($totales);
        
        return view('ordenes.estadisticas', compact('meses', 'valores'));
    }

    // Método para obtener datos en formato JSON (para AJAX)
    public function getEstadisticasData(Request $request)
    {
        $year = $request->get('year', date('Y'));
        
        $estadisticas = DB::table('orden_service_contenedors')
            ->select(DB::raw('MONTH(fecha) as mes'), DB::raw('COUNT(*) as total'))
            ->whereYear('fecha', $year)
            ->groupBy(DB::raw('MONTH(fecha)'))
            ->orderBy('mes')
            ->get();
        
        // Obtener años disponibles
        $years = DB::table('orden_service_contenedors')
            ->select(DB::raw('YEAR(fecha) as year'))
            ->distinct()
            ->orderBy('year', 'desc')
            ->pluck('year');
        
        // Meses en español
        $mesesEspanol = [
            1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril', 
            5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto',
            9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
        ];
        
        // Preparar datos
        $labels = [];
        $data = [];
        
        // Inicializar todos los meses
        for ($i = 1; $i <= 12; $i++) {
            $labels[] = $mesesEspanol[$i];
            $data[$i] = 0;
        }
        
        // Asignar valores reales
        foreach ($estadisticas as $estadistica) {
            $data[$estadistica->mes] = $estadistica->total;
        }
        
        return response()->json([
            'labels' => $labels,
            'data' => array_values($data),
            'years' => $years,
            'selected_year' => $year
        ]);
    }

    // Método para obtener estadísticas por estado
    public function getEstadisticasEstado()
    {
        $estadisticas = DB::table('orden_service_contenedors')
            ->select('status', DB::raw('COUNT(*) as total'))
            ->groupBy('status')
            ->orderBy('total', 'desc')
            ->get();
        
        $labels = [];
        $data = [];
        $colores = [
            'pendiente' => '#FFC107',
            'proceso' => '#17A2B8',
            'completado' => '#28A745',
            'cancelado' => '#DC3545'
        ];
        
        $backgroundColors = [];
        
        foreach ($estadisticas as $estadistica) {
            $labels[] = ucfirst($estadistica->status);
            $data[] = $estadistica->total;
            $backgroundColors[] = $colores[$estadistica->status] ?? '#6C757D';
        }
        
        return response()->json([
            'labels' => $labels,
            'data' => $data,
            'backgroundColors' => $backgroundColors
        ]);
    }









    



    // Se utiliza para Graficar
        public function graficaOrdenesPorMes(Request $request)
    {
        $year = $request->input('year', date('Y'));
        
        // Obtener datos del año seleccionado
        $datos = OrdenServiceContenedor::obtenerOrdenesPorMes($year);
        
        // Crear array completo de 12 meses (1-12) con datos o ceros
        $datosCompletos = [];
        for ($mes = 1; $mes <= 12; $mes++) {
            $datosCompletos[$mes] = $datos[$mes] ?? 0;
        }
        
        // Preparar etiquetas de meses
        $meses = [
            1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril',
            5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto',
            9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
        ];
        
        $anios = OrdenServiceContenedor::obtenerAniosDisponibles();
        
        return view('ordenes.graficas', compact('datosCompletos', 'meses', 'year', 'anios'));
    }
    

}