<?php

namespace App\Http\Controllers;

use App\Models\ProveedorContenedor;
use Illuminate\Http\Request;

class ProveedorContenedorController extends Controller
{
    public function index()
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria', 'agente_aduanal' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }
        $proveedores = ProveedorContenedor::orderBy('nombre')->paginate(10);
        return view('proveedores.index', compact('proveedores'));
    }

    public function create()
    {
        // Se integran roles y permisos
        //if (auth()->user()->role !== 'receptoria' || auth()->user()->role !== 'agente_aduanal') {
        //    abort(403, 'Acceso denegado');
        //}
        $user = auth()->user();
        $allowedRoles = [ 'receptoria', 'agente_aduanal' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        return view('proveedores.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            //'status' => 'required|in:activo,inactivo',
        ]);

        ProveedorContenedor::create($validated);

        return redirect()->route('proveedores.index')
            ->with('success', 'Proveedor creado exitosamente.');
    }

    public function show(ProveedorContenedor $proveedor)
    {
        return view('proveedores.show', compact('proveedor'));
    }

    public function edit(ProveedorContenedor $proveedor)
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria', 'agente_aduanal' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }
        return view('proveedores.edit', compact('proveedor'));
    }

    public function update(Request $request, ProveedorContenedor $proveedor)
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            //'status' => 'required|in:activo,inactivo',
        ]);

        $proveedor->update($validated);

        return redirect()->route('proveedores.index')
            ->with('success', 'Proveedor actualizado exitosamente.');
    }

    public function destroy(ProveedorContenedor $proveedor)
    {
        // Se integran roles y permisos
        if (auth()->user()->role !== 'receptoria' || auth()->user()->role !== 'agente_aduanal' ) {
            abort(403, 'Acceso denegado');
        }
        // Verificar si tiene detalles asociados
        if ($proveedor->ordenDetalles()->count() > 0) {
            return redirect()->route('proveedores.index')
                ->with('error', 'No se puede eliminar el proveedor porque tiene órdenes asociadas.');
        }

        $proveedor->delete();

        return redirect()->route('proveedores.index')
            ->with('success', 'Proveedor eliminado exitosamente.');
    }
}