<?php

namespace App\Http\Controllers;

use App\Models\Puesto;
use Illuminate\Http\Request;


class PuestoController extends Controller
{
    public function index()
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }
        //$puestos = Puesto::latest()->get();
        $puestos = Puesto::paginate(10);
        return view('puestos.index', compact('puestos'));
    }

    public function create()
    {
        // Se integran roles y permisos
        if (auth()->user()->role !== 'receptoria') {
            abort(403, 'Acceso denegado');
        }
        return view('puestos.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nombre' => 'required',
            'descripcion' => 'required',
            'estado' => 'required|in:pendiente,completado',
        ]);

        Puesto::create($data);

        return redirect()->route('puestos.index')
            ->with('success', '¡Puesto creado con éxito!');
    }

    public function edit(Puesto $puesto)
    {

        // Se integran roles y permisos
        /*if (auth()->user()->role !== 'receptoria') {
            abort(403, 'Acceso denegado');
        }*/
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }
        return view('puestos.edit', compact('puesto'));
    }

    public function update(Request $request, Puesto $puesto)
    {
        $data = $request->validate([
            'nombre' => 'required',
            'descripcion' => 'required',
            'estado' => 'required|in:pendiente,completado',
        ]);

        $puesto->update($data);

        return redirect()->route('puestos.index')
            ->with('success', '¡Puesto actualizado con éxito!');
    }

    public function destroy(Puesto $puesto)
    {
        // Se integran roles y permisos
        if (auth()->user()->role !== 'receptoria') {
            abort(403, 'Acceso denegado');
        }
        $puesto->delete();

        return redirect()->route('puestos.index')
            ->with('success', '¡Puesto eliminada con éxito!');
    }
}
