<?php

namespace App\Http\Controllers;

use App\Mail\AdminNotification;
use App\Mail\VerificationCode;
use App\Models\Approval;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class RoleRequestController extends Controller
{
    public function show()
    {
        $registrationData = session('registration_data');

        if (!$registrationData || !isset($registrationData['email'])) {
            return redirect()->route('register')->withErrors(['error' => 'Proceso de registro incompleto. Inicia el registro desde el principio.']);
        }

        return view('auth.role-request');
    }

    public function submit(Request $request)
    {
        $request->validate([
            'role' => 'required|in:compras,receptoria,agente_aduanal',
        ]);

        $registrationData = session('registration_data');

        if (!$registrationData) {
            return redirect()->route('register')->withErrors(['error' => 'Datos de registro no encontrados.']);
        }

        // Store role in session
        session(['registration_data.role' => $request->role]);

        $code = rand(100000, 999999);

        // Store code in session for later use
        session(['registration_data.code' => $code]);

        try {
            Mail::to($registrationData['email'])->send(new VerificationCode($code));
        } catch (\Exception $e) {
            // Ignore mail errors
        }

        // Send notification to admin
        $admin = User::where('role', 'administrador')->first();
        if ($admin) {
            try {
                Mail::to($admin->email)->send(new AdminNotification($registrationData['name'], $registrationData['email'], $request->role));
            } catch (\Exception $e) {
                // Ignore mail errors
            }
        }

        return redirect()->route('email.verify.show', ['email' => $registrationData['email']]);
    }
}
