<?php

namespace App\Http\Controllers;

use App\Models\Puesto;
use App\Models\Trabajador;
use Illuminate\Http\Request;


class TrabajadorController extends Controller
{
    public function index()
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        //$trabajadores = Trabajador::latest()->get();
        $trabajadores = Trabajador::paginate(10);
        return view('trabajadores.index', compact('trabajadores'));
    }

    public function create()
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        // Obtener todos los puestos para el select
        $puestos = Puesto::orderBy('nombre')->get();
        return view('trabajadores.create', compact('puestos'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nombre' => 'required',
            'puesto_id' => 'required|exists:puestos,id', // Valida que el puesto exista
            'observaciones' => 'required',
            'estado' => 'required|in:pendiente,completado',
        ]);

        Trabajador::create($data);

        return redirect()->route('trabajadores.index')
            ->with('success', '¡Trabajador creado con éxito!');
    }

    public function edit(Trabajador $trabajador)
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }

        // Obtener todos los puestos para el select
        $puestos = Puesto::orderBy('nombre')->get();
        return view('trabajadores.edit', compact('trabajador', 'puestos'));
    }

    public function update(Request $request, Trabajador $trabajador)
    {
        $data = $request->validate([
            'nombre' => 'required',
            'observaciones' => 'required',
            'estado' => 'required|in:pendiente,completado',
        ]);

        $trabajador->update($data);

        return redirect()->route('trabajadores.index')
            ->with('success', '¡Trabajador actualizado con éxito!');
    }

    public function destroy(Trabajador $trabajador)
    {
        // Se integra Roles y Permisos
        $user = auth()->user();
        $allowedRoles = [ 'receptoria' ];

        if (!in_array($user->role, $allowedRoles)) {
            abort(403, 'Acceso denegado');
        }
        
        $trabajador->delete();

        return redirect()->route('trabajadores.index')
            ->with('success', '¡Trabajador eliminada con éxito!');
    }
}
