<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AgenteAduanal extends Model
{
    protected $table = 'agenteaduanals';
    
    protected $fillable = [
        'nombre',
        'status'
    ];

    protected $casts = [
        'status' => 'string'
    ];

    public function ordenes(): HasMany
    {
        return $this->hasMany(OrdenServiceContenedor::class, 'agenteaduanal_id');
    }
}