<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CuadrillaServicioContenedor extends Model
{
    protected $table = 'cuadrilla_servicio_contenedores';
    
    protected $fillable = [
        'nombre',
        'descripcion',
        'status'
    ];

    protected $casts = [
        'status' => 'string'
    ];

    public function ordenDetalles(): HasMany
    {
        return $this->hasMany(OrdenContenedorDetalle::class, 'cuadrillaserviciocontenedor_id');
    }
}