<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DetalleContenedor extends Model
{
    protected $table = 'detalle_contenedores';
    
    protected $fillable = [
        'orden_contenedor_detalles_id',
        'numero',
        'observaciones',
        'status',
        'asignated_at',
        'trabajado',
        'worked_at'
    ];

    protected $casts = [
        'status' => 'string',
        'asignated_at' => 'date',
    
        'trabajado' => 'boolean', // Convierte automáticamente a true/false
    //];
    ];

    public function ordenDetalle(): BelongsTo
    {
        return $this->belongsTo(OrdenContenedorDetalle::class, 'orden_contenedor_detalles_id');
    }
}