<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class OrdenContenedorDetalle extends Model
{
    protected $table = 'orden_contenedor_detalles';
    
    protected $fillable = [
        'proveedor_contenedor_id',
        'orden_service_contenedor_id',
        'cuadrilla_servicio_contenedor_id',
        'observaciones',
        'status',

        'asignated_at'
    ];

    protected $casts = [
        'status' => 'string',
        'asignated_at' => 'date'
    ];

    public function proveedor(): BelongsTo
    {
        return $this->belongsTo(ProveedorContenedor::class, 'proveedor_contenedor_id');
    }

    public function orden(): BelongsTo
    {
        return $this->belongsTo(OrdenServiceContenedor::class, 'orden_service_contenedor_id');
    }

    public function cuadrilla(): BelongsTo
    {
        return $this->belongsTo(CuadrillaServicioContenedor::class, 'cuadrilla_servicio_contenedor_id');
    }

    public function detalleContenedores(): HasMany
    {
        return $this->hasMany(DetalleContenedor::class, 'orden_contenedor_detalles_id');
    }
}