<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Casts\Attribute;

class OrdenServiceContenedor extends Model
{
    protected $table = 'orden_service_contenedores';
    
    protected $fillable = [
        'agente_aduanal_id',
        'fecha',
        'observaciones',
        'status',

        'asignated_at'

    ];

    protected $casts = [
        'fecha' => 'date',
        'asignated_at' => 'date',
        'status' => 'string'
    ];

    /*
    public function agenteAduanal(): BelongsTo
    {
        return $this->belongsTo(AgenteAduanal::class, 'agenteaduanal_id');
    }*/
    // En app/Models/OrdenServiceContenedor.php
    public function agenteAduanal()
    {
        return $this->belongsTo(AgenteAduanal::class);
    }

    public function ordenDetalles(): HasMany
    {
        return $this->hasMany(OrdenContenedorDetalle::class, 'orden_service_contenedor_id');
    }

    protected function fechaFormatted(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->fecha->format('d/m/Y'),
        );
    
    }




    // Se usa para las gráficas
    /**
     * Obtener órdenes por mes y año
     */
    public static function obtenerOrdenesPorMes($year = null)
    {
        $year = $year ?? date('Y');
        
        return self::selectRaw('MONTH(created_at) as mes, COUNT(*) as total') // Era fecha_creacion
            ->whereYear('created_at', $year)
            ->groupBy('mes')
            ->orderBy('mes')
            ->get()
            ->pluck('total', 'mes')
            ->toArray();
    }

    /**
     * Obtener años disponibles en la base de datos
     */
    public static function obtenerAniosDisponibles()
    {
        return self::selectRaw('YEAR(created_at) as year')
            ->distinct()
            ->orderBy('year', 'desc')
            ->pluck('year');
    }

}