<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProveedorContenedor extends Model
{
    protected $table = 'proveedores_contenedores';
    
    protected $fillable = [
        'nombre',
        //'status'
    ];

    protected $casts = [
        'status' => 'string'
    ];

    public function ordenDetalles(): HasMany
    {
        return $this->hasMany(OrdenContenedorDetalle::class, 'proveedorcontenedor_id');
    }
}