<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Puesto extends Model
{
    protected $fillable = [
        'nombre',
        'descripcion',
        'status',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    /**
     * Relación con trabajadores
     */
    public function trabajadores(): HasMany
    {
        return $this->hasMany(Trabajador::class);
    }
    
    /**
     * Método para verificar si el puesto puede ser eliminado
     */
    public function puedeEliminar(): bool
    {
        return $this->trabajadores()->count() === 0;
    }

    /**
     * Verificar si el puesto tiene trabajadores relacionados
     */
    public function tieneTrabajadores(): bool
    {
        return $this->trabajadores()->exists();
    }

        /**
     * Boot del modelo para prevenir eliminación si tiene trabajadores
     */
    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($puesto) {
            if ($puesto->trabajadores()->exists()) {
                // Lanza una excepción o maneja el error según prefieras
                throw new \Exception('No se puede eliminar el puesto porque tiene trabajadores asociados.');
            }
        });
    }
/*
    public function trabajadores(){
        return $this->hasMany(
            Trabajador::class
        ); 
    }*/
}