<?php

// app/Models/Trabajador.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;


class Trabajador extends Model
{
    protected $table = 'trabajadors';
    protected $fillable = [
        'puesto_id',
        'nombre',
        'observaciones',
        'status'
    ];
    
    protected $casts = [
        'status' => 'boolean'
    ];
    

    /*public function cuadrillaTrabajadores(): HasMany
    {
        return $this->hasMany(CuadrillaTrabajador::class);
    }*/

    public function canDelete(): bool
    {
        return $this->cuadrillaTrabajador()->count() === 0;
    }

    public function puesto(){
        return $this->belongsTo(Puesto::class);
    }

}