<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $driver = DB::getDriverName();
        if ($driver === 'mysql') {
            DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('compras', 'receptoria', 'agente_aduanal', 'administrador', 'cuadrilla') NULL");
        }
        // For SQLite and other databases, enum is just a string, so no change needed
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $driver = DB::getDriverName();
        if ($driver === 'mysql') {
            DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('compras', 'receptoria', 'agente_aduanal', 'administrador') NULL");
        }
        // For SQLite and other databases, no change needed
    }
};
