<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold text-gray-800">
                Lista de agentes aduanales
            </h2>

            <a href="{{ route('agentes.create') }}"
               class="bg-white text-black border border-gray-300 px-4 py-1 rounded hover:bg-gray-100">
                ➕ Nuevo
            </a>
        </div>
    </x-slot>

    {{-- SCRIPT --}}
    <script>
        function deleteModal() {
            return {
                agenteToDelete: null,

                async deleteAgente() {
                    if (!this.agenteToDelete) return;

                    await fetch(/*`/proveedores/${this.proveedorToDelete}`*/, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                            'Accept': 'application/json'
                        }
                    });

                    // quitar fila sin recargar
                    document.getElementById(`agente-${this.agenteToDelete}`)?.remove();

                    // cerrar modal
                    window.dispatchEvent(new CustomEvent('close-modal', {
                        detail: 'delete-modal'
                    }));

                    this.agenteToDelete = null;
                }
            }
        }
    </script>

    <div class="p-3" x-data="deleteModal()">
        <div class="overflow-x-auto bg-white rounded-lg shadow min-h-[80vh] flex flex-col">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Nombre</th>
                        <!--th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Descripción</th-->
                        <th class="px-8 py-3 text-center text-sm font-semibold uppercase text-black">Estado</th>
                        <th class="px-8 py-3 text-right text-sm font-semibold uppercase">Acciones</th>
                    </tr>
                </thead>

                <tbody class="divide-y divide-gray-200">
                @forelse($agentes as $agente)
                    <tr id="agente-{{ $agente->id }}" class="hover:bg-gray-50 transition">
                        <td class="px-8 py-2 text-base text-black">
                            {{ $agente->nombre }}
                        </td>

                        <!--td class="px-8 py-2 text-base text-black">
                            {{ $agente->descripcion }}
                        </td-->

                        <td class="px-8 py-2 text-center">
                            <span class="px-4 py-2 rounded-full text-sm font-semibold
                                @if($agente->estado === 'pendiente') bg-yellow-100 text-yellow-800
                                @elseif($agente->estado === 'completado') bg-green-100 text-green-800
                                @else bg-gray-100 text-gray-800
                                @endif">
                                {{ ucfirst($agente->estado) }}
                            </span>
                        </td>

                        <td class="px-8 py-2 flex justify-end gap-3">
                            <a href="{{ route('agentes.edit', $agente) }}"
                               class="text-indigo-600 hover:underline text-lg">
                                ✏️
                            </a>

                            <button
                                @click="puroveedorToDelete = {{ $agente->id }};
                                        window.dispatchEvent(new CustomEvent('open-modal', { detail: 'delete-modal' }))"
                                class="text-red-600 hover:underline text-lg">
                                🗑️
                            </button>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="px-6 py-6 text-center text-black">
                            No hay agentes registrados.
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>

        {{-- Agrega el paginador aquí Legion --}}
        <div class="mt-4 px-8 py-3">
            {{ $agentes->links() }}
        </div>

        </div>

        {{-- MODAL --}}
        <x-modal name="delete-modal" maxWidth="md">
            <div class="p-6 bg-white rounded-lg">
                <h2 class="text-lg font-medium text-gray-900">
                    Confirmar Eliminación
                </h2>

                <p class="mt-2 text-sm text-gray-600">
                    ¿Estás seguro de que deseas eliminar este agente?
                </p>

                <div class="mt-6 flex justify-end gap-3">
                    <button
                        @click="agenteToDelete = null;
                                window.dispatchEvent(new CustomEvent('close-modal', { detail: 'delete-modal' }))"
                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                        Cancelar
                    </button>

                    <button
                        @click="deleteAgente()"
                        class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">
                        Eliminar
                    </button>
                </div>
            </div>
        </x-modal>
    </div>
</x-app-layout>
