<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Aprobaciones') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="w-full mx-auto px-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <table class="w-full table-auto divide-y divide-gray-200 text-lg">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">ID</th>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">Usuario</th>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">Rol Solicitado</th>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">Estado</th>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">Acciones</th>
                            </tr>
                        </thead>

                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($approvals as $approval)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 text-base font-medium text-gray-900">
                                        {{ $approval->id }}
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-700">
                                        {{ $approval->user ? $approval->user->name : 'Usuario no encontrado' }}
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-700">
                                        {{ $approval->requested_role }}
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-700">
                                        {{ $approval->status }}
                                    </td>
                                    <td class="px-6 py-4 text-base font-medium">
                                        <button type="button" onclick="openModal({{ $approval->id }})" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-700 transition duration-200 mr-2">Aprobar</button>
                                        <form action="{{ route('aprobaciones.update', $approval->id) }}" method="POST" class="inline">
                                            @csrf
                                            @method('PUT')
                                            <input type="hidden" name="action" value="reject">
                                            <button type="submit" class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-700 transition duration-200">Rechazar</button>
                                        </form>
                                        
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div id="approvalModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 flex items-center justify-center overflow-y-auto h-full w-full hidden z-50">
        <div class="bg-white rounded-lg shadow-xl max-w-md w-full mx-4">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-xl font-semibold text-gray-900 text-center">Seleccionar Rol</h3>
            </div>
            <div class="px-6 py-6">
                <!--form id="approvalForm" action="" method="POST"-->
                <form id="approvalForm" action="/aprobaciones/{{ $approval->id }}/approve" method="POST">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="action" value="approve">
                    <div class="mb-6">
                        <label for="role" class="block text-sm font-medium text-gray-700 mb-2">Rol a Asignar</label>
                        <select name="role" id="role" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            <option value="compras">Compras</option>
                            <option value="agente_aduanal">Agente Aduanal</option>
                            <option value="receptoria">Receptoria</option>
                        </select>
                    </div>
                    <div class="flex space-x-3">
                        <button type="submit" class="flex-1 bg-blue-600 text-white px-4 py-2 rounded-md font-medium hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition duration-150">
                            Aprobar
                        </button>
                        <button type="button" onclick="closeModal()" class="flex-1 bg-gray-300 text-gray-700 px-4 py-2 rounded-md font-medium hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition duration-150">
                            Cancelar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function openModal(approvalId) {
            document.getElementById('approvalForm').action = '/aprobaciones/' + approvalId;
            document.getElementById('approvalModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('approvalModal').classList.add('hidden');
        }
    </script>
</x-app-layout>
