<x-guest-layout>
    <form method="POST" action="{{ route('email.verify') }}">
        @csrf
        <input type="hidden" name="email" value="{{ $email ?? '' }}">

        <!-- Verification Code -->
        <div class="mt-4">
            <x-input-label for="code" :value="__('Verification Code')" />
            <x-text-input id="code" class="block mt-1 w-full" type="text" name="code" :value="old('code')" required autofocus />
            <x-input-error :messages="$errors->get('code')" class="mt-2" />
        </div>

        <div class="flex items-center justify-end mt-4">
            <form method="POST" action="{{ route('email.resend') }}" class="inline">
                @csrf
                <input type="hidden" name="email" value="{{ $email ?? '' }}">
                <button type="submit" class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800">
                    {{ __('Resend Code') }}
                </button>
            </form>

            <x-primary-button class="ms-4">
                {{ __('Verify') }}
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
