<div class="bg-white rounded-lg shadow p-4 md:p-6">
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <h2 class="text-xl font-semibold text-gray-800">
            Contenedores Trabajados por Mes - {{ $selectedYear }}
        </h2>
        
        <div class="flex items-center gap-2">
            <label for="year-select" class="text-sm font-medium text-gray-700">
                Seleccionar Año:
            </label>
            <select 
                id="year-select" 
                class="block w-32 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm"
                onchange="window.location.href = '?year=' + this.value"
            >
                @foreach($years as $year)
                    <option value="{{ $year }}" {{ $selectedYear == $year ? 'selected' : '' }}>
                        {{ $year }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>

    <!-- Gráfica para PC -->
    <div class="hidden md:block">
        <div class="relative h-72">
            <div class="flex h-full items-end space-x-2">
                @foreach($chartData as $data)
                    <div class="flex-1 flex flex-col items-center">
                        <div class="w-full flex justify-center">
                            <div 
                                class="w-3/4 rounded-t-lg transition-all duration-300 hover:opacity-80"
                                style="height: {{ $data['total'] > 0 ? min(($data['total'] / max(array_column($chartData, 'total')) * 100), 100) : 2 }}%"
                                @if($data['hasData'])
                                    class="bg-blue-500"
                                @else
                                    class="bg-gray-200"
                                @endif
                            ></div>
                        </div>
                        <div class="mt-2 text-xs text-gray-600">
                            {{ $data['month'] }}
                        </div>
                        <div class="text-xs font-medium mt-1">
                            {{ $data['total'] }}
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Gráfica para móvil -->
    <div class="md:hidden">
        <div class="space-y-4">
            @foreach($chartData as $data)
                <div class="flex items-center">
                    <div class="w-12 text-sm font-medium text-gray-700">
                        {{ $data['month'] }}
                    </div>
                    <div class="flex-1 ml-2">
                        <div class="flex items-center">
                            <div class="flex-1 bg-gray-200 rounded-full h-4">
                                <div 
                                    class="h-4 rounded-full transition-all duration-300"
                                    @if($data['hasData'])
                                        class="bg-blue-500"
                                    @else
                                        class="bg-gray-300"
                                    @endif
                                    style="width: {{ $data['total'] > 0 ? min(($data['total'] / max(array_column($chartData, 'total')) * 100), 100) : 2 }}%"
                                ></div>
                            </div>
                            <div class="w-12 text-right text-sm font-medium ml-2">
                                {{ $data['total'] }}
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <!-- Leyenda -->
    <div class="mt-6 pt-4 border-t border-gray-200">
        <div class="flex flex-wrap items-center justify-center gap-4 text-sm">
            <div class="flex items-center">
                <div class="w-4 h-4 bg-blue-500 rounded mr-2"></div>
                <span class="text-gray-700">Con datos</span>
            </div>
            <div class="flex items-center">
                <div class="w-4 h-4 bg-gray-200 rounded mr-2"></div>
                <span class="text-gray-700">Sin datos registrados</span>
            </div>
        </div>
    </div>
</div>