<!-- resources/views/components/charts/service-orders-chart.blade.php -->
<div 
    x-data="serviceOrdersChart()" 
    x-init="initChart()"
    class="bg-white rounded-lg shadow p-6"
>
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-lg font-semibold text-gray-800">Órdenes de Servicio por Mes</h3>
        <div class="flex space-x-2">
            <select 
                x-model="selectedYear" 
                @change="fetchData()"
                class="border border-gray-300 rounded px-3 py-1 text-sm"
            >
                <template x-for="year in years">
                    <option x-text="year" x-bind:value="year"></option>
                </template>
            </select>
        </div>
    </div>
    
    <!-- Contenedor del gráfico -->
    <div class="relative">
        <canvas id="serviceOrdersChart" x-ref="chartCanvas"></canvas>
    </div>
    
    <!-- Estado de carga -->
    <div x-show="loading" class="text-center py-8">
        <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-blue-600"></div>
        <p class="mt-2 text-gray-600">Cargando datos...</p>
    </div>
    
    <!-- Mensaje de error -->
    <div x-show="error" class="text-center py-8 text-red-600" x-text="error"></div>
    
    <script>
        function serviceOrdersChart() {
            return {
                loading: false,
                error: null,
                selectedYear: new Date().getFullYear(),
                years: [],
                chart: null,
                
                async initChart() {
                    await this.generateYearOptions();
                    await this.fetchData();
                },
                
                async generateYearOptions() {
                    try {
                        const response = await fetch('{{ route("chart.service-orders.years") }}');
                        const data = await response.json();
                        this.years = data.years;
                        this.selectedYear = this.selectedYear || data.years[0];
                    } catch (err) {
                        console.error('Error al cargar años:', err);
                        // Generar años por defecto si hay error
                        const currentYear = new Date().getFullYear();
                        this.years = [currentYear - 2, currentYear - 1, currentYear];
                    }
                },
                
                async fetchData() {
                    this.loading = true;
                    this.error = null;
                    
                    try {
                        const response = await fetch(`{{ route("chart.service-orders.data") }}?year=${this.selectedYear}`);
                        const data = await response.json();
                        
                        this.renderChart(data);
                    } catch (err) {
                        this.error = 'Error al cargar los datos';
                        console.error(err);
                    } finally {
                        this.loading = false;
                    }
                },
                
                renderChart(data) {
                    const ctx = this.$refs.chartCanvas.getContext('2d');
                    
                    // Destruir gráfica anterior si existe
                    if (this.chart) {
                        this.chart.destroy();
                    }
                    
                    this.chart = new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: data.labels || ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                            datasets: [{
                                label: 'Órdenes de Servicio',
                                data: data.data || [],
                                backgroundColor: 'rgba(59, 130, 246, 0.5)',
                                borderColor: 'rgb(59, 130, 246)',
                                borderWidth: 1,
                                borderRadius: 4,
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: true,
                            plugins: {
                                legend: {
                                    display: true,
                                    position: 'top',
                                },
                                tooltip: {
                                    mode: 'index',
                                    intersect: false,
                                }
                            },
                            scales: {
                                y: {
                                    beginAtZero: true,
                                    ticks: {
                                        precision: 0
                                    },
                                    title: {
                                        display: true,
                                        text: 'Cantidad de Órdenes'
                                    }
                                },
                                x: {
                                    title: {
                                        display: true,
                                        text: 'Meses del Año'
                                    }
                                }
                            }
                        }
                    });

                    // Es para agregar el total
    const event = new CustomEvent('chartDataLoaded', {
        detail: {
            total: data.total || 0,
            year: this.selectedYear
        }
    });
    document.dispatchEvent(event);

                }
            }
        }
    </script>
</div>