<!-- resources/views/dashboard.blade.php -->
<!--!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Gráficas</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        .chart-container {
            height: 400px;
        }
    </style>
</head-->

<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Gráficas
        </h2>
    </x-slot>


<body class="bg-gray-100">
    <div class="min-h-screen">
        <nav class="bg-white shadow-lg">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <h1 class="text-xl font-bold text-gray-800">
                            Sistema de Órdenes y Contenedores
                        </h1>
                    </div>
                </div>
            </div>
        </nav>

        <main class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
            <div class="px-4 py-6 sm:px-0">
                <h2 class="text-2xl font-semibold text-gray-800 mb-6">
                    Dashboard de Estadísticas
                </h2>
                
                <!-- Grid con dos gráficas lado a lado -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                    <!-- Gráfica de órdenes de servicio -->
                    <div class="bg-white rounded-lg shadow">
                        <div class="p-6">
                            @include('components.charts.service-orders-chart')
                        </div>
                        <div class="border-t border-gray-200 p-4 bg-gray-50">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Total anual:</span>
                                <span class="text-lg font-bold text-blue-600" 
                                      x-text="totalOrders || '0'">
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Gráfica de contenedores atendidos -->
                    <div class="bg-white rounded-lg shadow">
                        <div class="p-6">
                            @include('components.charts.containers-chart')
                        </div>
                        <div class="border-t border-gray-200 p-4 bg-gray-50">
                            <div class="flex justify-between items-center">
                                <span class="text-gray-600">Total anual:</span>
                                <span class="text-lg font-bold text-green-600" 
                                      x-text="totalContainers || '0'">
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Resumen comparativo -->
                <div class="mt-8 bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Resumen Anual</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="border rounded-lg p-4">
                            <h4 class="font-medium text-gray-700 mb-2">Órdenes de Servicio</h4>
                            <div class="flex items-center">
                                <div class="w-4 h-4 bg-blue-500 rounded mr-2"></div>
                                <span class="text-2xl font-bold" x-text="totalOrders || '0'"></span>
                                <span class="ml-2 text-gray-600">órdenes</span>
                            </div>
                            <p class="text-sm text-gray-500 mt-2">
                                Modelo: <code class="bg-gray-100 px-1">OrdenServiceContener</code>
                            </p>
                        </div>
                        
                        <div class="border rounded-lg p-4">
                            <h4 class="font-medium text-gray-700 mb-2">Contenedores Atendidos</h4>
                            <div class="flex items-center">
                                <div class="w-4 h-4 bg-green-500 rounded mr-2"></div>
                                <span class="text-2xl font-bold" x-text="totalContainers || '0'"></span>
                                <span class="ml-2 text-gray-600">contenedores</span>
                            </div>
                            <p class="text-sm text-gray-500 mt-2">
                                Modelo: <code class="bg-gray-100 px-1">DetalleContenedor</code>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Script para manejar los eventos de ambas gráficas -->
    @push('scripts')
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('dashboard', () => ({
                totalOrders: 0,
                totalContainers: 0,
                
                init() {
                    // Escuchar eventos de las gráficas
                    document.addEventListener('chartDataLoaded', (e) => {
                        if (e.detail && e.detail.total) {
                            this.totalOrders = e.detail.total;
                        }
                    });
                    
                    document.addEventListener('containersChartLoaded', (e) => {
                        if (e.detail && e.detail.total) {
                            this.totalContainers = e.detail.total;
                        }
                    });
                }
            }));
        });
        
        // Inicializar Alpine en el body
        document.addEventListener('DOMContentLoaded', function() {
            Alpine.data('dashboard');
        });
    </script>
    @endpush


</x-app-layout>