@if(in_array(auth()->user()->role, ['cuadrilla']))
<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold text-gray-800">
                Lista de órdenes de servicio de contenedores
            </h2>

            <div class="flex items-center gap-2">
            </div>
        </div>
    </x-slot>


    <div class="p-3" x-data="deleteModal()">
        <div class="overflow-x-auto bg-white rounded-lg shadow min-h-[80vh] flex flex-col">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Id</th>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Fecha</th>
                        <th class="px-8 py-3 text-center text-sm font-semibold uppercase text-black">Estado</th>
                        <th class="px-8 py-3 text-right text-sm font-semibold uppercase">Acciones</th>
                    </tr>
                </thead>

                <tbody class="divide-y divide-gray-200">
                @forelse($ordenes as $orden)
                    <tr id="orden-{{ $orden->id }}" class="hover:bg-gray-50 transition">
                        <td class="px-8 py-2 text-base text-black">
                            {{ $orden->id }}
                        </td>
                        <td class="px-8 py-2 text-base text-black">
                            {{ \Carbon\Carbon::parse($orden->fecha)->format('d/m/Y') }}
                        </td>
                
                        
                        <td class="px-8 py-2 text-center">
                            <span class="px-4 py-2 rounded-full text-sm font-semibold
                                
                                @if($orden->status === 'asignado') bg-red-500 text-white
                                @elseif($orden->status === 'en proceso') bg-blue-400 text-blue-800
                                @else bg-gray-100 text-gray-800
                                @endif">
                                {{ ucfirst($orden->status) }}
                            </span>
                        </td>
                        <td class="px-8 py-2 flex justify-end gap-3">
                            
                            <!-- Solo puedo editar si Es Asignada y el Rece, Falta validar status -->
                            @if(in_array(auth()->user()->role, ['cuadrilla'] ) && $orden->status === 'asignado'  )
                            <a href="{{ route('contenedores.vercontenedor', $orden) }}"
                               class="text-indigo-600 hover:underline text-lg"
                               title="Ver contenedor">
                                ✏️
                            </a>
                            @endif

                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-6 text-center text-black">
                            No hay órdenes registradas con los filtros aplicados.
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>

        </div>
        
    </div>
</x-app-layout>

@endif