<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Liberación de Contenedores #{{ $orden->id }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-1 text-gray-900">
                    
                    <!-- Formulario Principal -->
                    <div class="mb-8">
                        <div class="bg-white rounded-lg shadow p-6">
                            <form method="POST" action="{{ route('contenedores.worked', $orden) }}" id="orden-form">
                                @csrf
                                <!--@ method('PUT')-->
                                <input type="hidden" value="{{ $orden->id }}" name="id">
                                <!-- Grid con 2 columnas en escritorio -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    
                                    <!-- Campo 2 - Fecha -->
                                    <div class="mb-2">
                                        <x-input-label for="fecha" :value="__('Fecha')" />
                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                {{ $orden->fecha }}
                                            </p>

                                    </div>

                                    <!-- Campo 3 - Estado (si lo necesitas) -->
                                    <div class="mb-2">
                                        <x-input-label for="status" :value="__('Estado')" />
                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                {{ $orden->status }}
                                            </p>
                                            
                                    </div>
                                </div>
                                <!-- Fin del grid -->


                                <!-- Contenedor para detalles dinámicos -->
                                <div id="detalles-container" class="mt-4">
                                    <!-- Los detalles existentes se cargarán aquí -->
                                    @foreach($orden->ordenDetalles as $index => $detalle)
                                    <div class="detalle-card border border-gray-200 rounded-lg p-4 mb-4 bg-gray-50" id="detalle-{{ $index }}">
                                        
                                        
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <input type="hidden" name="orden_detalles[{{ $index }}][id]" value="{{ $detalle->id}}" >
                                                <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 "> <!-- bg-gray-50 -->
                                                    {{ $detalle->proveedor->nombre }}
                                                </p>
                                            </div>

                                            <div>
                                                <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 "> <!-- bg-gray-50 -->
                                                    {{ $detalle->observaciones }}
                                                </p>
                                            </div>
                                        </div>
                                        
                                        <!-- Sección para Detalles de Contenedor -->
                                        <div class="mt-4">
                                            <div class="flex justify-between items-center mb-0">
                                                <x-input-label :value="__('Lista de contenedores')" class="mb-0" />
                                                <button type="button" 
                                                        onclick="agregarDetalleContenedor({{ $index }})" 
                                                        class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded-md text-sm">
                                                    + Agregar Contenedor
                                                </button>
                                            </div>
                                            <div id="detalle-contenedor-container-{{ $index }}">
                                                <!-- Los detalles de contenedor existentes -->
                                                @foreach($detalle->detalleContenedores as $cIndex => $contenedor)
                                                <div class="contenedor-card border border-gray-100 rounded p-5 mb-0 bg-white" id="contenedor-{{ $index }}-{{ $cIndex }}">
                                                    <div class="grid grid-cols-1 md:grid-cols-4 gap-2">
                                                        <div>
                                                            
                                                            <!-- Ajuste (A) -->
                                                            <input type="hidden" 
                                                                   id="id-contenedor-{{ $index }}-{{ $cIndex }}"
                                                                   name="orden_detalles[{{ $index }}][detalles][{{ $cIndex }}][id]" 
                                                                   
                                                                   value="{{ old("orden_detalles.{$index}.detalles.{$cIndex}.id", $contenedor->id) }}"
                                                                   class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">

                                                                   <!-- El número del contenedor debe ser no editable -->
                                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                                {{ $contenedor->numero }}
                                                            </p>
                                                    
                                                        </div>
                                                    
                                                        <div>
                                                            <!--p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                                { { $contenedor->observaciones }}
                                                            </p-->

                                                            <!-- En esta sección voy a colocar un Check -->
                                                            <input type="checkbox" 
                                                                id="trabajado-contenedor-{{ $index }}-{{ $cIndex }}"
                                                                name="orden_detalles[{{ $index }}][detalles][{{ $cIndex }}][trabajado]" 
                                                                value="1"
                                                                {{ old("orden_detalles.{$index}.detalles.{$cIndex}.trabajado", $contenedor->trabajado) ? 'checked' : '' }}
                                                                class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">

                                                            <label for="trabajado-contenedor-{{ $index }}-{{ $cIndex }}" class="ml-2 text-sm text-gray-700">
                                                                Trabajado
                                                            </label>

                                                        </div>

                                                        <div class="flex items-end">
                                                            
                                                            <!-- algo habrá que hacer con este botón -->
                                                            <!--button type="button" 
                                                                    onclick="eliminarDetalleContenedor({ { $index }}, { { $cIndex }})" 
                                                                    class="bg-red-500 hover:bg-red-600 text-white px-1 py-1 rounded-md text-sm">
                                                                🗑️
                                                            </button-->
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>

                                <!-- Botones al final -->
                                <div class="mt-6 flex items-center justify-between">
                                    <div>
                                        
                                        
                                    </div>
                                    <div class="flex space-x-2">
                                        <x-primary-button type="button" onclick="confirmarEliminar()" 
                                                          class="bg-red-500 hover:bg-red-600">
                                            {{ __('Eliminar') }}
                                        </x-primary-button>
                                        <x-primary-button>
                                            {{ __('Actualizar Orden') }}
                                        </x-primary-button>
                                    </div>
                                </div>
                            </form>

                            <!-- Formulario para eliminar (oculto) -->
                            <!--form id="delete-form" action="{ { route('ordenes.destroy', $orden) }}" method="POST" class="hidden">
                                @csrf
                                @method('DELETE')
                            </form-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        // Contador para detalles (comienza desde el número de detalles existentes)
        let detalleCounter = {{ $orden->ordenDetalles->count() }};
        
        // Template para detalle NUEVO (cuando se agrega uno nuevo)
       
        
        // Template para detalle de contenedor NUEVO
        const detalleContenedorTemplate = (detalleIndex, contenedorIndex) => `
            <div class="contenedor-card border border-gray-100 rounded p-5 mb-0 bg-white" id="contenedor-${detalleIndex}-${contenedorIndex}">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-2">
                    <div>
                        <input type="text" 
                               id="numero-${detalleIndex}-${contenedorIndex}"
                               name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][numero]" 
                               placeholder="Número de contenedor"
                               class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                               required>
                    </div>
                    <!--div>
                        <select id="status-contenedor-${detalleIndex}-${contenedorIndex}"
                                name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][status]" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                required>
                            <option value="pendiente">Pendiente</option>
                            <option value="proceso">En Proceso</option>
                            <option value="completado">Completado</option>
                            <option value="cancelado">Cancelado</option>
                        </select>
                    </div-->
                    <div>
                        <!--input type="text" 
                               id="observaciones-contenedor-$ {detalleIndex}-$ {contenedorIndex}"
                               name="orden_detalles[$ {detalleIndex}][detalles][$ {contenedorIndex}][observaciones]" 
                               placeholder="Observaciones"
                               class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"-->


                    <label class="inline-flex items-center">
                        <input type="checkbox" 
                        value="1"
                        checked
                               id="trabajado-${detalleIndex}-${contenedorIndex}"
                               name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][trabajado]" 
                               class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        <span class="ml-2 text-sm text-gray-600">Trabajado</span>
                    </label>



                    </div>
                    <!--div class="flex items-end">
                        <button type="button" 
                                onclick="eliminarDetalleContenedor($ {detalleIndex}, $ {contenedorIndex})" 
                                class="bg-red-500 hover:bg-red-600 text-white px-1 py-1 rounded-md text-sm">
                            🗑️
                        </button>
                    </div-->
                </div>
            </div>
        `;
        
        // Función para agregar detalle
        /*function agregarDetalle() {
            const container = document.getElementById('detalles-container');
            const html = detalleTemplate(detalleCounter);
            container.insertAdjacentHTML('beforeend', html);
            detalleCounter++;
        }*/
        
        // Función para agregar detalle de contenedor
        function agregarDetalleContenedor(detalleIndex) {
            const container = document.getElementById(`detalle-contenedor-container-${detalleIndex}`);
            const contenedorIndex = container.children.length;
            const html = detalleContenedorTemplate(detalleIndex, contenedorIndex);
            container.insertAdjacentHTML('beforeend', html);
        }
        
        
        // Función para eliminar detalle de contenedor
        function eliminarDetalleContenedor(detalleIndex, contenedorIndex) {
            const contenedor = document.getElementById(`contenedor-${detalleIndex}-${contenedorIndex}`);
            if (contenedor && confirm('¿Está seguro de eliminar este contenedor?')) {
                contenedor.remove();
                reindexarContenedores(detalleIndex);
            }
        }
        
        
        // Función para reindexar contenedores
        function reindexarContenedores(detalleIndex) {
            const contenedores = document.querySelectorAll(`#detalle-contenedor-container-${detalleIndex} .contenedor-card`);
            contenedores.forEach((contenedor, newIndex) => {
                contenedor.id = `contenedor-${detalleIndex}-${newIndex}`;
                
                contenedor.querySelectorAll('[name^="orden_detalles["]').forEach(input => {
                    const name = input.getAttribute('name');
                    const newName = name.replace(/detalles\]\[\d+\]/, `detalles][${newIndex}]`);
                    input.setAttribute('name', newName);
                    input.id = input.id.replace(/-\d+-\d+/, `-${detalleIndex}-${newIndex}`);
                });
                
                const deleteBtn = contenedor.querySelector('button');
                if (deleteBtn) {
                    deleteBtn.setAttribute('onclick', `eliminarDetalleContenedor(${detalleIndex}, ${newIndex})`);
                }
            });
        }
        
        
        // Inicializar contadores para contenedores existentes
        document.addEventListener('DOMContentLoaded', function() {
            // Agregar IDs a los contenedores existentes si no los tienen
            document.querySelectorAll('.detalle-card').forEach((detalle, detalleIndex) => {
                detalle.id = `detalle-${detalleIndex}`;
                detalle.querySelector('.flex.justify-between button').setAttribute('onclick', `eliminarDetalle(${detalleIndex})`);
                
                const contenedorBtn = detalle.querySelector('button.bg-blue-500');
                if (contenedorBtn) {
                    contenedorBtn.setAttribute('onclick', `agregarDetalleContenedor(${detalleIndex})`);
                }
                
                const contenedorContainer = detalle.querySelector('[id^="detalle-contenedor-container-"]');
                if (contenedorContainer) {
                    contenedorContainer.id = `detalle-contenedor-container-${detalleIndex}`;
                }
                
                detalle.querySelectorAll('.contenedor-card').forEach((contenedor, contIndex) => {
                    contenedor.id = `contenedor-${detalleIndex}-${contIndex}`;
                    const deleteBtn = contenedor.querySelector('button');
                    if (deleteBtn) {
                        deleteBtn.setAttribute('onclick', `eliminarDetalleContenedor(${detalleIndex}, ${contIndex})`);
                    }
                });
            });
        });
    </script>
    @endpush
</x-app-layout>