<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Agrega cuadrillas #{{ $orden->id }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-1 text-gray-900">
                    
                    <!-- Formulario Principal -->
                    <div class="mb-8">
                        <div class="bg-white rounded-lg shadow p-6">
                            <form method="POST" action="{{ route('ordenes.update_cuadrillas', $orden) }}" id="orden-form">
                                @csrf
                                @method('PUT')
                                <!-- Envío el ID de laorden -->
                                <input type="hidden" value="{{ $orden->id}}" name="id">
                                
                                <!-- Grid con 2 columnas en escritorio -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    
                                    <!-- Campo 1 - Agente Aduanal -->
                                    <div class="mb-2">
                                        <x-input-label for="agente_aduanal_id" :value="__('Agente Aduanal')" />
                                        @if($orden->agenteAduanal)
                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                {{ $orden->agenteAduanal->nombre }}
                                            </p>
                                        @else
                                        <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50 text-gray-500">
                                                No asignado
                                            </p>
                                        @endif
                                    </div>

                                    <!-- Campo 2 - Fecha -->
                                    <div class="mb-2">
                                        <x-input-label for="fecha" :value="__('Fecha')" />
                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                {{ $orden->fecha }}
                                            </p>
                                    </div>

                                    <!-- Campo 3 - Estado (si lo necesitas) -->
                                    <div class="mb-2">
                                        <x-input-label for="status" :value="__('Estado')" />
                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                {{ $orden->status }}
                                            </p>                                        
                                    </div>
                                </div>
                                <!-- Fin del grid -->

                                <!-- Campo de observaciones que ocupa el ancho completo -->
                                <div class="mt-1">
                                    <x-input-label for="observaciones" :value="__('Observaciones')" />
                                        <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                {{ $orden->observaciones }}
                                        </p>
                                </div>

                                <!-- Contenedor para detalles dinámicos -->
                                <div id="detalles-container" class="mt-4">
                                    <!-- Los detalles existentes se cargarán aquí -->
                                    
                                    @foreach($orden->ordenDetalles as $index => $detalle)
                                    <div class="detalle-card border border-gray-200 rounded-lg p-4 mb-4 bg-gray-50" id="detalle-{{ $index }}">

                                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 bg-blue-500 text-white">
                                            <div> 
                                                <input type="hidden" name="orden_detalles[{{ $index }}][id]" value="{{ $detalle->id}}" >

                                                <!--x-input-label for="proveedor-{ { $index }}" : value="__('Proveedor *')" /-->
                                                <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 "> <!-- bg-gray-50 -->
                                                {{ $detalle->proveedor->nombre }}
                                                </p>

                                            </div>

                                            <div>
                                                <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2  ">
                                                    {{ $detalle->observaciones }}
                                                </p>
                                            </div>

                                            <!-- Agrego la cuadrilla -->
                                            <div>
                                                <select id="cuadrilla-{{ $index }}" 
                                                        name="orden_detalles[{{ $index }}][cuadrillaserviciocontenedor_id]" 
                                                        class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm bg-blue-500"
                                                        required>
                                                    <option value="">Seleccionar cuadrilla</option>
                                                    @foreach($cuadrillas as $cuadrilla)
                                                        <option value="{{ $cuadrilla->id }}" 
                                                            {{ old("orden_detalles.{$index}.proveedorcontenedor_id", $detalle->proveedor_contenedor_id) == $cuadrilla->id ? 'selected' : '' }}>
                                                            {{ $cuadrilla->nombre }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>

                                        </div>
                                        
                                        <!-- Sección para Detalles de Contenedor -->
                                        <div class="mt-4">
                                            <div class="flex justify-between items-center mb-0">
                                                <x-input-label :value="__('Lista de contenedores')" class="mb-0" />

                                            </div>
                                            <div id="detalle-contenedor-container-{{ $index }}">
                                                <!-- Los detalles de contenedor existentes -->
                                                @foreach($detalle->detalleContenedores as $cIndex => $contenedor)
                                                <div class="contenedor-card border border-gray-100 rounded p-3 mb-0 bg-white" id="contenedor-{{ $index }}-{{ $cIndex }}">
                                                    <div class="grid grid-cols-1 md:grid-cols-4 gap-2">

                                                        <input type="hidden" 
                                                                   id="id-{{ $index }}-{{ $cIndex }}"
                                                                   name="orden_detalles[{{ $index }}][detalles][{{ $cIndex }}][id]" 
                                                                   value="{{ old("orden_detalles.{$index}.detalles.{$cIndex}.id", $contenedor->id) }}" >

                                                        <div>
                                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                            {{ $contenedor->numero }}
                                                            </p>                                                            
                                                        </div>

                                                        <div>
                                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                            {{ $contenedor->status }}
                                                            </p>
                                                        </div>

                                                        <div>
                                                            <p class="mt-1 block w-full border-gray-300 rounded-md shadow-sm p-2 bg-gray-50">
                                                            {{ $contenedor->observaciones }}
                                                            </p>                                                            
                                                        </div>
                                                        
                                                        
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>

                                <!-- Botones al final -->
                                <div class="mt-6 flex items-center justify-between">
                                    <div>
                                        <a href="{{ route('ordenes.index') }}" 
                                           class="mr-4 text-gray-600 hover:text-gray-900 underline">
                                            Cancelar
                                        </a>
                                    </div>

                                    <div class="flex space-x-2">
                                        <x-primary-button>
                                            {{ __('Actualizar Orden') }}
                                        </x-primary-button>
                                    </div>

                                </div>
                            </form>

                            <!-- Formulario para eliminar (oculto) -->
                            <form id="delete-form" action="{{ route('ordenes.destroy', $orden) }}" method="POST" class="hidden">
                                @csrf
                                @method('DELETE')
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</x-app-layout>