<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Crear orden de servicio para contenedores
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-1 text-gray-900">
                    
                    <!-- Formulario Principal -->
                    <div class="mb-8">
                        <div class="bg-white rounded-lg shadow p-6">
                            <form method="POST" action="{{ route('ordenes.store') }}" id="orden-form">
                                @csrf
                                
                                <!-- Grid con 2 columnas en escritorio -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    
                                    <!-- Campo 1 - Agente Aduanal -->
                                    <div class="mb-2">
                                        <x-input-label for="agente_aduanal_id" :value="__('Agente Aduanal')" />
                                        <select id="agente_aduanal_id" name="agente_aduanal_id" 
                                            class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                            <option value="">Seleccione un agente aduanal</option>
                                            @foreach($agentes as $agente)
                                                <option value="{{ $agente->id }}" 
                                                    {{ old('agente_aduanal_id') == $agente->id ? 'selected' : '' }}>
                                                    {{ $agente->nombre }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <x-input-error :messages="$errors->get('agente_aduanal_id')" class="mt-2" />
                                    </div>

                                    <!-- Campo 2 - Fecha -->
                                    <div class="mb-2">
                                        <x-input-label for="fecha" :value="__('Fecha')" />
                                        <x-text-input id="fecha" name="fecha" type="date" class="mt-1 block w-full" 
                                                      :value="old('fecha', date('Y-m-d'))" required />
                                        <x-input-error :messages="$errors->get('fecha')" class="mt-2" />
                                    </div>

                                    <!-- Campo 3 - Estado -->
                                    <!--div class="mb-4">
                                        <x-input-label for="status" : value="__('Estado')" />
                                        <select id="status" name="status" 
                                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                            <option value="pendiente" { { old('status') == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                                            <option value="completado" { { old('status') == 'completado' ? 'selected' : '' }}>Completado</option>
                                        </select>
                                        <x-input-error : messages="$errors->get('status')" class="mt-2" />
                                    </div-->
                                </div>
                                <!-- Fin del grid -->

                                <!-- Campo de observaciones que ocupa el ancho completo -->
                                <div class="mt-1">
                                    <x-input-label for="observaciones" :value="__('Observaciones')" />
                                    <textarea id="observaciones" name="observaciones" 
                                              class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" 
                                              rows="1">{{ old('observaciones') }}</textarea>
                                    <x-input-error :messages="$errors->get('observaciones')" class="mt-2" />
                                </div>

                                <!-- Botón para agregar detalles -->
                                <div class="mt-6 mb-4">
                                    <button type="button" onclick="agregarDetalle()" 
                                            class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-md">
                                        + Agregar Empresa
                                    </button>
                                </div>

                                <!-- Contenedor para detalles dinámicos -->
                                <div id="detalles-container" class="mt-4">
                                    <!-- Los detalles se agregarán aquí dinámicamente -->
                                </div>

                                <!-- Botones al final -->
                                <div class="mt-6 flex items-center justify-end">
                                    <a href="{{ route('ordenes.index') }}" 
                                       class="mr-4 text-gray-600 hover:text-gray-900 underline">
                                        Cancelar
                                    </a>
                                    <x-primary-button>
                                        {{ __('Crear Orden') }}
                                    </x-primary-button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        console.log("Línea 101 Dentro del Script ");
        // Contador para detalles
        let detalleCounter = 0;
        
        // Template para detalle
        const detalleTemplate = (index) => `
            <div class="detalle-card border border-gray-200 rounded-lg p-4 mb-4 bg-gray-50" id="detalle-${index}">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-gray-700">Empresa ${index + 1}</h3>
                    <button type="button" 
                            onclick="eliminarDetalle(${index})" 
                            class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded-md text-sm">
                        Eliminar empresa
                    </button>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <x-input-label for="proveedor-${index}" :value="__('Proveedor *')" />
                        <select id="proveedor-${index}" 
                                name="orden_detalles[${index}][proveedorcontenedor_id]" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                required>
                            <option value="">Seleccionar Proveedor</option>
                            @foreach($proveedores as $proveedor)
                                <option value="{{ $proveedor->id }}">{{ $proveedor->nombre }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <x-input-label for="observaciones-detalle-${index}" :value="__('Observaciones')" />
                        <textarea id="observaciones-detalle-${index}" 
                              name="orden_detalles[${index}][observaciones]" 
                              class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" 
                              rows="1"></textarea>
                    </div>

                    <!--div>
                        <x-input-label for="cuadrilla-${index}" :value="__('Cuadrilla *')" />
                        <select id="cuadrilla-${index}" 
                                name="orden_detalles[${index}][cuadrillaserviciocontenedor_id]" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                required>
                            <option value="">Seleccionar Cuadrilla</option>
                            @foreach($cuadrillas as $cuadrilla)
                                <option value="{{ $cuadrilla->id }}">{{ $cuadrilla->nombre }}</option>
                            @endforeach
                        </select>
                    </div-->
                    <!--div>
                        <x-input-label for="status-${index}" :value="__('Estado *')" />
                        <select id="status-${index}" 
                                name="orden_detalles[${index}][status]" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                required>
                            <option value="pendiente">Pendiente</option>
                            <option value="en proceso">En Proceso</option>
                            <option value="completado">Completado</option>
                            <option value="cancelado">Cancelado</option>
                        </select>
                    </div-->
                </div>
                
                
                
                <!-- Sección para Detalles de Contenedor -->
                <div class="mt-4">
                    <div class="flex justify-between items-center mb-0"> <!-- mb-0 Es el padding hacia abajo -->
                        <x-input-label :value="__('Lista de contenedores')" class="mb-0" />
                        <button type="button" 
                                onclick="agregarDetalleContenedor(${index})" 
                                class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded-md text-sm">
                            + Agregar Contenedor
                        </button>
                    </div>
                    <div id="detalle-contenedor-container-${index}">
                        <!-- Los detalles de contenedor se agregarán aquí -->
                    </div>
                </div>
            </div>
        `;
        
        // Template para detalle de contenedor
        const detalleContenedorTemplate = (detalleIndex, contenedorIndex) => `
            <div class="contenedor-card border border-gray-100 rounded p-5 mb-0 bg-white" id="contenedor-${detalleIndex}-${contenedorIndex}">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-2 "> <!-- mb-0 es la separacion en y, gray-300 a gray-100 -->
                    
                    <!--div>
                        
                    </div-->

                    <div>
                        <!--x-input-label for="numero-${detalleIndex}-${contenedorIndex}" :value="__('Número de Contenedor *')" /-->
                        <input type="text" 
                               id="numero-${detalleIndex}-${contenedorIndex}"
                               name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][numero]" 
                               placeholder="Número de contenedor"
                               class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                               required>
                    </div>
                    <!--div>
                        <x-input-label for="status-contenedor-${detalleIndex}-${contenedorIndex}" :value="__('Estado *')" />
                        <select id="status-contenedor-${detalleIndex}-${contenedorIndex}"
                                name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][status]" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                required>
                            <option value="pendiente">Pendiente</option>
                            <option value="proceso">En Proceso</option>
                            <option value="completado">Completado</option>
                            <option value="cancelado">Cancelado</option>
                        </select>
                    </div-->
                    <div>
                        <!--x-input-label for="observaciones-contenedor-${detalleIndex}-${contenedorIndex}" :value="__('Observaciones')" /-->
                        <input type="text" 
                               id="observaciones-contenedor-${detalleIndex}-${contenedorIndex}"
                               name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][observaciones]" 
                               placeholder="Observaciones"
                               class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                    </div>
                    <div class="flex items-end">
                        <button type="button" 
                                onclick="eliminarDetalleContenedor(${detalleIndex}, ${contenedorIndex})" 
                                class="bg-red-500 hover:bg-red-600 text-white px-1 py-1 rounded-md text-sm "> <!-- w-full Para que el botón llene todo-->
                            🗑️
                        </button>
                    </div>

                </div>
            </div>
        `;
        console.log("Dentro del Script");
        // Función para agregar detalle
        function agregarDetalle() {
            console.log("Entra a funcipon agregarDetalle() { } ");
            const container = document.getElementById('detalles-container');
            const html = detalleTemplate(detalleCounter);
            container.insertAdjacentHTML('beforeend', html);
            detalleCounter++;
        }
        
        // Función para agregar detalle de contenedor
        function agregarDetalleContenedor(detalleIndex) {
            const container = document.getElementById(`detalle-contenedor-container-${detalleIndex}`);
            const contenedorIndex = container.children.length;
            const html = detalleContenedorTemplate(detalleIndex, contenedorIndex);
            container.insertAdjacentHTML('beforeend', html);
        }
        
        // Función para eliminar detalle
        function eliminarDetalle(index) {
            const detalle = document.getElementById(`detalle-${index}`);
            if (detalle && confirm('¿Está seguro de eliminar este detalle?')) {
                detalle.remove();
                // Re-indexar los detalles restantes
                const detalles = document.querySelectorAll('.detalle-card');
                detalleCounter = 0;
                
                detalles.forEach((detalle, newIndex) => {
                    detalle.id = `detalle-${newIndex}`;
                    detalle.querySelector('h3').textContent = `Detalle ${newIndex + 1}`;
                    
                    // Actualizar los índices en los campos
                    detalle.querySelectorAll('[name^="orden_detalles["]').forEach(input => {
                        const name = input.getAttribute('name');
                        const newName = name.replace(/orden_detalles\[\d+\]/, `orden_detalles[${newIndex}]`);
                        input.setAttribute('name', newName);
                    });
                    
                    // Actualizar los botones
                    const deleteBtn = detalle.querySelector('.flex.justify-between button');
                    deleteBtn.setAttribute('onclick', `eliminarDetalle(${newIndex})`);
                    
                    // Actualizar botón de agregar contenedor
                    const contenedorBtn = detalle.querySelector('button.bg-blue-500');
                    if (contenedorBtn) {
                        contenedorBtn.setAttribute('onclick', `agregarDetalleContenedor(${newIndex})`);
                    }
                    
                    // Actualizar contenedores hijos
                    const contenedores = detalle.querySelectorAll('.contenedor-card');
                    contenedores.forEach((contenedor, contIndex) => {
                        contenedor.id = `contenedor-${newIndex}-${contIndex}`;
                        
                        contenedor.querySelectorAll('[name^="orden_detalles["]').forEach(input => {
                            const name = input.getAttribute('name');
                            const newName = name.replace(/orden_detalles\[\d+\]/, `orden_detalles[${newIndex}]`);
                            input.setAttribute('name', newName);
                        });
                        
                        const contDeleteBtn = contenedor.querySelector('button');
                        if (contDeleteBtn) {
                            contDeleteBtn.setAttribute('onclick', `eliminarDetalleContenedor(${newIndex}, ${contIndex})`);
                        }
                    });
                    
                    // Actualizar el ID del contenedor de contenedores
                    const contenedorContainer = detalle.querySelector('[id^="detalle-contenedor-container-"]');
                    if (contenedorContainer) {
                        contenedorContainer.id = `detalle-contenedor-container-${newIndex}`;
                    }
                    
                    detalleCounter++;
                });
            }
        }
        
        // Función para eliminar detalle de contenedor
        function eliminarDetalleContenedor(detalleIndex, contenedorIndex) {
            const contenedor = document.getElementById(`contenedor-${detalleIndex}-${contenedorIndex}`);
            if (contenedor && confirm('¿Está seguro de eliminar este contenedor?')) {
                contenedor.remove();
                
                // Re-indexar contenedores restantes en este detalle
                const contenedores = document.querySelectorAll(`#detalle-contenedor-container-${detalleIndex} .contenedor-card`);
                contenedores.forEach((contenedor, newIndex) => {
                    contenedor.id = `contenedor-${detalleIndex}-${newIndex}`;
                    
                    contenedor.querySelectorAll('[name^="orden_detalles["]').forEach(input => {
                        const name = input.getAttribute('name');
                        const newName = name.replace(/detalles\]\[\d+\]/, `detalles][${newIndex}]`);
                        input.setAttribute('name', newName);
                    });
                    
                    const deleteBtn = contenedor.querySelector('button');
                    if (deleteBtn) {
                        deleteBtn.setAttribute('onclick', `eliminarDetalleContenedor(${detalleIndex}, ${newIndex})`);
                    }
                });
            }
        }
        
        // Agregar un detalle por defecto al cargar la página
        document.addEventListener('DOMContentLoaded', function() {
            agregarDetalle();
        });
    </script>
    @endpush
</x-app-layout>