<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Editar Orden #{{ $orden->id }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-1 text-gray-900">
                    
                    <!-- Formulario Principal -->
                    <div class="mb-8">
                        <div class="bg-white rounded-lg shadow p-6">
                            <form method="POST" action="{{ route('ordenes.update', $orden) }}" id="orden-form">
                                @csrf
                                @method('PUT')
                                
                                <!-- Grid con 2 columnas en escritorio -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    
                                    <!-- Campo 1 - Agente Aduanal -->
                                    <div class="mb-2">
                                        <x-input-label for="agente_aduanal_id" :value="__('Agente Aduanal')" />
                                        <select id="agente_aduanal_id" name="agente_aduanal_id" 
                                            class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                            <option value="">Seleccione un agente aduanal</option>
                                            @foreach($agentes as $agente)
                                                <option value="{{ $agente->id }}" 
                                                    {{ old('agente_aduanal_id', $orden->agente_aduanal_id) == $agente->id ? 'selected' : '' }}>
                                                    {{ $agente->nombre }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <x-input-error :messages="$errors->get('agente_aduanal_id')" class="mt-2" />
                                    </div>

                                    <!-- Campo 2 - Fecha -->
                                    <div class="mb-2">
                                        <x-input-label for="fecha" :value="__('Fecha')" />
                                        <x-text-input id="fecha" name="fecha" type="date" class="mt-1 block w-full" 
                                                      :value="old('fecha', $orden->fecha->format('Y-m-d'))" required />
                                        <x-input-error :messages="$errors->get('fecha')" class="mt-2" />
                                    </div>

                                    <!-- Campo 3 - Estado (si lo necesitas) -->
                                    <div class="mb-2">
                                        <x-input-label for="status" :value="__('Estado')" />
                                        <select id="status" name="status" 
                                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                            <option value="pendiente" {{ old('status', $orden->status) == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                                            <option value="completado" {{ old('status', $orden->status) == 'completado' ? 'selected' : '' }}>Completado</option>
                                            <option value="cancelado" {{ old('status', $orden->status) == 'cancelado' ? 'selected' : '' }}>Cancelado</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('status')" class="mt-2" />
                                    </div>
                                </div>
                                <!-- Fin del grid -->

                                <!-- Campo de observaciones que ocupa el ancho completo -->
                                <div class="mt-1">
                                    <x-input-label for="observaciones" :value="__('Observaciones')" />
                                    <textarea id="observaciones" name="observaciones" 
                                              class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" 
                                              rows="1">{{ old('observaciones', $orden->observaciones) }}</textarea>
                                    <x-input-error :messages="$errors->get('observaciones')" class="mt-2" />
                                </div>

                                <!-- Botón para agregar detalles -->
                                <div class="mt-6 mb-4">
                                    <button type="button" onclick="agregarDetalle()" 
                                            class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-md">
                                        + Agregar Empresa
                                    </button>
                                </div>

                                <!-- Contenedor para detalles dinámicos -->
                                <div id="detalles-container" class="mt-4">
                                    <!-- Los detalles existentes se cargarán aquí -->
                                    @foreach($orden->ordenDetalles as $index => $detalle)
                                    <div class="detalle-card border border-gray-200 rounded-lg p-4 mb-4 bg-gray-50" id="detalle-{{ $index }}">
                                        <div class="flex justify-between items-center mb-4">
                                            <h3 class="text-lg font-semibold text-gray-700">Empresa {{ $index + 1 }}</h3>
                                            <button type="button" 
                                                    onclick="eliminarDetalle({{ $index }})" 
                                                    class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded-md text-sm">
                                                Eliminar empresa
                                            </button>
                                        </div>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <x-input-label for="proveedor-{{ $index }}" :value="__('Proveedor *')" />
                                                <select id="proveedor-{{ $index }}" 
                                                        name="orden_detalles[{{ $index }}][proveedorcontenedor_id]" 
                                                        class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                                        required>
                                                    <option value="">Seleccionar Proveedor</option>
                                                    @foreach($proveedores as $proveedor)
                                                        <option value="{{ $proveedor->id }}" 
                                                            {{ old("orden_detalles.{$index}.proveedorcontenedor_id", $detalle->proveedor_contenedor_id) == $proveedor->id ? 'selected' : '' }}>
                                                            {{ $proveedor->nombre }}
                                                        </option>
                                                    @endforeach
                                                </select>


                                    <!--select id="agente_aduanal_id" name="agente_aduanal_id" 
                                            class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                            <option value="">Seleccione un agente aduanal</option>
                                            @ foreach($agentes as $agente)
                                                <option value="{ { $agente->id }}" 
                                                    { { old('agente_aduanal_id', $orden->agente_aduanal_id) == $agente->id ? 'selected' : '' }}>
                                                    { { $agente->nombre }}
                                                </option>
                                            @ endforeach
                                        </select-->



                                            </div>

                                            <div>
                                                <x-input-label for="observaciones-detalle-{{ $index }}" :value="__('Observaciones')" />
                                                <textarea id="observaciones-detalle-{{ $index }}" 
                                                      name="orden_detalles[{{ $index }}][observaciones]" 
                                                      class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" 
                                                      rows="1">{{ old("orden_detalles.{$index}.observaciones", $detalle->observaciones) }}</textarea>
                                            </div>
                                        </div>
                                        
                                        <!-- Sección para Detalles de Contenedor -->
                                        <div class="mt-4">
                                            <div class="flex justify-between items-center mb-0">
                                                <x-input-label :value="__('Lista de contenedores')" class="mb-0" />
                                                <button type="button" 
                                                        onclick="agregarDetalleContenedor({{ $index }})" 
                                                        class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded-md text-sm">
                                                    + Agregar Contenedor
                                                </button>
                                            </div>
                                            <div id="detalle-contenedor-container-{{ $index }}">
                                                <!-- Los detalles de contenedor existentes -->
                                                @foreach($detalle->detalleContenedores as $cIndex => $contenedor)
                                                <div class="contenedor-card border border-gray-100 rounded p-5 mb-0 bg-white" id="contenedor-{{ $index }}-{{ $cIndex }}">
                                                    <div class="grid grid-cols-1 md:grid-cols-4 gap-2">
                                                        <div>
                                                            <input type="text" 
                                                                   id="numero-{{ $index }}-{{ $cIndex }}"
                                                                   name="orden_detalles[{{ $index }}][detalles][{{ $cIndex }}][numero]" 
                                                                   placeholder="Número de contenedor"
                                                                   class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                                                   value="{{ old("orden_detalles.{$index}.detalles.{$cIndex}.numero", $contenedor->numero) }}"
                                                                   required>
                                                        </div>
                                                        <div>
                                                            <select id="status-contenedor-{{ $index }}-{{ $cIndex }}"
                                                                    name="orden_detalles[{{ $index }}][detalles][{{ $cIndex }}][status]" 
                                                                    class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                                                    required>
                                                                <option value="pendiente" {{ old("orden_detalles.{$index}.detalles.{$cIndex}.status", $contenedor->status) == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                                                                <option value="proceso" {{ old("orden_detalles.{$index}.detalles.{$cIndex}.status", $contenedor->status) == 'proceso' ? 'selected' : '' }}>En Proceso</option>
                                                                <option value="completado" {{ old("orden_detalles.{$index}.detalles.{$cIndex}.status", $contenedor->status) == 'completado' ? 'selected' : '' }}>Completado</option>
                                                                <option value="cancelado" {{ old("orden_detalles.{$index}.detalles.{$cIndex}.status", $contenedor->status) == 'cancelado' ? 'selected' : '' }}>Cancelado</option>
                                                            </select>
                                                        </div>
                                                        <div>
                                                            <input type="text" 
                                                                   id="observaciones-contenedor-{{ $index }}-{{ $cIndex }}"
                                                                   name="orden_detalles[{{ $index }}][detalles][{{ $cIndex }}][observaciones]" 
                                                                   placeholder="Observaciones"
                                                                   value="{{ old("orden_detalles.{$index}.detalles.{$cIndex}.observaciones", $contenedor->observaciones) }}"
                                                                   class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                                        </div>
                                                        <div class="flex items-end">
                                                            <button type="button" 
                                                                    onclick="eliminarDetalleContenedor({{ $index }}, {{ $cIndex }})" 
                                                                    class="bg-red-500 hover:bg-red-600 text-white px-1 py-1 rounded-md text-sm">
                                                                🗑️
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>

                                <!-- Botones al final -->
                                <div class="mt-6 flex items-center justify-between">
                                    <div>
                                        <a href="{{ route('ordenes.index') }}" 
                                           class="mr-4 text-gray-600 hover:text-gray-900 underline">
                                            Cancelar
                                        </a>
                                        <a href="{{ route('ordenes.show', $orden) }}" 
                                           class="text-blue-600 hover:text-blue-900 underline">
                                            Ver Detalles
                                        </a>
                                    </div>
                                    <div class="flex space-x-2">
                                        <x-primary-button type="button" onclick="confirmarEliminar()" 
                                                          class="bg-red-500 hover:bg-red-600">
                                            {{ __('Eliminar') }}
                                        </x-primary-button>
                                        <x-primary-button>
                                            {{ __('Actualizar Orden') }}
                                        </x-primary-button>
                                    </div>
                                </div>
                            </form>

                            <!-- Formulario para eliminar (oculto) -->
                            <form id="delete-form" action="{{ route('ordenes.destroy', $orden) }}" method="POST" class="hidden">
                                @csrf
                                @method('DELETE')
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        // Contador para detalles (comienza desde el número de detalles existentes)
        let detalleCounter = {{ $orden->ordenDetalles->count() }};
        
        // Template para detalle NUEVO (cuando se agrega uno nuevo)
        const detalleTemplate = (index) => `
            <div class="detalle-card border border-gray-200 rounded-lg p-4 mb-4 bg-gray-50" id="detalle-${index}">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-gray-700">Empresa ${index + 1}</h3>
                    <button type="button" 
                            onclick="eliminarDetalle(${index})" 
                            class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded-md text-sm">
                        Eliminar empresa
                    </button>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <x-input-label for="proveedor-${index}" :value="__('Proveedor *')" />
                        <select id="proveedor-${index}" 
                                name="orden_detalles[${index}][proveedorcontenedor_id]" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                required>
                            <option value="">Seleccionar Proveedor</option>
                            @foreach($proveedores as $proveedor)
                                <option value="{{ $proveedor->id }}">{{ $proveedor->nombre }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <x-input-label for="observaciones-detalle-${index}" :value="__('Observaciones')" />
                        <textarea id="observaciones-detalle-${index}" 
                              name="orden_detalles[${index}][observaciones]" 
                              class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" 
                              rows="1"></textarea>
                    </div>
                </div>
                
                <!-- Sección para Detalles de Contenedor -->
                <div class="mt-4">
                    <div class="flex justify-between items-center mb-0">
                        <x-input-label :value="__('Lista de contenedores')" class="mb-0" />
                        <button type="button" 
                                onclick="agregarDetalleContenedor(${index})" 
                                class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded-md text-sm">
                            + Agregar Contenedor
                        </button>
                    </div>
                    <div id="detalle-contenedor-container-${index}">
                        <!-- Los detalles de contenedor se agregarán aquí -->
                    </div>
                </div>
            </div>
        `;
        
        // Template para detalle de contenedor NUEVO
        const detalleContenedorTemplate = (detalleIndex, contenedorIndex) => `
            <div class="contenedor-card border border-gray-100 rounded p-5 mb-0 bg-white" id="contenedor-${detalleIndex}-${contenedorIndex}">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-2">
                    <div>
                        <input type="text" 
                               id="numero-${detalleIndex}-${contenedorIndex}"
                               name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][numero]" 
                               placeholder="Número de contenedor"
                               class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                               required>
                    </div>
                    <div>
                        <select id="status-contenedor-${detalleIndex}-${contenedorIndex}"
                                name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][status]" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                required>
                            <option value="pendiente">Pendiente</option>
                            <option value="proceso">En Proceso</option>
                            <option value="completado">Completado</option>
                            <option value="cancelado">Cancelado</option>
                        </select>
                    </div>
                    <div>
                        <input type="text" 
                               id="observaciones-contenedor-${detalleIndex}-${contenedorIndex}"
                               name="orden_detalles[${detalleIndex}][detalles][${contenedorIndex}][observaciones]" 
                               placeholder="Observaciones"
                               class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                    </div>
                    <div class="flex items-end">
                        <button type="button" 
                                onclick="eliminarDetalleContenedor(${detalleIndex}, ${contenedorIndex})" 
                                class="bg-red-500 hover:bg-red-600 text-white px-1 py-1 rounded-md text-sm">
                            🗑️
                        </button>
                    </div>
                </div>
            </div>
        `;
        
        // Función para agregar detalle
        function agregarDetalle() {
            const container = document.getElementById('detalles-container');
            const html = detalleTemplate(detalleCounter);
            container.insertAdjacentHTML('beforeend', html);
            detalleCounter++;
        }
        
        // Función para agregar detalle de contenedor
        function agregarDetalleContenedor(detalleIndex) {
            const container = document.getElementById(`detalle-contenedor-container-${detalleIndex}`);
            const contenedorIndex = container.children.length;
            const html = detalleContenedorTemplate(detalleIndex, contenedorIndex);
            container.insertAdjacentHTML('beforeend', html);
        }
        
        // Función para eliminar detalle
        function eliminarDetalle(index) {
            const detalle = document.getElementById(`detalle-${index}`);
            if (detalle && confirm('¿Está seguro de eliminar este detalle y todos sus contenedores?')) {
                detalle.remove();
                // Re-indexar los detalles restantes
                reindexarDetalles();
            }
        }
        
        // Función para eliminar detalle de contenedor
        function eliminarDetalleContenedor(detalleIndex, contenedorIndex) {
            const contenedor = document.getElementById(`contenedor-${detalleIndex}-${contenedorIndex}`);
            if (contenedor && confirm('¿Está seguro de eliminar este contenedor?')) {
                contenedor.remove();
                reindexarContenedores(detalleIndex);
            }
        }
        
        // Función para reindexar detalles
        function reindexarDetalles() {
            const detalles = document.querySelectorAll('.detalle-card');
            detalleCounter = 0;
            
            detalles.forEach((detalle, newIndex) => {
                detalle.id = `detalle-${newIndex}`;
                detalle.querySelector('h3').textContent = `Empresa ${newIndex + 1}`;
                
                // Actualizar los índices en los campos
                detalle.querySelectorAll('[name^="orden_detalles["]').forEach(input => {
                    const name = input.getAttribute('name');
                    const newName = name.replace(/orden_detalles\[\d+\]/, `orden_detalles[${newIndex}]`);
                    input.setAttribute('name', newName);
                    input.id = input.id.replace(/\d+/, newIndex);
                });
                
                // Actualizar los botones
                const deleteBtn = detalle.querySelector('.flex.justify-between button');
                deleteBtn.setAttribute('onclick', `eliminarDetalle(${newIndex})`);
                
                // Actualizar botón de agregar contenedor
                const contenedorBtn = detalle.querySelector('button.bg-blue-500');
                if (contenedorBtn) {
                    contenedorBtn.setAttribute('onclick', `agregarDetalleContenedor(${newIndex})`);
                }
                
                // Actualizar contenedores hijos
                const contenedores = detalle.querySelectorAll('.contenedor-card');
                contenedores.forEach((contenedor, contIndex) => {
                    contenedor.id = `contenedor-${newIndex}-${contIndex}`;
                    
                    contenedor.querySelectorAll('[name^="orden_detalles["]').forEach(input => {
                        const name = input.getAttribute('name');
                        const newName = name.replace(/orden_detalles\[\d+\]/, `orden_detalles[${newIndex}]`);
                        input.setAttribute('name', newName);
                        input.id = input.id.replace(/-\d+-\d+/, `-${newIndex}-${contIndex}`);
                    });
                    
                    const contDeleteBtn = contenedor.querySelector('button');
                    if (contDeleteBtn) {
                        contDeleteBtn.setAttribute('onclick', `eliminarDetalleContenedor(${newIndex}, ${contIndex})`);
                    }
                });
                
                // Actualizar el ID del contenedor de contenedores
                const contenedorContainer = detalle.querySelector('[id^="detalle-contenedor-container-"]');
                if (contenedorContainer) {
                    contenedorContainer.id = `detalle-contenedor-container-${newIndex}`;
                }
                
                detalleCounter++;
            });
        }
        
        // Función para reindexar contenedores
        function reindexarContenedores(detalleIndex) {
            const contenedores = document.querySelectorAll(`#detalle-contenedor-container-${detalleIndex} .contenedor-card`);
            contenedores.forEach((contenedor, newIndex) => {
                contenedor.id = `contenedor-${detalleIndex}-${newIndex}`;
                
                contenedor.querySelectorAll('[name^="orden_detalles["]').forEach(input => {
                    const name = input.getAttribute('name');
                    const newName = name.replace(/detalles\]\[\d+\]/, `detalles][${newIndex}]`);
                    input.setAttribute('name', newName);
                    input.id = input.id.replace(/-\d+-\d+/, `-${detalleIndex}-${newIndex}`);
                });
                
                const deleteBtn = contenedor.querySelector('button');
                if (deleteBtn) {
                    deleteBtn.setAttribute('onclick', `eliminarDetalleContenedor(${detalleIndex}, ${newIndex})`);
                }
            });
        }
        
        // Función para confirmar eliminación
        function confirmarEliminar() {
            if (confirm('¿Está seguro de que desea eliminar esta orden? Esta acción no se puede deshacer.')) {
                document.getElementById('delete-form').submit();
            }
        }
        
        // Inicializar contadores para contenedores existentes
        document.addEventListener('DOMContentLoaded', function() {
            // Agregar IDs a los contenedores existentes si no los tienen
            document.querySelectorAll('.detalle-card').forEach((detalle, detalleIndex) => {
                detalle.id = `detalle-${detalleIndex}`;
                detalle.querySelector('.flex.justify-between button').setAttribute('onclick', `eliminarDetalle(${detalleIndex})`);
                
                const contenedorBtn = detalle.querySelector('button.bg-blue-500');
                if (contenedorBtn) {
                    contenedorBtn.setAttribute('onclick', `agregarDetalleContenedor(${detalleIndex})`);
                }
                
                const contenedorContainer = detalle.querySelector('[id^="detalle-contenedor-container-"]');
                if (contenedorContainer) {
                    contenedorContainer.id = `detalle-contenedor-container-${detalleIndex}`;
                }
                
                detalle.querySelectorAll('.contenedor-card').forEach((contenedor, contIndex) => {
                    contenedor.id = `contenedor-${detalleIndex}-${contIndex}`;
                    const deleteBtn = contenedor.querySelector('button');
                    if (deleteBtn) {
                        deleteBtn.setAttribute('onclick', `eliminarDetalleContenedor(${detalleIndex}, ${contIndex})`);
                    }
                });
            });
        });
    </script>
    @endpush
</x-app-layout>