<x-app-layout>
    <x-slot name="title">Estadísticas de Órdenes</x-slot>

    <x-slot name="header-buttons">
        <div class="btn-group me-2">
            <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-download"></i> Exportar
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="exportChartAsImage()"><i class="fas fa-image"></i> Como Imagen</a></li>
                <li><a class="dropdown-item" href="#" onclick="exportAsCSV()"><i class="fas fa-file-csv"></i> Como CSV</a></li>
                <li><a class="dropdown-item" href="#" onclick="printReport()"><i class="fas fa-print"></i> Imprimir Reporte</a></li>
            </ul>
        </div>

        <a href="{{ route('ordenes.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver a Órdenes
        </a>
    </x-slot>

    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-chart-bar"></i> Estadísticas de Órdenes de Servicio
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Filtros -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="yearSelect">Seleccionar Año:</label>
                                <select id="yearSelect" class="form-select">
                                    @for($i = date('Y'); $i >= 2020; $i--)
                                        <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>
                                            {{ $i }}
                                        </option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="chartType">Tipo de Gráfica:</label>
                                <select id="chartType" class="form-select">
                                    <option value="bar">Barras</option>
                                    <option value="line">Línea</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 d-flex align-items-end">
                            <button id="updateChart" class="btn btn-primary">
                                <i class="fas fa-sync-alt"></i> Actualizar Gráfica
                            </button>
                        </div>
                    </div>
                    
                    <!-- Gráfica principal -->
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">Órdenes por Mes (Año: <span id="currentYear">{{ date('Y') }}</span>)</h6>
                                </div>
                                <div class="card-body">
                                    <div style="position: relative; height: 400px;">
                                        <canvas id="ordersChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">Órdenes por Estado</h6>
                                </div>
                                <div class="card-body">
                                    <div style="position: relative; height: 300px;">
                                        <canvas id="statusChart"></canvas>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Estadísticas rápidas -->
                            <div class="card mt-4">
                                <div class="card-header">
                                    <h6 class="mb-0">
                                        <i class="fas fa-info-circle"></i> Resumen Estadístico
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div id="statsSummary">
                                        <!-- Aquí se cargarán las estadísticas -->
                                        <div class="text-center">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">Cargando...</span>
                                            </div>
                                            <p class="mt-2">Cargando estadísticas...</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Tabla de datos detallados -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">
                                        <i class="fas fa-table"></i> Datos Detallados
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover" id="statsTable">
                                            <thead>
                                                <tr>
                                                    <th>Mes</th>
                                                    <th>Cantidad de Órdenes</th>
                                                    <th>Porcentaje</th>
                                                    <th>Tendencia</th>
                                                </tr>
                                            </thead>
                                            <tbody id="statsTableBody">
                                                <!-- Los datos se cargarán aquí -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('styles')
    <style>
        .stats-card {
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 15px;
            text-align: center;
            color: white;
            transition: transform 0.3s;
        }
        
        .stats-card:hover {
            transform: translateY(-5px);
        }
        
        .stats-card .number {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .stats-card .label {
            font-size: 1rem;
            opacity: 0.9;
        }
        
        .stat-trend-up {
            color: #28a745;
        }
        
        .stat-trend-down {
            color: #dc3545;
        }
        
        .stat-trend-neutral {
            color: #6c757d;
        }
        
        .month-bar {
            height: 20px;
            background: #e9ecef;
            border-radius: 10px;
            margin-bottom: 5px;
            overflow: hidden;
        }
        
        .month-bar-fill {
            height: 100%;
            background: linear-gradient(90deg, #3498db, #2ecc71);
            border-radius: 10px;
            transition: width 0.5s ease;
        }
    </style>
    @endpush

    @push('scripts')
    <script>
        // Variables globales para las gráficas
        let ordersChart = null;
        let statusChart = null;
        
        // Colores para la gráfica
        const chartColors = {
            primary: '#3498db',
            secondary: '#2ecc71',
            success: '#28a745',
            info: '#17a2b8',
            warning: '#ffc107',
            danger: '#dc3545',
            light: '#f8f9fa',
            dark: '#343a40'
        };
        
        // Función para inicializar la gráfica principal
        function initOrdersChart(labels = [], data = []) {
            const ctx = document.getElementById('ordersChart').getContext('2d');
            const chartType = document.getElementById('chartType').value;
            
            // Si ya existe una gráfica, destruirla
            if (ordersChart) {
                ordersChart.destroy();
            }
            
            // Crear nueva gráfica
            ordersChart = new Chart(ctx, {
                type: chartType,
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Órdenes de Servicio',
                        data: data,
                        backgroundColor: chartColors.primary + '80',
                        borderColor: chartColors.primary,
                        borderWidth: 2,
                        fill: chartType === 'line' ? true : false,
                        tension: 0.4,
                        pointBackgroundColor: chartColors.primary,
                        pointBorderColor: '#fff',
                        pointBorderWidth: 2,
                        pointRadius: 5,
                        pointHoverRadius: 7
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top',
                        },
                        tooltip: {
                            mode: 'index',
                            intersect: false,
                            callbacks: {
                                label: function(context) {
                                    return `Órdenes: ${context.parsed.y}`;
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Cantidad de Órdenes'
                            },
                            ticks: {
                                stepSize: 1,
                                precision: 0
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Meses'
                            }
                        }
                    },
                    interaction: {
                        intersect: false,
                        mode: 'nearest'
                    },
                    animation: {
                        duration: 1000,
                        easing: 'easeInOutQuart'
                    }
                }
            });
        }
        
        // Función para inicializar la gráfica de estados
        function initStatusChart(labels = [], data = [], backgroundColors = []) {
            const ctx = document.getElementById('statusChart').getContext('2d');
            
            // Si ya existe una gráfica, destruirla
            if (statusChart) {
                statusChart.destroy();
            }
            
            // Crear nueva gráfica
            statusChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: labels,
                    datasets: [{
                        data: data,
                        backgroundColor: backgroundColors,
                        borderColor: '#fff',
                        borderWidth: 2,
                        hoverOffset: 15
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'right',
                            labels: {
                                padding: 20,
                                usePointStyle: true,
                                pointStyle: 'circle'
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.parsed || 0;
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = Math.round((value / total) * 100);
                                    return `${label}: ${value} (${percentage}%)`;
                                }
                            }
                        }
                    },
                    cutout: '60%',
                    animation: {
                        animateScale: true,
                        animateRotate: true
                    }
                }
            });
        }
        
        // Función para cargar datos de estadísticas
        function loadStatisticsData(year = null) {
            if (!year) {
                year = document.getElementById('yearSelect').value;
            }
            
            // Mostrar loading
            document.getElementById('statsSummary').innerHTML = `
                <div class="text-center">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Cargando...</span>
                    </div>
                    <p class="mt-2">Cargando estadísticas...</p>
                </div>
            `;
            
            // Cargar datos de la gráfica principal
            fetch(`/ordenes/estadisticas/data?year=${year}`)
                .then(response => response.json())
                .then(data => {
                    // Actualizar año actual
                    document.getElementById('currentYear').textContent = data.selected_year;
                    
                    // Inicializar gráfica principal
                    initOrdersChart(data.labels, data.data);
                    
                    // Actualizar tabla de datos
                    updateStatsTable(data.labels, data.data);
                    
                    // Actualizar estadísticas rápidas
                    updateStatsSummary(data.data);
                    
                    // Actualizar opciones de años
                    updateYearSelect(data.years, data.selected_year);
                })
                .catch(error => {
                    console.error('Error al cargar datos:', error);
                    alert('Error al cargar los datos estadísticos');
                });
            
            // Cargar datos de la gráfica de estados
            fetch('/ordenes/estadisticas/estado')
                .then(response => response.json())
                .then(data => {
                    initStatusChart(data.labels, data.data, data.backgroundColors);
                })
                .catch(error => {
                    console.error('Error al cargar datos de estado:', error);
                });
        }
        
        // Función para actualizar la tabla de datos
        function updateStatsTable(labels, data) {
            const tableBody = document.getElementById('statsTableBody');
            const total = data.reduce((a, b) => a + b, 0);
            
            let html = '';
            
            data.forEach((value, index) => {
                const percentage = total > 0 ? Math.round((value / total) * 100) : 0;
                const month = labels[index];
                
                // Determinar tendencia (simplificado)
                let trendIcon = '<i class="fas fa-minus stat-trend-neutral"></i>';
                let trendText = 'Estable';
                
                if (index > 0) {
                    const prevValue = data[index - 1];
                    if (value > prevValue) {
                        trendIcon = '<i class="fas fa-arrow-up stat-trend-up"></i>';
                        trendText = '↑ Aumentó';
                    } else if (value < prevValue) {
                        trendIcon = '<i class="fas fa-arrow-down stat-trend-down"></i>';
                        trendText = '↓ Disminuyó';
                    }
                }
                
                html += `
                    <tr>
                        <td><strong>${month}</strong></td>
                        <td>${value}</td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="month-bar" style="flex-grow: 1; margin-right: 10px;">
                                    <div class="month-bar-fill" style="width: ${percentage}%"></div>
                                </div>
                                <span>${percentage}%</span>
                            </div>
                        </td>
                        <td>
                            ${trendIcon}
                            <span class="ms-2">${trendText}</span>
                        </td>
                    </tr>
                `;
            });
            
            // Agregar fila de total
            html += `
                <tr class="table-primary">
                    <td><strong>TOTAL</strong></td>
                    <td><strong>${total}</strong></td>
                    <td><strong>100%</strong></td>
                    <td></td>
                </tr>
            `;
            
            tableBody.innerHTML = html;
            
            // Animar las barras
            setTimeout(() => {
                const bars = document.querySelectorAll('.month-bar-fill');
                bars.forEach(bar => {
                    const width = bar.style.width;
                    bar.style.width = '0';
                    setTimeout(() => {
                        bar.style.width = width;
                    }, 100);
                });
            }, 100);
        }
        
        // Función para actualizar el resumen estadístico
        function updateStatsSummary(data) {
            const total = data.reduce((a, b) => a + b, 0);
            const max = Math.max(...data);
            const min = Math.min(...data.filter(val => val > 0));
            const average = total > 0 ? (total / data.filter(val => val > 0).length).toFixed(1) : 0;
            const maxMonth = data.indexOf(max);
            const minMonth = data.indexOf(min);
            
            // Meses en español completos
            const mesesCompletos = [
                'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
                'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
            ];
            
            let html = `
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="stats-card" style="background: linear-gradient(135deg, ${chartColors.primary}, ${chartColors.info});">
                            <div class="number">${total}</div>
                            <div class="label">Órdenes Totales</div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="stats-card" style="background: linear-gradient(135deg, ${chartColors.success}, ${chartColors.secondary});">
                            <div class="number">${average}</div>
                            <div class="label">Promedio Mensual</div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="stats-card" style="background: linear-gradient(135deg, ${chartColors.warning}, #ff9800);">
                            <div class="number">${max}</div>
                            <div class="label">Máximo (${mesesCompletos[maxMonth]})</div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="stats-card" style="background: linear-gradient(135deg, ${chartColors.danger}, #e91e63);">
                            <div class="number">${min}</div>
                            <div class="label">Mínimo (${mesesCompletos[minMonth]})</div>
                        </div>
                    </div>
                </div>
            `;
            
            // Calcular crecimiento vs año anterior (simulado)
            const growth = 12.5; // Esto se podría calcular con datos reales
            const growthClass = growth >= 0 ? 'stat-trend-up' : 'stat-trend-down';
            const growthIcon = growth >= 0 ? 'fa-arrow-up' : 'fa-arrow-down';
            
            html += `
                <div class="alert alert-info">
                    <i class="fas fa-chart-line"></i>
                    <strong>Crecimiento anual:</strong>
                    <span class="${growthClass}">
                        <i class="fas ${growthIcon}"></i>
                        ${Math.abs(growth)}%
                    </span>
                    <span class="float-end">
                        <i class="fas fa-calendar-alt"></i>
                        Año ${document.getElementById('yearSelect').value}
                    </span>
                </div>
            `;
            
            document.getElementById('statsSummary').innerHTML = html;
        }
        
        // Función para actualizar el select de años
        function updateYearSelect(years, selectedYear) {
            const select = document.getElementById('yearSelect');
            select.innerHTML = '';
            
            years.forEach(year => {
                const option = document.createElement('option');
                option.value = year;
                option.textContent = year;
                if (year == selectedYear) {
                    option.selected = true;
                }
                select.appendChild(option);
            });
        }
        
        // Event Listeners
        document.addEventListener('DOMContentLoaded', function() {
            // Cargar datos iniciales
            loadStatisticsData();
            
            // Actualizar gráfica al cambiar año
            document.getElementById('updateChart').addEventListener('click', function() {
                loadStatisticsData();
            });
            
            // Actualizar tipo de gráfica
            document.getElementById('chartType').addEventListener('change', function() {
                const year = document.getElementById('yearSelect').value;
                loadStatisticsData(year);
            });
            
            // Exportar gráfica como imagen
            document.addEventListener('keydown', function(e) {
                if (e.ctrlKey && e.key === 'p') {
                    e.preventDefault();
                    exportChartAsImage();
                }
            });
        });
        
        // Función para exportar la gráfica como imagen
        function exportChartAsImage() {
            if (ordersChart) {
                const link = document.createElement('a');
                link.download = `estadisticas-ordenes-${document.getElementById('yearSelect').value}.png`;
                link.href = ordersChart.toBase64Image();
                link.click();
            }
        }
        
        // Función para imprimir el reporte
        function printReport() {
            window.print();
        }

        // Función para exportar como CSV
        function exportAsCSV() {
            const year = document.getElementById('yearSelect').value;
            const labels = Array.from(document.querySelectorAll('#statsTableBody tr td:first-child')).map(td => td.textContent.trim());
            const values = Array.from(document.querySelectorAll('#statsTableBody tr td:nth-child(2)')).map(td => td.textContent.trim());
            
            // Remover la fila de TOTAL
            labels.pop();
            values.pop();
            
            let csv = 'Mes,Cantidad de Órdenes\n';
            for (let i = 0; i < labels.length; i++) {
                csv += `"${labels[i]}",${values[i]}\n`;
            }
            
            const blob = new Blob([csv], { type: 'text/csv' });
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.setAttribute('hidden', '');
            a.setAttribute('href', url);
            a.setAttribute('download', `estadisticas-ordenes-${year}.csv`);
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
    </script>
    @endpush
</x-app-layout>