<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Gráficas
        </h2>
    </x-slot>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gráfica de Contenedores por Mes</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .chart-container {
            position: relative;
            height: 400px;
            width: 100%;
        }
        
        @media (max-width: 768px) {
            .chart-container {
                height: 300px;
            }
        }
    </style>
</head>
<body class="bg-gray-100 min-h-screen">
    <div class="container mx-auto px-4 py-2"> <!-- Era py-8 -->
        <!-- Header -->
        <div class="mb-4">
            <h1 class="text-2xl font-bold text-gray-800 mb-2">Contenedores Trabajados por Mes</h1>
            <p class="text-gray-600">Visualización mensual de contenedores procesados</p>
        </div>

        <!-- Filtros -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-2">
            <form method="GET" action="{{ route('ordenes.grafica_contenedor_mes') }}" class="flex flex-col md:flex-row gap-4 items-end">
                <div class="flex-1">
                    <label for="year" class="block text-sm font-medium text-gray-700 mb-1">
                        Seleccionar Año
                    </label>
                    <select id="year" name="year" 
                            class="w-full md:w-auto px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        @foreach($yearsDisponibles as $yearOption)
                            <option value="{{ $yearOption }}" {{ $year == $yearOption ? 'selected' : '' }}>
                                {{ $yearOption }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div class="flex gap-2">
                    <button type="submit" 
                            class="px-6 py-2 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition duration-200">
                        Filtrar
                    </button>
                    <a href="{{ route('ordenes.grafica_contenedor_mes') }}" 
                       class="px-6 py-2 bg-gray-200 text-gray-700 font-medium rounded-lg hover:bg-gray-300 transition duration-200">
                        Limpiar
                    </a>
                </div>
            </form>
        </div>

        <!-- Grid de Componentes -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Gráfica -->
            <div class="lg:col-span-1 lg:col-start-1 bg-white rounded-lg shadow-md p-6">
                <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6">
                    <div>
                        <h2 class="text-xl font-semibold text-gray-800 mb-1">
                            Gráfica de Contenedores - Año {{ $year }}
                        </h2>
                        <p class="text-gray-600 text-sm">
                            Total de contenedores: <span class="font-bold text-blue-600">{{ $totalContenedores }}</span>
                        </p>
                    </div>
                    <div class="mt-2 md:mt-0">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                            {{ $year }}
                        </span>
                    </div>
                </div>
                
                <div class="chart-container">
                    <canvas id="contenedoresChart"></canvas>
                </div>
            </div>

            <!-- Tabla de Datos -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-xl font-semibold text-gray-800 mb-6">Datos Mensuales</h2>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Mes
                                </th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Contenedores
                                </th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Porcentaje
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($meses as $index => $mes)
                                @php
                                    $valor = $valores[$index];
                                    $porcentaje = $totalContenedores > 0 ? ($valor / $totalContenedores * 100) : 0;
                                @endphp
                                <tr class="{{ $valor == 0 ? 'bg-yellow-50' : 'hover:bg-gray-50' }}">
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <span class="text-sm font-medium text-gray-900">{{ $mes }}</span>
                                            @if($valor == 0)
                                                <span class="ml-2 px-2 py-1 text-xs font-medium bg-yellow-100 text-yellow-800 rounded-full">
                                                    Sin datos
                                                </span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <span class="text-sm font-semibold text-gray-900">{{ $valor }}</span>
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="w-24 bg-gray-200 rounded-full h-2 mr-3">
                                                <div class="bg-blue-600 h-2 rounded-full" 
                                                     style="width: {{ min($porcentaje, 100) }}%"></div>
                                            </div>
                                            <span class="text-sm text-gray-600">{{ number_format($porcentaje, 1) }}%</span>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td class="px-4 py-3 whitespace-nowrap text-sm font-bold text-gray-900">
                                    Total {{ $year }}
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm font-bold text-gray-900">
                                    {{ $totalContenedores }}
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm font-bold text-gray-900">
                                    100%
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Resumen Estadístico -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-xl font-semibold text-gray-800 mb-6">Resumen del Año</h2>
                
                <!-- Estadísticas -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                    @php
                        $mesesConDatos = array_filter($valores);
                        $mesesSinDatos = 12 - count($mesesConDatos);
                        $maxValor = max($valores);
                        $mesMaxValor = $meses[array_search($maxValor, $valores)];
                        $promedio = $totalContenedores > 0 ? $totalContenedores / count($mesesConDatos) : 0;
                    @endphp
                    
                    <div class="bg-blue-50 p-4 rounded-lg">
                        <div class="flex items-center">
                            <div class="p-2 bg-blue-100 rounded-lg mr-4">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm text-blue-600">Total Contenedores</p>
                                <p class="text-2xl font-bold text-blue-700">{{ $totalContenedores }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-green-50 p-4 rounded-lg">
                        <div class="flex items-center">
                            <div class="p-2 bg-green-100 rounded-lg mr-4">
                                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm text-green-600">Meses con Datos</p>
                                <p class="text-2xl font-bold text-green-700">{{ count($mesesConDatos) }}/12</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-purple-50 p-4 rounded-lg">
                        <div class="flex items-center">
                            <div class="p-2 bg-purple-100 rounded-lg mr-4">
                                <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm text-purple-600">Mes Más Productivo</p>
                                <p class="text-lg font-bold text-purple-700">{{ $mesMaxValor }}</p>
                                <p class="text-sm text-purple-600">{{ $maxValor }} contenedores</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-yellow-50 p-4 rounded-lg">
                        <div class="flex items-center">
                            <div class="p-2 bg-yellow-100 rounded-lg mr-4">
                                <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm text-yellow-600">Meses sin Datos</p>
                                <p class="text-2xl font-bold text-yellow-700">{{ $mesesSinDatos }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Lista de Meses sin Datos -->
                @if($mesesSinDatos > 0)
                <div class="border border-yellow-200 rounded-lg p-4 bg-yellow-50">
                    <h3 class="font-medium text-yellow-800 mb-2">
                        <svg class="w-5 h-5 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.998-.833-2.732 0L4.786 16.5c-.77.833.192 2.5 1.732 2.5z" />
                        </svg>
                        Información Pendiente
                    </h3>
                    <p class="text-sm text-yellow-600 mb-3">
                        Los siguientes meses no tienen datos registrados:
                    </p>
                    <div class="flex flex-wrap gap-2">
                        @foreach($meses as $index => $mes)
                            @if($valores[$index] == 0)
                                <span class="px-3 py-1 text-sm font-medium bg-yellow-100 text-yellow-800 rounded-full">
                                    {{ $mes }}
                                </span>
                            @endif
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const ctx = document.getElementById('contenedoresChart').getContext('2d');
            
            // Colores basados en si hay datos o no
            const backgroundColors = {!! json_encode(array_map(function($valor) {
                return $valor == 0 ? 'rgba(250, 204, 21, 0.5)' : 'rgba(59, 130, 246, 0.5)';
            }, $valores)) !!};
            
            const borderColors = {!! json_encode(array_map(function($valor) {
                return $valor == 0 ? 'rgba(250, 204, 21, 1)' : 'rgba(59, 130, 246, 1)';
            }, $valores)) !!};

            const chart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: {!! json_encode($meses) !!},
                    datasets: [{
                        label: 'Contenedores Trabajados',
                        data: {!! json_encode($valores) !!},
                        backgroundColor: backgroundColors,
                        borderColor: borderColors,
                        borderWidth: 2,
                        borderRadius: 6,
                        hoverBackgroundColor: {!! json_encode(array_map(function($valor) {
                            return $valor == 0 ? 'rgba(250, 204, 21, 0.8)' : 'rgba(59, 130, 246, 0.8)';
                        }, $valores)) !!}
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top',
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    let label = context.dataset.label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    label += context.parsed.y + ' contenedores';
                                    if (context.parsed.y === 0) {
                                        label += ' (sin datos)';
                                    }
                                    return label;
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Cantidad de Contenedores'
                            },
                            ticks: {
                                stepSize: 1
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Meses'
                            }
                        }
                    }
                }
            });
        });
    </script>
</body>
</html>
</x-app-layout>