<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Gráficas
        </h2>
    </x-slot>


<div class="container mx-auto px-4 py-2">
    <!-- Encabezado -->
    <div class="mb-4">
        <h1 class="text-2xl font-bold text-gray-800 mb-2">📊 Gráfica de Órdenes por Mes</h1>
        <nav class="flex text-sm text-gray-600">
            <a href="{{ route('dashboard') }}" class="hover:text-blue-600">Inicio</a>
            <span class="mx-2">/</span>
            <a href="{{ route('ordenes.index') }}" class="hover:text-blue-600">Órdenes</a>
            <span class="mx-2">/</span>
            <span class="text-gray-800 font-medium">Gráfica Mensual</span>
        </nav>
    </div>

    <!-- Filtro de Año -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <form method="GET" action="{{ route('ordenes.graficas') }}" class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div class="flex-1">
                <label for="year" class="block text-sm font-medium text-gray-700 mb-1">
                    Seleccionar Año:
                </label>
                <div class="flex items-center gap-2">
                    <select name="year" id="year" 
                            class="w-full md:w-48 border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                            onchange="this.form.submit()">
                        @foreach($anios as $anio)
                            <option value="{{ $anio }}" {{ $year == $anio ? 'selected' : '' }}>
                                {{ $anio }}
                            </option>
                        @endforeach
                    </select>
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">
                        <i class="fas fa-filter"></i>
                    </button>
                </div>
            </div>
            
            <div class="flex flex-wrap gap-3 items-center">
                <span class="inline-flex items-center px-3 py-1 rounded-full bg-blue-100 text-blue-800 text-sm">
                    <i class="fas fa-calendar-alt mr-1"></i> {{ $year }}
                </span>
                <span class="inline-flex items-center px-3 py-1 rounded-full bg-green-100 text-green-800 text-sm">
                    Total: {{ array_sum($datosCompletos) }} órdenes
                </span>
            </div>
        </form>
    </div>

    <!-- CONTENIDO PRINCIPAL - RESPONSIVE CON TAILWIND -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <!-- Gráfica -->
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-800">
                    <i class="fas fa-chart-bar text-blue-500 mr-2"></i>
                    Visualización Gráfica
                </h2>
            </div>
            <div class="p-4">
                <div class="h-64 md:h-80"> <!-- Altura responsive -->
                    <canvas id="graficaOrdenes"></canvas>
                </div>
            </div>
            <div class="px-6 py-4 border-t border-gray-200 bg-gray-50">
                <div class="grid grid-cols-2 gap-4 text-center">
                    <div>
                        <p class="text-sm text-gray-600">Mes más activo</p>
                        @php
                            $mesMax = array_keys($datosCompletos, max($datosCompletos))[0] ?? 1;
                        @endphp
                        <p class="font-bold text-blue-600">{{ $meses[$mesMax] ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Órdenes máx/mes</p>
                        <p class="font-bold text-green-600">{{ max($datosCompletos) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabla de Datos -->
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-800">
                    <i class="fas fa-table text-green-500 mr-2"></i>
                    Detalle por Mes
                </h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Mes
                            </th>
                            <th class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Cantidad
                            </th>
                            <th class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Estado
                            </th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Progreso
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @php
                            $total = array_sum($datosCompletos);
                            $max = max($datosCompletos);
                        @endphp
                        @foreach($meses as $numero => $nombre)
                        @php
                            $valor = $datosCompletos[$numero];
                            $porcentaje = $max > 0 ? ($valor / $max) * 100 : 0;
                        @endphp
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="flex items-center">
                                    <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-gray-200 text-gray-700 text-xs font-medium mr-3">
                                        {{ str_pad($numero, 2, '0', STR_PAD_LEFT) }}
                                    </span>
                                    <span class="text-sm font-medium text-gray-900">
                                        <span class="hidden sm:inline">{{ $nombre }}</span>
                                        <span class="sm:hidden">{{ substr($nombre, 0, 3) }}</span>
                                    </span>
                                </div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-center">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                    {{ $valor }}
                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-center">
                                @if($valor > 0)
                                    <span class="text-green-600" title="Con datos">
                                        <i class="fas fa-check-circle"></i>
                                    </span>
                                @else
                                    <span class="text-yellow-600" title="Sin datos">
                                        <i class="fas fa-exclamation-triangle"></i>
                                    </span>
                                @endif
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="flex items-center space-x-2">
                                    <div class="flex-1">
                                        <div class="w-full bg-gray-200 rounded-full h-2">
                                            <div class="bg-green-500 h-2 rounded-full" style="width: {{ $porcentaje }}%"></div>
                                        </div>
                                    </div>
                                    <span class="text-xs text-gray-500 w-12">
                                        {{ round($porcentaje, 1) }}%
                                    </span>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="px-6 py-4 border-t border-gray-200 bg-gray-50">
                <p class="text-sm text-gray-600">
                    <i class="fas fa-info-circle mr-1"></i>
                    Mostrando {{ count(array_filter($datosCompletos, fn($val) => $val > 0)) }}/12 meses con datos
                </p>
            </div>
        </div>
    </div>

    <!-- Estadísticas Resumen -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">
            <i class="fas fa-chart-pie text-purple-500 mr-2"></i>
            Resumen Estadístico {{ $year }}
        </h2>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="bg-blue-50 p-4 rounded-lg border border-blue-100">
                <div class="text-2xl font-bold text-blue-700 mb-1">
                    {{ array_sum($datosCompletos) }}
                </div>
                <div class="text-sm text-blue-600">Total Órdenes</div>
            </div>
            
            <div class="bg-green-50 p-4 rounded-lg border border-green-100">
                <div class="text-2xl font-bold text-green-700 mb-1">
                    {{ round(array_sum($datosCompletos) / 12, 1) }}
                </div>
                <div class="text-sm text-green-600">Promedio Mensual</div>
            </div>
            
            <div class="bg-yellow-50 p-4 rounded-lg border border-yellow-100">
                <div class="text-2xl font-bold text-yellow-700 mb-1">
                    {{ count(array_filter($datosCompletos, fn($val) => $val == 0)) }}
                </div>
                <div class="text-sm text-yellow-600">Meses sin datos</div>
            </div>
            
            <div class="bg-purple-50 p-4 rounded-lg border border-purple-100">
                <div class="text-2xl font-bold text-purple-700 mb-1">
                    {{ count(array_filter($datosCompletos, fn($val) => $val > 0)) }}
                </div>
                <div class="text-sm text-purple-600">Meses con datos</div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ctx = document.getElementById('graficaOrdenes').getContext('2d');
        
        const datos = @json(array_values($datosCompletos));
        const meses = @json(array_values($meses));
        
        // Determinar etiquetas según tamaño de pantalla
        const isMobile = window.innerWidth < 640;
        const labels = isMobile 
            ? meses.map(m => m.substring(0, 3))  // "Ene", "Feb", etc
            : meses;                             // Nombres completos
        
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Órdenes por Mes',
                    data: datos,
                    backgroundColor: datos.map(valor => 
                        valor > 0 ? 'rgba(59, 130, 246, 0.7)' : 'rgba(245, 158, 11, 0.6)'
                    ),
                    borderColor: datos.map(valor => 
                        valor > 0 ? 'rgba(59, 130, 246, 1)' : 'rgba(245, 158, 11, 1)'
                    ),
                    borderWidth: 1,
                    borderRadius: 6,
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: !isMobile,
                        position: 'top',
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const mesCompleto = meses[context.dataIndex];
                                return `${mesCompleto}: ${context.parsed.y} orden(es)`;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1,
                            precision: 0,
                            font: {
                                size: isMobile ? 10 : 12
                            }
                        }
                    },
                    x: {
                        ticks: {
                            font: {
                                size: isMobile ? 10 : 11
                            }
                        }
                    }
                }
            }
        });
    });
</script>
@endpush

@push('styles')
<style>
    /* Estilos adicionales si los necesitas */
    canvas {
        max-width: 100% !important;
    }
    
    /* Scrollbar personalizado para la tabla */
    .overflow-x-auto::-webkit-scrollbar {
        height: 6px;
    }
    .overflow-x-auto::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }
    .overflow-x-auto::-webkit-scrollbar-thumb {
        background: #c1c1c1;
        border-radius: 10px;
    }
</style>
@endpush
</x-app-layout>