@if(in_array(auth()->user()->role, ['receptoria', 'compras', 'agente_aduanal']))
<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold text-gray-800">
                Lista de órdenes de servicio de contenedores
            </h2>

            <div class="flex items-center gap-2">

                <!--@ if(in_array(auth()->user()->role, ['receptoria', 'compras']))
                <a href="{ { route('ordenes.estadisticas') }}" 
                    class="bg-white text-black border border-gray-300 px-4 py-1 rounded hover:bg-gray-100">
                    <i class="fas fa-chart-bar"></i> Estadísticas
                </a>
                @ endif-->

                <!-- Permisos de CReación -->
                @if(in_array(auth()->user()->role, ['receptoria',  'agente_aduanal']))
                <a href="{{ route('ordenes.create') }}"
                   class="bg-white text-black border border-gray-300 px-4 py-1 rounded hover:bg-gray-100">
                    ➕ Nueva
                </a>
                @endif

            </div>
        </div>
    </x-slot>


    {{-- FORMULARIO DE FILTROS ***************************************************--}}


    {{-- SCRIPT --}}
    <script>
        function deleteModal() {
            return {
                ordenToDelete: null,

                async deleteOrden() {
                    if (!this.ordenToDelete) return;

                    await fetch(`/ordenes/${this.ordenToDelete}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                            'Accept': 'application/json'
                        }
                    });

                    // quitar fila sin recargar
                    document.getElementById(`orden-${this.ordenToDelete}`)?.remove();

                    // cerrar modal
                    window.dispatchEvent(new CustomEvent('close-modal', {
                        detail: 'delete-modal'
                    }));

                    this.ordenToDelete = null;
                }
            }
        }
    </script>

    <div class="p-3" x-data="deleteModal()">
        <div class="overflow-x-auto bg-white rounded-lg shadow min-h-[80vh] flex flex-col">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Id</th>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Fecha</th>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Agente aduanal</th>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Observaciones</th>
                        <th class="px-8 py-3 text-center text-sm font-semibold uppercase text-black">Estado</th>
                        <th class="px-8 py-3 text-right text-sm font-semibold uppercase">Acciones</th>
                    </tr>
                </thead>

                <tbody class="divide-y divide-gray-200">
                @forelse($ordenes as $orden)
                    <tr id="orden-{{ $orden->id }}" class="hover:bg-gray-50 transition">
                        <td class="px-8 py-2 text-base text-black">
                            {{ $orden->id }}
                        </td>
                        <td class="px-8 py-2 text-base text-black">
                            {{ \Carbon\Carbon::parse($orden->fecha)->format('d/m/Y') }}
                        </td>
                        <td class="px-8 py-2 text-base text-black">
                            @if($orden->agenteAduanal)
                                {{ $orden->agenteAduanal->nombre }}
                            @else
                                <span class="text-gray-400">Sin agente</span>
                            @endif
                        </td>
                        <td class="px-8 py-2 text-base text-black">
                            {{ Str::limit($orden->observaciones, 50) }}
                        </td>
                        <td class="px-8 py-2 text-center">
                            <span class="px-4 py-2 rounded-full text-sm font-semibold
                                @if($orden->status === 'pendiente') bg-red-700 text-white
                                @elseif ($orden->status === 'asignado') bg-orange-500 text-black
                                @elseif($orden->status === 'trabajado') bg-yellow-400 text-black
                                @elseif($orden->status === 'liberado') bg-green-500 text-white
                                @elseif($orden->status === 'cancelado') bg-gray-400 text-gray-800
                                @else bg-gray-100 text-gray-800
                                
                                @endif">
                                {{ ucfirst($orden->status) }}
                            </span>

                            <!--
<span class="px-4 py-2 rounded-full text-sm font-semibold 
    @ php 
        $statusColors = [
            'pendiente' => 'bg-red-500 text-white',
            'asignado' => 'bg-green-800 text-black',
            'en proceso' => 'bg-blue-400 text-white',
            'cancelado' => 'bg-gray-400 text-white',
        ];
        $defaultColor = 'bg-gray-100 text-gray-800';
    @ endphp
    { { $statusColors[$orden->status] ?? $defaultColor }}">
    { { $orden->status }}
</span>
-->
                        </td>
                        <td class="px-8 py-2 flex justify-end gap-3">
                            
                            @if(in_array(auth()->user()->role, [  'receptoria', 'compras'] ) )
                            <a href="{{ route('ordenes.imprimir', $orden) }}" 
                               class="text-blue-600 hover:underline text-lg"
                               title="Imprimir"
                               target="_blank">
                                🖨️
                            </a>
                            @endif

                            <!-- Solo puedo editar si Es Asignada y el Rece, Falta validar status -->
                            @if(in_array(auth()->user()->role, ['receptoria',  'agente_aduanal'] ) && $orden->status === 'pendiente'  )
                            <a href="{{ route('ordenes.edit', $orden) }}"
                               class="text-indigo-600 hover:underline text-lg"
                               title="Editar">
                                ✏️
                            </a>
                            @endif

                            @if(in_array(auth()->user()->role, [  'receptoria'] ) && $orden->status === 'pendiente'  )
                            <a href="{{ route('ordenes.add_cuadrillas', $orden) }}"
                               class="text-green-600 hover:underline text-lg"
                               title="Asignar Cuadrillas">
                                👥
                            </a>
                            
                            @endif


                            @if(in_array(auth()->user()->role, [  'receptoria'] ) && $orden->status === 'en_proceso'  )
                            <a href="{{ route('ordenes.add_trabajado', $orden) }}"
                               class="text-green-600 hover:underline text-lg"
                               title="Asgnar a compras">
                                + Enviar
                            </a>
                            @endif

                            <!--@ if(auth()->user()->hasRole(['receptoria', 'compras']))-->
                            <!--button
                                @ click="ordenToDelete = { { $orden->id }};
                                        window.dispatchEvent(new CustomEvent('open-modal', { detail: 'delete-modal' }))"
                                class="text-red-600 hover:underline text-lg"
                                title="Eliminar">
                                🗑️
                            </button-->
                            <!--@ endif-->
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-6 text-center text-black">
                            No hay órdenes registradas con los filtros aplicados.
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>

            {{-- Paginación --}}
            <div class="mt-4 px-8 py-3">
                {{ $ordenes->appends(request()->query())->links() }}
            </div>
        </div>

        {{-- MODAL --}}
        <x-modal name="delete-modal" maxWidth="md">
            <div class="p-6 bg-white rounded-lg">
                <h2 class="text-lg font-medium text-gray-900">
                    Confirmar Eliminación
                </h2>

                <p class="mt-2 text-sm text-gray-600">
                    ¿Estás seguro de que deseas eliminar esta orden?
                </p>

                <div class="mt-6 flex justify-end gap-3">
                    <button
                        @click="ordenToDelete = null;
                                window.dispatchEvent(new CustomEvent('close-modal', { detail: 'delete-modal' }))"
                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                        Cancelar
                    </button>

                    <button
                        @click="deleteOrden()"
                        class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">
                        Eliminar
                    </button>
                </div>
            </div>
        </x-modal>
    </div>
</x-app-layout>
@endif