// resources/views/ordenes/show.blade.php
@extends('layouts.app')

@section('title', 'Ver Orden de Servicio')

@section('header-buttons')
    <a href="{{ route('ordenes.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Información de la Orden #{{ str_pad($orden->id, 6, '0', STR_PAD_LEFT) }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><strong>Agente Aduanal:</strong></label>
                                <p>{{ $orden->agenteAduanal->nombre }}</p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><strong>Fecha:</strong></label>
                                <p>{{ $orden->fecha->format('d/m/Y') }}</p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><strong>Estado:</strong></label>
                                <p>
                                    <span class="badge 
                                        @switch($orden->status)
                                            @case('pendiente') bg-warning @break
                                            @case('proceso') bg-info @break
                                            @case('completado') bg-success @break
                                            @case('cancelado') bg-danger @break
                                        @endswitch">
                                        {{ ucfirst($orden->status) }}
                                    </span>
                                </p>
                            </div>
                        </div>
                        
                        @if($orden->observaciones)
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Observaciones:</strong></label>
                                    <p>{{ $orden->observaciones }}</p>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Sección para Detalles de Orden -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Detalles de la Orden</h5>
                </div>
                <div class="card-body">
                    @if($orden->ordenDetalles->count() > 0)
                        <div class="accordion" id="detallesAccordion">
                            @foreach($orden->ordenDetalles as $index => $detalle)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading{{ $index }}">
                                        <button class="accordion-button {{ $index > 0 ? 'collapsed' : '' }}" 
                                                type="button" data-bs-toggle="collapse" 
                                                data-bs-target="#collapse{{ $index }}" 
                                                aria-expanded="{{ $index === 0 ? 'true' : 'false' }}" 
                                                aria-controls="collapse{{ $index }}">
                                            Detalle {{ $index + 1 }} - 
                                            Proveedor: {{ $detalle->proveedor->nombre }} | 
                                            Cuadrilla: {{ $detalle->cuadrilla->nombre }} | 
                                            Estado: 
                                            <span class="badge 
                                                @switch($detalle->status)
                                                    @case('pendiente') bg-warning @break
                                                    @case('proceso') bg-info @break
                                                    @case('completado') bg-success @break
                                                    @case('cancelado') bg-danger @break
                                                @endswitch ms-2">
                                                {{ ucfirst($detalle->status) }}
                                            </span>
                                        </button>
                                    </h2>
                                    <div id="collapse{{ $index }}" 
                                         class="accordion-collapse collapse {{ $index === 0 ? 'show' : '' }}" 
                                         aria-labelledby="heading{{ $index }}" 
                                         data-bs-parent="#detallesAccordion">
                                        <div class="accordion-body">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Proveedor:</strong></label>
                                                        <p>{{ $detalle->proveedor->nombre }}</p>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Cuadrilla:</strong></label>
                                                        <p>{{ $detalle->cuadrilla->nombre }}</p>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Estado:</strong></label>
                                                        <p>
                                                            <span class="badge 
                                                                @switch($detalle->status)
                                                                    @case('pendiente') bg-warning @break
                                                                    @case('proceso') bg-info @break
                                                                    @case('completado') bg-success @break
                                                                    @case('cancelado') bg-danger @break
                                                                @endswitch">
                                                                {{ ucfirst($detalle->status) }}
                                                            </span>
                                                        </p>
                                                    </div>
                                                </div>
                                                @if($detalle->observaciones)
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label"><strong>Observaciones:</strong></label>
                                                            <p>{{ $detalle->observaciones }}</p>
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                            
                                            <!-- Contenedores del detalle -->
                                            <div class="mt-4">
                                                <h6>Contenedores</h6>
                                                @if($detalle->detalleContenedores->count() > 0)
                                                    <div class="table-responsive">
                                                        <table class="table table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Número</th>
                                                                    <th>Observaciones</th>
                                                                    <th>Estado</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($detalle->detalleContenedores as $contenedor)
                                                                    <tr>
                                                                        <td>{{ $contenedor->numero }}</td>
                                                                        <td>{{ $contenedor->observaciones ?? 'Sin observaciones' }}</td>
                                                                        <td>
                                                                            <span class="badge 
                                                                                @switch($contenedor->status)
                                                                                    @case('pendiente') bg-warning @break
                                                                                    @case('proceso') bg-info @break
                                                                                    @case('completado') bg-success @break
                                                                                    @case('cancelado') bg-danger @break
                                                                                @endswitch">
                                                                                {{ ucfirst($contenedor->status) }}
                                                                            </span>
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                @else
                                                    <p class="text-muted">No hay contenedores registrados para este detalle.</p>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted">No hay detalles registrados para esta orden.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-md-12">
            <a href="{{ route('ordenes.edit', $orden) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Editar
            </a>

            <!-- Para imprimir -->
            <a href="{{ route('ordenes.imprimir', $orden) }}" class="btn btn-info" target="_blank">
                <i class="fas fa-print"></i> Imprimir
            </a>

            <a href="{{ route('ordenes.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Volver
            </a>
        </div>
    </div>

    
@endsection