<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Editar Trabajador
        </h2>
    </x-slot>

    <div class="p-6">
        <div class="bg-white rounded-lg shadow p-6">
            <form method="POST" action="{{ route('trabajadores.update', $trabajador) }}">
                @csrf
                @method('PUT')

                <div class="mb-4">
                    <x-input-label for="nombre" :value="__('Nombre')" />
                    <x-text-input id="nombre" name="nombre" type="text" class="mt-1 block w-full" :value="old('nombre', $trabajador->nombre)" required autofocus autocomplete="nombre"   placeholder="Ej. Carlos Gómez Sánchez"  />
                    <x-input-error :messages="$errors->get('nombre')" class="mt-2" />
                </div>


                        <!-- SELECT de Puestos -->
                        <div class="mb-4">
                            <x-input-label for="puesto_id" :value="__('Puesto')" />
                            <select id="puesto_id" name="puesto_id" 
                                class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                <option value="">Seleccione un puesto</option>
                                @foreach($puestos as $puesto)
                                    <option value="{{ $puesto->id }}" 
                                        {{ old('puesto_id', $trabajador->puesto_id) == $puesto->id ? 'selected' : '' }}>
                                        {{ $puesto->nombre }}
                                    </option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('puesto_id')" class="mt-2" />
                        </div>


                <div class="mb-4">
                    <x-input-label for="observaciones" :value="__('Observaciones')" />
                    <textarea id="observaciones" name="observaciones" class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="4" required>{{ old('observaciones', $trabajador->observaciones) }}</textarea>
                    <x-input-error :messages="$errors->get('observaciones')" class="mt-2" />
                </div>

                <div class="mb-4">
                    <x-input-label for="estado" :value="__('Estado')" />
                    <select id="estado" name="estado" class="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                        <option value="pendiente" {{ old('estado', $trabajador->estado) == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                        <option value="completado" {{ old('estado', $trabajador->estado) == 'completado' ? 'selected' : '' }}>Completado</option>
                    </select>
                    <x-input-error :messages="$errors->get('estado')" class="mt-2" />
                </div>

                <div class="flex items-center justify-end">
                    <a href="{{ route('trabajadores.index') }}" class="mr-4 text-gray-600 hover:text-gray-900">Cancelar</a>
                    <x-primary-button>
                        {{ __('Actualizar Trabajador') }}
                    </x-primary-button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
