<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Usuarios') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="w-full mx-auto px-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg"
                 x-data='{
                     userToDelete: null,

                     async deleteUser() {
                         if (!this.userToDelete) return;

                         try {
                             const response = await fetch("/usuarios/" + this.userToDelete, {
                                 method: "DELETE",
                                 headers: {
                                     "X-CSRF-TOKEN": document.querySelector("meta[name=csrf-token]").content,
                                     "Accept": "application/json",
                                     "X-Requested-With": "XMLHttpRequest"
                                 },
                                 credentials: "same-origin"
                             });

                             if (response.ok) {
                                 document.getElementById("user-" + this.userToDelete)?.remove();

                                 window.dispatchEvent(new CustomEvent("close-modal", {
                                     detail: "delete-modal"
                                 }));

                                 this.userToDelete = null;

                                 window.dispatchEvent(new CustomEvent("show-notification", {
                                     detail: {
                                         message: "¡Usuario eliminado con éxito!",
                                         type: "success"
                                     }
                                 }));
                             } else {
                                 const errorData = await response.json();
                                 alert("Error al eliminar: " + (errorData.message || "Error desconocido"));
                             }
                         } catch (error) {
                             alert("Error de red: " + error.message);
                         }
                     }
                 }'
            >
                <div class="p-6 text-gray-900">
                    <table class="w-full table-auto divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">
                                    Nombre
                                </th>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">
                                    Email
                                </th>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">
                                    Rol
                                </th>
                                <th class="px-6 py-4 text-left text-sm font-medium text-gray-500 uppercase tracking-wider">
                                    Acciones
                                </th>
                            </tr>
                        </thead>

                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($users as $user)
                                <tr id="user-{{ $user->id }}" class="hover:bg-gray-50 transition">
                                    <td class="px-6 py-4 text-base font-medium text-gray-900">
                                        {{ $user->name }}
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-700">
                                        {{ $user->email }}
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-700">
                                        {{ $user->role }}
                                    </td>
                                    <td class="px-6 py-4 text-base font-medium">
                                        <button
                                            @click="
                                                userToDelete = {{ $user->id }};
                                                window.dispatchEvent(
                                                    new CustomEvent('open-modal', { detail: 'delete-modal' })
                                                );
                                            "
                                            class="text-red-600 hover:underline text-lg">
                                            🗑️
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                {{-- MODAL DENTRO DEL MISMO x-data --}}
                <x-modal name="delete-modal" maxWidth="md">
                    <div class="p-6 bg-white rounded-lg">
                        <h2 class="text-lg font-medium text-gray-900">
                            Confirmar Eliminación
                        </h2>

                        <p class="mt-2 text-sm text-gray-600">
                            ¿Estás seguro de que deseas eliminar este usuario?
                        </p>

                        <div class="mt-6 flex justify-end gap-3">
                            <button
                                @click="
                                    userToDelete = null;
                                    window.dispatchEvent(
                                        new CustomEvent('close-modal', { detail: 'delete-modal' })
                                    );
                                "
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                                Cancelar
                            </button>

                            <button
                                @click="deleteUser()"
                                class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">
                                Eliminar
                            </button>
                        </div>
                    </div>
                </x-modal>
            </div>
        </div>
    </div>
</x-app-layout>
