<?php

use App\Http\Controllers\AgenteAduanalController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ServiceOrderController;
use App\Http\Controllers\ApprovalController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\OrdenServiceContenedorController;
use App\Http\Controllers\TrabajadorController;
use App\Http\Controllers\PuestoController;
use App\Http\Controllers\ProveedorContenedorController;
use App\Http\Controllers\DetalleContenedorController;
use App\Http\Controllers\Auth\ChangePasswordController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::get('/waiting-approval', function () {
    return view('waiting-approval');
})->middleware(['auth', 'verified'])->name('waiting.approval');

Route::resource('pedidos-de-servicio', ServiceOrderController::class)->
parameters(['pedidos-de-servicio' => 'serviceOrder'])->middleware(['auth', 'verified']);

Route::middleware(['auth', 'verified'])->group(function () {
    //Route::resource('aprobaciones', ApprovalController::class)->middleware('admin');

    // Estas líneas sustituyen a la anterior en msj
    Route::get('/aprobaciones', [ApprovalController::class, 'index'])->name('aprobaciones.index');
    Route::put('/aprobaciones/{approval}', [ApprovalController::class, 'update'])->name('aprobaciones.update');
    Route::put('/aprobaciones/{reject}', [ApprovalController::class, 'update'])->name('aprobaciones.update');

    Route::resource('usuarios', UserController::class)->middleware('admin');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware('auth')->group(function () { 
    // 1. PRIMERO: Rutas de estadísticas (sin parámetro {orden})
    Route::get('ordenes/estadisticas', [OrdenServiceContenedorController::class, 'estadisticas'])
        ->name('ordenes.estadisticas');

    Route::get('ordenes/estadisticas/data', [OrdenServiceContenedorController::class, 'getEstadisticasData'])
        ->name('ordenes.estadisticas.data');

    Route::get('ordenes/estadisticas/estado', [OrdenServiceContenedorController::class, 'getEstadisticasEstado'])
        ->name('ordenes.estadisticas.estado');

    // 2. DESPUÉS: Rutas que requieren un parámetro {orden}
    Route::get('ordenes/{orden}/imprimir', [OrdenServiceContenedorController::class, 'imprimir'])
        ->name('ordenes.imprimir');
});

// Enví a Cuadrillas
Route::middleware('auth')->group(function () { 
    // Agregar Cuadrillas
    // Ruta GET para mostrar el formulario de agregar cuadrillas
    Route::get('ordenes/{orden}/add_cuadrillas', [OrdenServiceContenedorController::class, 'add_cuadrillas'])
        ->name('ordenes.add_cuadrillas');

    // Ruta PUT para procesar/guardar las cuadrillas
    Route::put('ordenes/{orden}/update_cuadrillas', [OrdenServiceContenedorController::class, 'update_cuadrillas'])
        ->name('ordenes.update_cuadrillas');
});

// Envía a Compras
Route::middleware('auth')->group(function () { 
    // Agregar Cuadrillas
    // Ruta GET para mostrar el formulario de agregar cuadrillas
    Route::get('ordenes/{orden}/add_trabajado', [OrdenServiceContenedorController::class, 'add_trabajado'])
        ->name('ordenes.add_trabajado');

    // Ruta PUT para procesar/guardar las cuadrillas
    Route::put('ordenes/{orden}/update_trabajado', [OrdenServiceContenedorController::class, 'update_trabajado'])
        ->name('ordenes.update_trabajado');
});


// Nota: 9 Febrero 2026, incluyo gráficas
//Route::group(['middleware' => ['role:receptoria,agente_aduanal']], function() {
Route::middleware('auth')->group(function () {
    //Graficas para Blade Opción 1
    Route::get('/ordenes/graficas', [OrdenServiceContenedorController::class, 'graficaOrdenesPorMes'])
        ->name('ordenes.graficas');
    // Si usas la API JSON
    Route::get('/api/ordenes/por-mes', [OrdenServiceContenedorController::class, 'getDatosOrdenesPorMes'])
        ->name('api.ordenes.por-mes');
        //Voy a testear este al último.
    Route::get('/ordenes/grafica_contenedor_mes', [DetalleContenedorController::class, 'graficaPorMes'])
    ->name('ordenes.grafica_contenedor_mes');
});

// Libera Contenedores
//Route::group(['middleware' => ['role:receptoria,agente_aduanal']], function() {
Route::middleware('auth')->group(function () { 
    Route::resource('contenedores', OrdenServiceContenedorController::class)
        ->parameters(['ordenes' => 'orden'])->middleware(['auth', 'verified']);
});


// *************************** Agrego COntenedores
Route::middleware('auth')->group(function () { 
  
    // Si necesitas más rutas para contenedores
    Route::prefix('contenedores')->name('contenedores.')->group(function () {
        
        Route::get('{orden}/vercontenedor', [OrdenServiceContenedorController::class, 'vercontenedor'])
            ->name('vercontenedor');

        // ... otras rutas que necesites
        // Ruta para worked (si es específica)
       // Route::post('worked', [OrdenServiceContenedorController::class, 'worked'])
         //   ->name('worked');
        
        // O si worked necesita ID:
        Route::post('{orden}/worked', [OrdenServiceContenedorController::class, 'worked'])
            ->name('worked');
    });

    // CONTENEDORES - Ruta específica para index2
    Route::get('contenedores', [OrdenServiceContenedorController::class, 'index2'])
        ->name('contenedores.index');
});
// **************************************************************


// Puede ver receptoria y agente_aduanal
//Route::group(['middleware' => ['role:receptoria,agente_aduanal']], function() {
Route::middleware('auth')->group(function () { 
    Route::resource('ordenes', OrdenServiceContenedorController::class)
        ->parameters(['ordenes' => 'orden'])->middleware(['auth', 'verified']);
});

// Puede ver receptoria y agente_aduanal
Route::middleware('auth')->group(function () { 
    Route::resource('trabajadores', TrabajadorController::class)->
    parameters(['trabajadores' => 'trabajador'])->middleware(['auth', 'verified']);
});

// Test; receptoria OK
Route::middleware('auth')->group(function () {
    Route::resource('puestos', PuestoController::class)->
    parameters(['puestos' => 'puesto'])->middleware(['auth', 'verified']);
}); 

// Test: receptoria & agente_aduanal
Route::middleware('auth')->group(function () {
    Route::resource("proveedores", ProveedorContenedorController::class)->
    parameters(['proveedores'=>'proveedor'])->middleware(['auth', 'verified']);
});

// Test: receptoria & agente_aduanal
Route::middleware('auth')->group(function () {
    Route::resource("proveedores", ProveedorContenedorController::class)->
    parameters(['proveedores'=>'proveedor'])->middleware(['auth', 'verified']);
});


Route::middleware('auth')->group(function () {
    Route::resource("agentes", AgenteAduanalController::class)->
    parameters(['agentes'=>'agente'])->middleware(['auth', 'verified']);
});


// Cambio de COntraseña
// Dentro del grupo de rutas protegidas (con middleware auth)
Route::middleware('auth')->group(function () {
    Route::get('/change-password', [ChangePasswordController::class, 'showChangeForm'])
        ->name('password.change');
    
    Route::put('/change-password', [ChangePasswordController::class, 'update'])
        ->name('password.change.update');
});

require __DIR__.'/auth.php';
