<?php if(in_array(auth()->user()->role, ['receptoria', 'compras', 'agente_aduanal'])): ?>
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold text-gray-800">
                Lista de órdenes de servicio de contenedores
            </h2>

            <div class="flex items-center gap-2">

                <!--@ if(in_array(auth()->user()->role, ['receptoria', 'compras']))
                <a href="{ { route('ordenes.estadisticas') }}" 
                    class="bg-white text-black border border-gray-300 px-4 py-1 rounded hover:bg-gray-100">
                    <i class="fas fa-chart-bar"></i> Estadísticas
                </a>
                @ endif-->

                <!-- Permisos de CReación -->
                <?php if(in_array(auth()->user()->role, ['receptoria',  'agente_aduanal'])): ?>
                <a href="<?php echo e(route('ordenes.create')); ?>"
                   class="bg-white text-black border border-gray-300 px-4 py-1 rounded hover:bg-gray-100">
                    ➕ Nueva
                </a>
                <?php endif; ?>

            </div>
        </div>
     <?php $__env->endSlot(); ?>


    


    
    <script>
        function deleteModal() {
            return {
                ordenToDelete: null,

                async deleteOrden() {
                    if (!this.ordenToDelete) return;

                    await fetch(`/ordenes/${this.ordenToDelete}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                            'Accept': 'application/json'
                        }
                    });

                    // quitar fila sin recargar
                    document.getElementById(`orden-${this.ordenToDelete}`)?.remove();

                    // cerrar modal
                    window.dispatchEvent(new CustomEvent('close-modal', {
                        detail: 'delete-modal'
                    }));

                    this.ordenToDelete = null;
                }
            }
        }
    </script>

    <div class="p-3" x-data="deleteModal()">
        <div class="overflow-x-auto bg-white rounded-lg shadow min-h-[80vh] flex flex-col">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Id</th>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Fecha</th>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Agente aduanal</th>
                        <th class="px-8 py-3 text-left text-sm font-semibold uppercase text-black">Observaciones</th>
                        <th class="px-8 py-3 text-center text-sm font-semibold uppercase text-black">Estado</th>
                        <th class="px-8 py-3 text-right text-sm font-semibold uppercase">Acciones</th>
                    </tr>
                </thead>

                <tbody class="divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $ordenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orden): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr id="orden-<?php echo e($orden->id); ?>" class="hover:bg-gray-50 transition">
                        <td class="px-8 py-2 text-base text-black">
                            <?php echo e($orden->id); ?>

                        </td>
                        <td class="px-8 py-2 text-base text-black">
                            <?php echo e(\Carbon\Carbon::parse($orden->fecha)->format('d/m/Y')); ?>

                        </td>
                        <td class="px-8 py-2 text-base text-black">
                            <?php if($orden->agenteAduanal): ?>
                                <?php echo e($orden->agenteAduanal->nombre); ?>

                            <?php else: ?>
                                <span class="text-gray-400">Sin agente</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-8 py-2 text-base text-black">
                            <?php echo e(Str::limit($orden->observaciones, 50)); ?>

                        </td>
                        <td class="px-8 py-2 text-center">
                            <span class="px-4 py-2 rounded-full text-sm font-semibold
                                <?php if($orden->status === 'pendiente'): ?> bg-red-700 text-white
                                <?php elseif($orden->status === 'asignado'): ?> bg-orange-500 text-black
                                <?php elseif($orden->status === 'trabajado'): ?> bg-yellow-400 text-black
                                <?php elseif($orden->status === 'liberado'): ?> bg-green-500 text-white
                                <?php elseif($orden->status === 'cancelado'): ?> bg-gray-400 text-gray-800
                                <?php else: ?> bg-gray-100 text-gray-800
                                
                                <?php endif; ?>">
                                <?php echo e(ucfirst($orden->status)); ?>

                            </span>

                            <!--
<span class="px-4 py-2 rounded-full text-sm font-semibold 
    @ php 
        $statusColors = [
            'pendiente' => 'bg-red-500 text-white',
            'asignado' => 'bg-green-800 text-black',
            'en proceso' => 'bg-blue-400 text-white',
            'cancelado' => 'bg-gray-400 text-white',
        ];
        $defaultColor = 'bg-gray-100 text-gray-800';
    @ endphp
    { { $statusColors[$orden->status] ?? $defaultColor }}">
    { { $orden->status }}
</span>
-->
                        </td>
                        <td class="px-8 py-2 flex justify-end gap-3">
                            
                            <?php if(in_array(auth()->user()->role, [  'receptoria', 'compras'] ) ): ?>
                            <a href="<?php echo e(route('ordenes.imprimir', $orden)); ?>" 
                               class="text-blue-600 hover:underline text-lg"
                               title="Imprimir"
                               target="_blank">
                                🖨️
                            </a>
                            <?php endif; ?>

                            <!-- Solo puedo editar si Es Asignada y el Rece, Falta validar status -->
                            <?php if(in_array(auth()->user()->role, ['receptoria',  'agente_aduanal'] ) && $orden->status === 'pendiente'  ): ?>
                            <a href="<?php echo e(route('ordenes.edit', $orden)); ?>"
                               class="text-indigo-600 hover:underline text-lg"
                               title="Editar">
                                ✏️
                            </a>
                            <?php endif; ?>

                            <?php if(in_array(auth()->user()->role, [  'receptoria'] ) && $orden->status === 'pendiente'  ): ?>
                            <a href="<?php echo e(route('ordenes.add_cuadrillas', $orden)); ?>"
                               class="text-green-600 hover:underline text-lg"
                               title="Asignar Cuadrillas">
                                👥
                            </a>
                            
                            <?php endif; ?>


                            <?php if(in_array(auth()->user()->role, [  'receptoria'] ) && $orden->status === 'en_proceso'  ): ?>
                            <a href="<?php echo e(route('ordenes.add_trabajado', $orden)); ?>"
                               class="text-green-600 hover:underline text-lg"
                               title="Asgnar a compras">
                                + Enviar
                            </a>
                            <?php endif; ?>

                            <!--@ if(auth()->user()->hasRole(['receptoria', 'compras']))-->
                            <!--button
                                @ click="ordenToDelete = { { $orden->id }};
                                        window.dispatchEvent(new CustomEvent('open-modal', { detail: 'delete-modal' }))"
                                class="text-red-600 hover:underline text-lg"
                                title="Eliminar">
                                🗑️
                            </button-->
                            <!--@ endif-->
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-6 py-6 text-center text-black">
                            No hay órdenes registradas con los filtros aplicados.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>

            
            <div class="mt-4 px-8 py-3">
                <?php echo e($ordenes->appends(request()->query())->links()); ?>

            </div>
        </div>

        
        <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['name' => 'delete-modal','maxWidth' => 'md']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'delete-modal','maxWidth' => 'md']); ?>
            <div class="p-6 bg-white rounded-lg">
                <h2 class="text-lg font-medium text-gray-900">
                    Confirmar Eliminación
                </h2>

                <p class="mt-2 text-sm text-gray-600">
                    ¿Estás seguro de que deseas eliminar esta orden?
                </p>

                <div class="mt-6 flex justify-end gap-3">
                    <button
                        @click="ordenToDelete = null;
                                window.dispatchEvent(new CustomEvent('close-modal', { detail: 'delete-modal' }))"
                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                        Cancelar
                    </button>

                    <button
                        @click="deleteOrden()"
                        class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">
                        Eliminar
                    </button>
                </div>
            </div>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php endif; ?><?php /**PATH C:\wamp64\www\blade\estiba_contenedor\contenedor1\resources\views/ordenes/index.blade.php ENDPATH**/ ?>