<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Laravel')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>

    <body class="font-sans antialiased">
        <div
            class="min-h-screen bg-gray-50 flex"
            x-data="sidebarManager()"
            @resize.window="checkScreenSize()"
            :class="{ 'overflow-hidden': sidebarOpen && isMobile }"
        >
            <!-- Left Sidebar Menu - AZUL CORPORATIVO OSCURO -->
            <aside
                class="bg-gradient-to-b from-blue-950 to-blue-900 shadow-2xl
                       transition-all duration-300 ease-in-out
                       fixed md:relative
                       h-screen
                       z-40"
                :class="{
                    'w-64': $data.sidebarOpen && !$data.isMobile,
                    'w-20': !$data.sidebarOpen && !$data.isMobile,
                    'translate-x-0': $data.sidebarOpen && $data.isMobile,
                    '-translate-x-full': !$data.sidebarOpen && $data.isMobile,
                    'w-64': $data.sidebarOpen && $data.isMobile
                }"
            >
                <div class="p-6 h-full flex flex-col">
                    <!-- Logo + Toggle Button -->
                    <div class="mb-6"> <!-- Separación con principal  -->
                        <!-- Logo -->
                        <div class="flex items-center gap-3 mb-8" x-show="$data.sidebarOpen" x-transition>
                            <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 
                                        rounded-xl flex items-center justify-center shadow-lg">
                                <!-- AQUÍ VA TU LOGO -->
                                <span class="text-white font-bold text-xl">LOGO</span>
                            </div>
                            <div>
                                <h1 class="text-white font-bold text-lg tracking-tight">Nombre Empresa</h1>
                                <p class="text-blue-300 text-xs">Sistema de Gestión</p>
                            </div>
                        </div>
                        
                        <!-- Toggle Button -->
                        <button
                            @click="sidebarOpen = !sidebarOpen"
                            class="flex items-center justify-center
                                bg-blue-800 hover:bg-blue-700
                                text-blue-200 hover:text-white
                                rounded-xl
                                transition-all duration-200
                                shadow-md hover:shadow-lg"
                            :class="{
                                'w-12 h-12 mx-auto': !isMobile,
                                'w-10 h-10 fixed top-4 left-4 z-50': isMobile && !sidebarOpen,
                                'w-10 h-10 fixed top-4 left-[16.5rem] z-50': isMobile && sidebarOpen,
                                'hidden': isMobile && sidebarOpen
                            }"
                            :title="sidebarOpen ? 'Cerrar menú' : 'Abrir menú'"
                        >
                            <!-- Usar SVGs en lugar de caracteres especiales -->
                            <svg x-show="!sidebarOpen" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                            <svg x-show="sidebarOpen" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>


        <!-- Botón flotante para móvil (fuera del sidebar) -->
        <button
            x-show="isMobile && !sidebarOpen"
            @click="sidebarOpen = true"
            class="fixed top-4 left-4 z-50
                   w-12 h-12
                   bg-blue-800 hover:bg-blue-700
                   text-blue-200 hover:text-white
                   rounded-xl
                   shadow-lg hover:shadow-xl
                   flex items-center justify-center
                   transition-all duration-200"
            title="Abrir menú"
        >
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
            </svg>
        </button>

        <!-- Botón de cerrar para móvil (dentro del sidebar cuando está abierto) -->
        <button
            x-show="isMobile && sidebarOpen"
            @click="sidebarOpen = false"
            class="absolute top-4 right-4 z-50
                   w-10 h-10
                   bg-blue-800/80 hover:bg-blue-700
                   text-blue-200 hover:text-white
                   rounded-lg
                   flex items-center justify-center
                   transition-all duration-200
                   md:hidden"
            title="Cerrar menú"
        >
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
            </svg>
        </button>

                    <!-- Menú de Navegación -->
                    <nav class="space-y-1 flex-1">
                        <!-- Grupo: Principal -->
                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition> <!--Separación de abajo -->
                            <!--h3 class="text-blue-300   font-semibold   tracking-wider 
                                       mb-0 px-4">
                                Principal
                            </h3-->
                            <div class="space-y-1">
                                <a href="<?php echo e(route('dashboard')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('dashboard') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">📊</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Dashboard
                                    </span>
                                </a>
                            </div>
                        </div>

                        <!-- Grupo: Gestión -->
                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">
                                
                                <?php if( auth()->user()->role === 'agente_aduanal' || auth()->user()->role === 'receptoria' || auth()->user()->role === 'compras' ): ?>
                                <a href="<?php echo e(route('ordenes.index')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('ordenes.index') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">🔧</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Órdenes
                                    </span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">

                                <?php if( auth()->user()->role === 'cuadrilla'  ): ?>
                                <a href="<?php echo e(route('contenedores.index')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('contenedores.index') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">🔧</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Contenedores
                                    </span>
                                </a>
                                <?php endif; ?>

                                <?php if(auth()->user()->role === 'administrador'): ?>
                                <a href="<?php echo e(route('aprobaciones.index')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('aprobaciones.index') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">🔧</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Aprobaciones
                                    </span>
                                </a>
                                <?php endif; ?>

                                <?php if(auth()->user()->role === 'administrador'): ?>
                                <a href="<?php echo e(route('usuarios.index')); ?>"
                                class="flex items-center gap-3 px-4 py-2
                                        text-gray-700
                                        hover:bg-gray-100
                                        rounded-md
                                        <?php echo e(request()->routeIs('usuarios.*') ? 'bg-gray-100' : ''); ?>">
                                    👥
                                    <span x-show="sidebarOpen" x-transition>Usuarios</span>
                                </a>
                                <?php endif; ?>

                            </div>
                        </div>

                        <!-- Grupo: Recursos -->
                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">
                                
                                <?php if(auth()->user()->role === 'receptoria'): ?>
                                <a href="<?php echo e(route('trabajadores.index')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('trabajadores.index') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">👥</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Trabajadores
                                    </span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">

                                <?php if(auth()->user()->role === 'receptoria'): ?>
                                <a href="<?php echo e(route('puestos.index')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('puestos.index') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">💼</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Puestos
                                    </span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">

                                <?php if(auth()->user()->role === 'agente_aduanal' || auth()->user()->role === 'receptoria'): ?>
                                <a href="<?php echo e(route('proveedores.index')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('proveedores.index') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">🏢</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Proveedores
                                    </span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">

                                <?php if(auth()->user()->role === 'agente_aduanal' || auth()->user()->role === 'receptoria'): ?>
                                <a href="<?php echo e(route('agentes.index')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('agentes.index') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">🏢</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Agentes
                                    </span>
                                </a>
                                <?php endif; ?>

                            </div>
                        </div>

                        <!-- Grupo: Reportes -->
                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">

                                <?php if(auth()->user()->role === 'receptoria' || auth()->user()->role === 'compras'): ?>
                                <a href="<?php echo e(route('ordenes.graficas')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('ordenes.graficas') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">📈</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Gráficas
                                    </span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="mb-3" x-show="$data.sidebarOpen" x-transition>
                            <div class="space-y-1.0">

                                <?php if(auth()->user()->role === 'receptoria' || auth()->user()->role === 'compras'): ?>
                                <a href="<?php echo e(route('ordenes.grafica_contenedor_mes')); ?>"
                                   class="flex items-center gap-4 px-4 py-2
                                          text-blue-100 hover:text-white
                                          hover:bg-blue-800/70
                                          rounded-xl
                                          transition-all duration-200
                                          <?php echo e(request()->routeIs('ordenes.grafica_contenedor_mes') ? 'bg-blue-800 border-l-4 border-blue-400' : ''); ?>">
                                    <span class="text-xl">🗂️</span>
                                    <span class="font-medium" x-show="$data.sidebarOpen" x-transition>
                                        Contenedores
                                    </span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>                        
                        
                    </nav>

                    <!-- Pie del menú -->
                    <div class="pt-6 border-t border-blue-800/50" x-show="$data.sidebarOpen" x-transition>
                        <div class="text-white text-xs text-center">
                            v1.0 • © 2026
                        </div>
                    </div>
                </div>
            </aside>

            <!-- Overlay para móvil -->
            <div
                x-show="$data.sidebarOpen && $data.isMobile"
                @click="$data.sidebarOpen = false"
                class="fixed inset-0 bg-black bg-opacity-50 z-30 md:hidden"
                x-transition.opacity
            ></div>

            <!-- Main Content Area -->
            <div class="flex-1 flex flex-col w-full md:w-auto">
                <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <!-- Page Heading -->
                <?php if(isset($header)): ?>
                    <header class="bg-white shadow-sm">
                        <div class="max-w-7xl mx-auto py-3 px-4 sm:px-6 lg:px-8"> <!-- py-6 -->
                            <?php echo e($header); ?>

                        </div>
                    </header>
                <?php endif; ?>

                <main class="flex-1 relative">
                    
                    <?php if(session('success')): ?>
                    <div
                        x-data="{ show: true }"
                        x-init="setTimeout(() => show = false, 3500)"
                        x-show="show"
                        x-transition
                        class="fixed top-6 right-6 z-[99999]"
                    >
                        <div class="flex items-center gap-4
                                    bg-gradient-to-r from-green-500 to-emerald-600 text-white
                                    px-6 py-4
                                    rounded-xl
                                    shadow-2xl
                                    border border-emerald-400/30">
                            <span class="text-2xl">✔</span>
                            <span class="font-semibold text-base">
                                <?php echo e(session('success')); ?>

                            </span>
                        </div>
                    </div>
                    <?php endif; ?>

                    
                    <?php echo e($slot); ?>

                </main>
            </div>
        </div>

        <!-- Script para el manejo del sidebar responsive -->
<script>
function sidebarManager() {
    return {
        sidebarOpen: true,
        isMobile: window.innerWidth < 768,
        
        init() {
            this.checkScreenSize();
            window.addEventListener('resize', () => this.checkScreenSize());
        },
        
        checkScreenSize() {
            const wasMobile = this.isMobile;
            this.isMobile = window.innerWidth < 768;
            
            // Ajustar sidebar según el tamaño de pantalla
            if (this.isMobile) {
                // En móvil, siempre empezar cerrado
                this.sidebarOpen = false;
            } else {
                // En desktop, restaurar estado anterior o abrir por defecto
                if (wasMobile && !this.sidebarOpen) {
                    // Si venía de móvil y estaba cerrado, abrir en desktop
                    this.sidebarOpen = true;
                }
            }
        },
        
        toggleSidebar() {
            this.sidebarOpen = !this.sidebarOpen;
        }
    }
}
</script>

        <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>
</html><?php /**PATH C:\wamp64\www\blade\estiba_contenedor\contenedor1\resources\views/layouts/app.blade.php ENDPATH**/ ?>