
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orden de Servicio #<?php echo e(str_pad("$orden->id", 6, '0', STR_PAD_LEFT)); ?></title>
    <style>
        @page {
            margin: 0.8cm; /* 1.5 */
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            line-height: 1.0; /* 1.4 */
            color: #000;
            background-color: #fff;
        }
        
        .container {
            max-width: 100%;
            margin: 0;
            padding: 0;
        }
        
        .header {
            border-bottom: 3px solid #333;
            padding-bottom: 7px; /* 15 Original*/
            margin-bottom: 5px;  /* 20 */
            position: relative;
        }
        
        /* Estilos para el logotipo */
        .logo-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 150px;
            z-index: 10;
        }
        
        .logo-img {
            max-width: 100%;
            max-height: 80px;
            object-fit: contain;
        }
        
        .logo-text {
            text-align: center;
            margin-bottom: 10px;
            margin-left: 160px; /* Espacio para el logo */
        }
        
        .logo-text h1 {
            font-size: 24px;
            margin: 0;
            color: #2c3e50;
        }
        
        .logo-text p {
            font-size: 14px;
            margin: 5px 0;
            color: #7f8c8d;
        }
        
        .company-info {
            text-align: center;
            margin-bottom: 2px; /* 7 */
            margin-left: 140px; /* 160 */ /* Espacio para el logo */
        }
        
        .document-title {
            text-align: center;
            font-size: 16px; /* 20 */
            font-weight: bold;
            margin: 10px 0; /* 20 */
            color: #2c3e50;
            border-top: 1px solid #2c3e50;
            border-bottom: 1px solid #2c3e50;
            padding: 10px 0;
        }
        
        .order-info {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
            
        }
        
        .order-info th {
            background-color: #f8f9fa;
            text-align: left;
            padding: 5px; /* 8 */
            border: 1px solid #dee2e6;
            font-weight: bold;
            width: 25%;
        }
        .order-info tr{
            padding: 5px;
        }
        
        .order-info td {
            padding: 5px;  /*  8px  */
            border: 1px solid #dee2e6;
        }
        
        .details-section {
            margin: 5px 0; /* 25px */
        }
        
        .section-title {
            background-color: #2c3e50;
            color: white;
            padding: 1px 12px;  /*  padding: 8px 12px;   */
            font-weight: bold;
            margin: 0 0 10px 0;
            border-radius: 3px;
        }
        
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px; /* 10px */
            page-break-inside: avoid;
        }
        
        .details-table th {
            background-color: #34495e;
            color: white;
            text-align: left;
            padding: 3px;  /* 8px */
            border: 1px solid #ddd;
            font-weight: bold;
        }
        
        .details-table td {
            padding: 3px;   /* 8px */
            border: 1px solid #ddd;
        }
        
        .details-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        .status-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-pendiente { background-color: #ffc107; color: #000; }
        .status-proceso { background-color: #17a2b8; color: #fff; }
        .status-completado { background-color: #28a745; color: #fff; }
        .status-cancelado { background-color: #dc3545; color: #fff; }
        
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px solid #333;
            text-align: center;
            font-size: 11px;
            color: #7f8c8d;
        }
        
        .signatures {
            margin-top: 50px;
            page-break-inside: avoid;
        }
        
        .signature-box {
            display: inline-block;
            width: 45%;
            margin: 0 2%;
            text-align: center;
            border-top: 1px solid #000;
            padding-top: 40px;
        }
        
        .totals {
            background-color: #f8f9fa;
            padding: 15px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            margin: 20px 0;
        }
        
        .totals p {
            margin: 5px 0;
            font-weight: bold;
        }
        
        .print-controls {
            text-align: center;
            margin: 20px 0;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        
        @media print {
            .print-controls {
                display: none;
            }
            
            .no-print {
                display: none;
            }
            
            body {
                font-size: 11px;
            }
            
            .details-table {
                font-size: 10px;
            }
            
            .signatures {
                margin-top: 30px;
            }
            
            /* Asegurar que el logo se imprima correctamente */
            .logo-img {
                max-height: 70px !important;
            }
        }
        
        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            opacity: 0.1;
            z-index: -1;
            font-size: 120px;
            font-weight: bold;
            color: #ccc;
            pointer-events: none;
        }
        
        .page-break {
            page-break-before: always;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Controles de impresión (solo se ven en pantalla) -->
        <div class="print-controls no-print">
            <button onclick="window.print()" class="btn-print" style="
                background: #28a745;
                color: white;
                border: none;
                padding: 10px 20px;
                border-radius: 5px;
                cursor: pointer;
                font-size: 16px;
                margin-right: 10px;
            ">
                🖨️ Imprimir
            </button>
            <button onclick="window.history.back()" class="btn-back" style="
                background: #6c757d;
                color: white;
                border: none;
                padding: 10px 20px;
                border-radius: 5px;
                cursor: pointer;
                font-size: 16px;
            ">
                ↩️ Volver
            </button>
            <button onclick="downloadPDF()" class="btn-pdf" style="
                background: #dc3545;
                color: white;
                border: none;
                padding: 10px 20px;
                border-radius: 5px;
                cursor: pointer;
                font-size: 16px;
                margin-left: 10px;
            ">
                📄 Descargar PDF
            </button>
        </div>
        
        <!-- Marca de agua -->
        <div class="watermark">
            ORIGINAL
        </div>
        
        <!-- Encabezado del documento -->
        <div class="header">
            <!-- Logotipo en esquina superior izquierda -->
            <div class="logo-container">
                <!-- Reemplaza esta ruta con la de tu logotipo -->
                <img src="<?php echo e(asset('logo/union.jpg')); ?>" 
                     alt="Logotipo Empresa" 
                     class="logo-img"
                     onerror="this.style.display='none'">
                <!-- Texto alternativo por si la imagen no carga -->
                <div style="display: none; font-size: 16px; font-weight: bold; color: #2c3e50;" 
                     class="logo-alt-text">
                    LOGO EMPRESA
                </div>
            </div>
            
            <div class="logo-text">
                <h3>UNION DE OBREROS, ESTIBADORES, CARGADORES, ABRIDORES, CHECADORES, CLASIFICADORES Y JORNALEROS,
S.C.L. DE COATZACOALCOS, VERACRUZ</h3>
                <!--p>Servicios Logísticos y Aduanales</p-->
            </div>
            
            <div class="company-info">
                <p><strong>Dirección:</strong>  Héroe de Nacozari 418, Esfuerzos de los Hermanos del Trabajo, 96430 Coatzacoalcos, Ver.</p>
                <p><strong>Teléfono:</strong> (52)921 212 0081 | <strong>Email:</strong> estiba_coatza@hotmail.com</p>
                <!--p><strong>RFC:</strong> ESC123456ABC | <strong>Fecha de Impresión:</strong> { { now()->format('d/m/Y H:i') }}</p-->
                <p><strong> </strong> <strong>Fecha de Impresión:</strong> <?php echo e(now()->format('d/m/Y H:i')); ?></p>
            </div>
        </div>
        
        <!-- Título del documento -->
        <div class="document-title">
            ORDEN DE SERVICIO DE CONTENEDORES
        </div>
        
        <!-- Información de la orden -->
        <table class="order-info">
            <tr>
                <th>Número de Orden:</th>
                <td>#<?php echo e(str_pad($orden->id, 6, '0', STR_PAD_LEFT)); ?></td>
                <th>Fecha de Servicio:</th>
                <td><?php echo e($orden->fecha->format('d/m/Y')); ?></td>
            </tr>
            <tr>
                <th>Agente Aduanal:</th>
                <td colspan="3"><?php echo e($orden->agenteAduanal->nombre); ?></td>
            </tr>
            <tr>
                <th>Estado de la Orden:</th>
                <td>
                    <span class="status-badge status-<?php echo e($orden->status); ?>">
                        <?php echo e(strtoupper($orden->status)); ?>

                    </span>
                </td>
                <th>Total Contenedores:</th>
                <td><?php echo e($totalContenedores); ?></td>
            </tr>
            <?php if($orden->observaciones): ?>
            <tr>
                <th>Observaciones:</th>
                <td colspan="3"><?php echo e($orden->observaciones); ?></td>
            </tr>
            <?php endif; ?>
        </table>
        
        <!-- Detalles de la orden -->
        <div class="details-section">
            <h3 class="section-title">DETALLES DEL SERVICIO</h3>
            
            <?php if($orden->ordenDetalles->count() > 0): ?>
                <?php $__currentLoopData = $orden->ordenDetalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="detalle-item" style="margin-bottom: 25px; page-break-inside: avoid;">
                        <table class="details-table">
                            <thead>
                                <tr>
                                    <th colspan="4" style="background-color: #3498db;">
                                        DETALLE <?php echo e($index + 1); ?> 
                                        <span style="float: right;">
                                            Estado: 
                                            <span class="status-badge status-<?php echo e($detalle->status); ?>">
                                                <?php echo e(strtoupper($detalle->status)); ?>

                                            </span>
                                        </span>
                                    </th>
                                </tr>
                                <tr>
                                    <th>Proveedor</th>
                                    <th>Cuadrilla</th>
                                    <th>Observaciones</th>
                                    <th>Contenedores</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><?php echo e($detalle->proveedor->nombre); ?></td>
                                    <!--td>{ { $detalle->cuadrilla->nombre }}</td-->
                                    <td><?php echo e($detalle->observaciones ?: 'Sin observaciones'); ?></td>
                                    <td><?php echo e($detalle->detalleContenedores->count()); ?></td>
                                </tr>
                            </tbody>
                        </table>
                        
                        <!-- Contenedores del detalle -->
                        <?php if($detalle->detalleContenedores->count() > 0): ?>
                            <table class="details-table" style="margin-top: 10px;">
                                <thead>
                                    <tr>
                                        <th colspan="4">CONTENEDORES ASIGNADOS</th>
                                    </tr>
                                    <tr>
                                        <th>#</th>
                                        <th>Número de Contenedor</th>
                                        <th>Estado</th>
                                        <th>Observaciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $detalle->detalleContenedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contenedorIndex => $contenedor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($contenedorIndex + 1); ?></td>
                                        <td><strong><?php echo e($contenedor->numero); ?></strong></td>
                                        <td>
                                            <span class="status-badge status-<?php echo e($contenedor->status); ?>">
                                                <?php echo e(strtoupper($contenedor->status)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($contenedor->observaciones ?: '-'); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <p style="text-align: center; color: #7f8c8d; font-style: italic;">
                                No hay contenedores registrados para este detalle
                            </p>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Separador entre detalles (excepto el último) -->
                    <?php if(!$loop->last): ?>
                        <hr style="border: 1px dashed #ddd; margin: 20px 0;">
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <p style="text-align: center; color: #7f8c8d; font-style: italic;">
                    No hay detalles registrados para esta orden
                </p>
            <?php endif; ?>
        </div>
        
        <!-- Resumen de totales -->
        <div class="totals">
            <p>RESUMEN DE LA ORDEN</p>
            <p>Total de Detalles: <?php echo e($orden->ordenDetalles->count()); ?></p>
            <p>Total de Contenedores: <?php echo e($totalContenedores); ?></p>
            <p>Fecha de Generación: <?php echo e(now()->format('d/m/Y H:i')); ?></p>
        </div>
        
        <!-- Firmas -->
        <div class="signatures">
            <div class="signature-box">
                <p>________________________________</p>
                <p><strong>RESPONSABLE DEL SERVICIO</strong></p>
                <p>Nombre y Firma</p>
            </div>
            
            <div class="signature-box">
                <p>________________________________</p>
                <p><strong>AGENTE ADUANAL</strong></p>
                <p>Nombre y Firma</p>
            </div>
        </div>
        
        <!-- Pie de página -->
        <div class="footer">
            <p>Documento generado automáticamente por el Sistema de Gestión de Contenedores</p>
            <p>Este documento es válido por 30 días a partir de su fecha de emisión</p>
            <p>Página 1 de 1</p>
        </div>
    </div>
    
    <script>
        // Función para imprimir
        function imprimirDocumento() {
            window.print();
        }
        
        // Función para descargar como PDF (usando html2pdf)
        function downloadPDF() {
            // Mostrar mensaje
            alert('Para descargar como PDF, use la opción "Guardar como PDF" en el diálogo de impresión o instale html2pdf.js');
            
            // Alternativa con html2pdf (requiere librería externa)
            // const element = document.body;
            // html2pdf().from(element).save();
        }
        
        // Auto-imprimir si se solicita
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.get('autoPrint') === 'true') {
            window.print();
        }
        
        // Mostrar texto alternativo si la imagen no carga
        document.addEventListener('DOMContentLoaded', function() {
            const logoImg = document.querySelector('.logo-img');
            const logoAltText = document.querySelector('.logo-alt-text');
            
            if (logoImg && logoAltText) {
                logoImg.onerror = function() {
                    this.style.display = 'none';
                    logoAltText.style.display = 'block';
                };
            }
        });
        
        // Detectar cuando se cierra el diálogo de impresión
        window.onafterprint = function() {
            console.log('Impresión completada');
        };
    </script>
    
    <!-- Incluir html2pdf (opcional) -->
    <!--
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    -->
</body>
</html><?php /**PATH C:\wamp64\www\blade\estiba_contenedor\contenedor1\resources\views/ordenes/imprimir.blade.php ENDPATH**/ ?>