// resources/views/ordenes/show.blade.php


<?php $__env->startSection('title', 'Ver Orden de Servicio'); ?>

<?php $__env->startSection('header-buttons'); ?>
    <a href="<?php echo e(route('ordenes.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Información de la Orden #<?php echo e(str_pad($orden->id, 6, '0', STR_PAD_LEFT)); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><strong>Agente Aduanal:</strong></label>
                                <p><?php echo e($orden->agenteAduanal->nombre); ?></p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><strong>Fecha:</strong></label>
                                <p><?php echo e($orden->fecha->format('d/m/Y')); ?></p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><strong>Estado:</strong></label>
                                <p>
                                    <span class="badge 
                                        <?php switch($orden->status):
                                            case ('pendiente'): ?> bg-warning <?php break; ?>
                                            <?php case ('proceso'): ?> bg-info <?php break; ?>
                                            <?php case ('completado'): ?> bg-success <?php break; ?>
                                            <?php case ('cancelado'): ?> bg-danger <?php break; ?>
                                        <?php endswitch; ?>">
                                        <?php echo e(ucfirst($orden->status)); ?>

                                    </span>
                                </p>
                            </div>
                        </div>
                        
                        <?php if($orden->observaciones): ?>
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Observaciones:</strong></label>
                                    <p><?php echo e($orden->observaciones); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Sección para Detalles de Orden -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Detalles de la Orden</h5>
                </div>
                <div class="card-body">
                    <?php if($orden->ordenDetalles->count() > 0): ?>
                        <div class="accordion" id="detallesAccordion">
                            <?php $__currentLoopData = $orden->ordenDetalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading<?php echo e($index); ?>">
                                        <button class="accordion-button <?php echo e($index > 0 ? 'collapsed' : ''); ?>" 
                                                type="button" data-bs-toggle="collapse" 
                                                data-bs-target="#collapse<?php echo e($index); ?>" 
                                                aria-expanded="<?php echo e($index === 0 ? 'true' : 'false'); ?>" 
                                                aria-controls="collapse<?php echo e($index); ?>">
                                            Detalle <?php echo e($index + 1); ?> - 
                                            Proveedor: <?php echo e($detalle->proveedor->nombre); ?> | 
                                            Cuadrilla: <?php echo e($detalle->cuadrilla->nombre); ?> | 
                                            Estado: 
                                            <span class="badge 
                                                <?php switch($detalle->status):
                                                    case ('pendiente'): ?> bg-warning <?php break; ?>
                                                    <?php case ('proceso'): ?> bg-info <?php break; ?>
                                                    <?php case ('completado'): ?> bg-success <?php break; ?>
                                                    <?php case ('cancelado'): ?> bg-danger <?php break; ?>
                                                <?php endswitch; ?> ms-2">
                                                <?php echo e(ucfirst($detalle->status)); ?>

                                            </span>
                                        </button>
                                    </h2>
                                    <div id="collapse<?php echo e($index); ?>" 
                                         class="accordion-collapse collapse <?php echo e($index === 0 ? 'show' : ''); ?>" 
                                         aria-labelledby="heading<?php echo e($index); ?>" 
                                         data-bs-parent="#detallesAccordion">
                                        <div class="accordion-body">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Proveedor:</strong></label>
                                                        <p><?php echo e($detalle->proveedor->nombre); ?></p>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Cuadrilla:</strong></label>
                                                        <p><?php echo e($detalle->cuadrilla->nombre); ?></p>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Estado:</strong></label>
                                                        <p>
                                                            <span class="badge 
                                                                <?php switch($detalle->status):
                                                                    case ('pendiente'): ?> bg-warning <?php break; ?>
                                                                    <?php case ('proceso'): ?> bg-info <?php break; ?>
                                                                    <?php case ('completado'): ?> bg-success <?php break; ?>
                                                                    <?php case ('cancelado'): ?> bg-danger <?php break; ?>
                                                                <?php endswitch; ?>">
                                                                <?php echo e(ucfirst($detalle->status)); ?>

                                                            </span>
                                                        </p>
                                                    </div>
                                                </div>
                                                <?php if($detalle->observaciones): ?>
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label"><strong>Observaciones:</strong></label>
                                                            <p><?php echo e($detalle->observaciones); ?></p>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- Contenedores del detalle -->
                                            <div class="mt-4">
                                                <h6>Contenedores</h6>
                                                <?php if($detalle->detalleContenedores->count() > 0): ?>
                                                    <div class="table-responsive">
                                                        <table class="table table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Número</th>
                                                                    <th>Observaciones</th>
                                                                    <th>Estado</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php $__currentLoopData = $detalle->detalleContenedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contenedor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <tr>
                                                                        <td><?php echo e($contenedor->numero); ?></td>
                                                                        <td><?php echo e($contenedor->observaciones ?? 'Sin observaciones'); ?></td>
                                                                        <td>
                                                                            <span class="badge 
                                                                                <?php switch($contenedor->status):
                                                                                    case ('pendiente'): ?> bg-warning <?php break; ?>
                                                                                    <?php case ('proceso'): ?> bg-info <?php break; ?>
                                                                                    <?php case ('completado'): ?> bg-success <?php break; ?>
                                                                                    <?php case ('cancelado'): ?> bg-danger <?php break; ?>
                                                                                <?php endswitch; ?>">
                                                                                <?php echo e(ucfirst($contenedor->status)); ?>

                                                                            </span>
                                                                        </td>
                                                                    </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                <?php else: ?>
                                                    <p class="text-muted">No hay contenedores registrados para este detalle.</p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No hay detalles registrados para esta orden.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-md-12">
            <a href="<?php echo e(route('ordenes.edit', $orden)); ?>" class="btn btn-warning">
                <i class="fas fa-edit"></i> Editar
            </a>

            <!-- Para imprimir -->
            <a href="<?php echo e(route('ordenes.imprimir', $orden)); ?>" class="btn btn-info" target="_blank">
                <i class="fas fa-print"></i> Imprimir
            </a>

            <a href="<?php echo e(route('ordenes.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Volver
            </a>
        </div>
    </div>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\blade\estiba_contenedor\contenedor1\resources\views/ordenes/show.blade.php ENDPATH**/ ?>