<?php

use App\Models\User;
use App\Models\Approval;
use Illuminate\Foundation\Testing\RefreshDatabase;

uses(RefreshDatabase::class);

test('bienvenido page can be rendered with session data', function () {
    $registrationData = [
        'name' => 'Test User',
        'email' => 'test@example.com',
        'password' => bcrypt('password'),
    ];

    session(['registration_data' => $registrationData]);

    $response = $this->get('/bienvenido');

    $response->assertStatus(200);
    $response->assertViewIs('bienvenido');
});

test('bienvenido creates user and approval, clears session', function () {
    $registrationData = [
        'name' => 'Test User',
        'email' => 'test@example.com',
        'password' => bcrypt('password'),
    ];

    session(['registration_data' => $registrationData]);

    $this->assertDatabaseMissing('users', ['email' => 'test@example.com']);
    $this->assertDatabaseMissing('approvals', ['user_id' => 1]);

    $response = $this->get('/bienvenido');

    $response->assertStatus(200);
    $this->assertDatabaseHas('users', ['email' => 'test@example.com', 'approved' => false]);
    $this->assertDatabaseHas('approvals', ['requested_role' => 'compras', 'status' => 'pending']);
    $this->assertNull(session('registration_data'));
});

test('bienvenido redirects if no session data', function () {
    $response = $this->get('/bienvenido');

    $response->assertRedirect(route('register'));
    $response->assertSessionHasErrors('error');
});
