<?php

use App\Models\ServiceOrder;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;

uses(RefreshDatabase::class);

test('compras role can delete service order', function () {
    // Create a user with 'compras' role
    $comprasUser = User::factory()->create(['role' => 'compras', 'approved' => true]);

    // Create a service order
    $serviceOrder = ServiceOrder::factory()->create();

    // Act as the compras user and attempt to delete the service order (AJAX request)
    $response = $this->actingAs($comprasUser)
                     ->withHeaders(['Accept' => 'application/json'])
                     ->delete("/pedidos-de-servicio/{$serviceOrder->id}");

    // Assert that the response is successful (JSON response for AJAX)
    $response->assertStatus(200);
    $response->assertJson(['message' => '¡Orden eliminada con éxito!']);

    // Assert that the service order was deleted from the database
    $this->assertDatabaseMissing('service_orders', ['id' => $serviceOrder->id]);
});

test('non-compras role cannot delete service order', function () {
    // Create a user with a different role
    $otherUser = User::factory()->create(['role' => 'receptoria', 'approved' => true]);

    // Create a service order
    $serviceOrder = ServiceOrder::factory()->create();

    // Act as the other user and attempt to delete the service order
    $response = $this->actingAs($otherUser)->delete("/pedidos-de-servicio/{$serviceOrder->id}");

    // Assert that access is denied
    $response->assertStatus(403);

    // Assert that the service order still exists
    $this->assertDatabaseHas('service_orders', ['id' => $serviceOrder->id]);
});
