<?php

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;

uses(RefreshDatabase::class);

test('admin can view only approved users', function () {
    // Create an approved user
    $approvedUser = User::factory()->create(['approved' => true]);

    // Create an unapproved user
    $unapprovedUser = User::factory()->create(['approved' => false]);

    // Create an admin user
    $admin = User::factory()->create(['role' => 'administrador', 'approved' => true]);

    $response = $this->actingAs($admin)->get('/usuarios');

    $response->assertStatus(200);
    $response->assertViewHas('users', function ($users) use ($approvedUser, $unapprovedUser) {
        // Check that approved user is in the list
        $approvedInList = $users->contains('id', $approvedUser->id);
        // Check that unapproved user is not in the list
        $unapprovedInList = $users->contains('id', $unapprovedUser->id);

        return $approvedInList && !$unapprovedInList;
    });
});
