<?php
/* 
KIT DE INTEGRACION PHP para CFID 4.0
versión 1.0
Integración de Cancelación de CFDI
Licencia: MIT - https://opensource.org/licenses/MIT
Profact - La forma más simple de facturar
*/

/*
  Notas desarrollador:
  Recibir: 
  rfc, uuid, motivo, uuid_nuevo
*/
  $rfc       = "";
  $uuid      = "";
  $motivo    = "";
  $uuid_nuevo= "";
  $folio     = "";
  $serie     = "";
  $tipo      = "";

  if (isset($_POST["rfc"]) && isset($_POST["uuid"])  ){
    $rfc      = $_POST["rfc"];
    $uuid     = $_POST["uuid"];
    $motivo   = $_POST["motivo"];
    $uuid_nuevo = $_POST["uuid_nuevo"];
    $folio    = $_POST["folio"];
    $serie    = $_POST["serie"];
    $tipo     = $_POST["tipo"];
    /*echo "
    RFC:    $rfc 
    UUID N:$uuid_nuevo
    ";*/
    cancela_cfdi($rfc, $uuid, $motivo, $uuid_nuevo,  $folio, $serie, $tipo ); 
  }


function cancela_cfdi($rfcEmisor, $folioUUID, $motivoCancelacion, $uuid_nuevo,  $folio, $serie, $tipo ){
    /* Ruta del servicio de integracion*/
    //$ws = "https://pruebas.timbracfdi33.mx/Timbrado.asmx?wsdl";/*<- Esta ruta es para el servicio de pruebas, para pasar a productivo cambiar por https://v2.timbracfdi33.mx:1449/Timbrado.asmx*/
    $ws = "https://timbracfdi33.mx:1449/Timbrado.asmx?wsdl"; // ?wsdl
    $response = '';

    /* El servicio para cancelar un cfdi previamente timbrado recibe 5 parámetros*/

    /*Nombre del usuario integrador asignado, para efecto de pruebas utilizaremos 'mvpNUXmQfK8=' <- Este usuario es para el servicio de pruebas, para pasar a productivo cambiar por el que le asignarán posteriormente*/
    //$usuarioIntegrador = 'mvpNUXmQfK8=';
    $usuarioIntegrador = 'xBPCp1RIT38jOmT9bdzmtw==';

    /*Rfc del Emisor que emitió el comprobante*/

    /*Folio fiscal(UUID) del comprobante a cancelar, deberá ser uno válido de los que hayamos timbrado previamente en pruebas*/
    //$folioUUID = strtoupper('16e1a0f4-33d1-463c-94fb-7a86e373f7aa');
    $folioUUID = strtoupper($folioUUID.'');
    //echo "$rfcEmisor $folioUUID";

    /*MotivoCancelacion*/

    /*FolioUUID Sustitucion*/
    $folioUUIDSustitucion = $uuid_nuevo.'';

    try{
        $params = array();
        /*Nombre del usuario integrador asignado, para efecto de pruebas utilizaremos 'mvpNUXmQfK8='*/
        $params['usuarioIntegrador'] = $usuarioIntegrador;
        /* Rfc emisor que emitió el comprobante*/
        $params['rfcEmisor'] = $rfcEmisor;
        /*Folio fiscal del comprobante a cancelar*/
        $params['folioUUID'] = $folioUUID;
        /*MotivoCancelacion*/
        $params['motivoCancelacion'] = $motivoCancelacion;

        /*FolioUUID Sustitucion*/
        if (strlen($folioUUIDSustitucion)> 20)
            $params['folioUUIDSustitucion'] = $folioUUIDSustitucion;

        $context = stream_context_create(array(
            'ssl' => array(
                // set some SSL/TLS specific options
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => false  //--> solamente true en ambiente de pruebas
            ),
        	'http' => array(
                    'user_agent' => 'PHPSoapClient'
                    )
         ) );
        $options =array();
        $options['stream_context'] = $context;
        $options['cache_wsdl']= 1; //WSDL_CACHE_MEMORY;
        $options['trace']= 1; //true;
        $options['exceptions'] = true; // No existía

        libxml_disable_entity_loader(false); // true <---- Esta parte fue la que me perimitó

        $client = new SoapClient($ws,$options);
        $response = $client->__soapCall('CancelaCFDI40', array('parameters' => $params)); 
    } catch (SoapFault $fault) {
    	echo "SOAPFault: ".$fault->faultcode."-".$fault->faultstring."\n";
    }
    /*Obtenemos resultado del response*/
    $tipoExcepcion = $response->CancelaCFDIResult->anyType[0]; 
    $numeroExcepcion = $response->CancelaCFDIResult->anyType[1]; 
    $descripcionResultado = $response->CancelaCFDIResult->anyType[2]; 
    $xmlTimbrado = $response->CancelaCFDIResult->anyType[3]; 
    $codigoQr = $response->CancelaCFDIResult->anyType[4]; 
    $cadenaOriginal = $response->CancelaCFDIResult->anyType[5]; 

    $response = json_decode(json_encode($response),true);
    
    $respuesta = $response["CancelaCFDI40Result"]["anyType"][1]; 
    
    // 330280 Cancelado   ||  330279 En Proceso de cancelación
    if($respuesta == "330280") {
    /*El comprobante erá cancelado*/
        if ($tipo == "I"){
            include_once("../factura/sql_factura.php");
            cancelar_factura_funcion($folio, $serie);
        }
        if ($tipo == "P"){
            include_once("../factura/sql_facturapago.php");
            cancelar_factura_funcion($folio, $serie);
        }

        // print_r("El comprobante será cancelado");
        $return_arr = array(
            'Exito'       => "Exito",
            'resultado'   => "El comprobante será cancelado" 
        );
        echo json_encode($return_arr);

    } else { 
        //print_r($response);
        //print_r($descripcionResultado);
        $return_arr = array(
            'Error'       => "Error",
            'resultado'   => $respuesta." - ".$response["CancelaCFDI40Result"]["anyType"][2]
        );
        echo json_encode($return_arr);

    }
}

/* Codigos del nuevo proceso de cancelación
0                El comprobante será cancelado (Cancelado sin entrar en el nuevo esquema)
16              Emisor no registrado.
21              Token de integrador o contraseña incorrectos
202            UUID Previamente cancelado
20001         Error no controlado
20020         Documento no encontrado en base de datos...
330279       Comprobante ya está en proceso de cancelación.
330280       El comprobante será cancelado    
330242       Inexistente(El comprobante no existe aun dentro del sistema del SAT)
330280       EnEsperaDeAceptacion(En proceso de cancelación)
330279       EnEsperaDeAceptacion(En proceso de cancelación, ya estaba en proceso)
330278       NoCancelable(No cancelable debido a CFDIs relacionados)
*/
// 110 Líneas de Código
?>